/***************************************************************************
                          hebSegment.h - Hebrew substring handling
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "hebSegment.h"
#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "langdep.h"
#include "aDictionary.h"
#include "HebrewEditor.h"

#define SETHEBREW_S "\\sethebrew "
#define UNSETHEBREW_S "\\unsethebrew "
#define ITEM_S "\\item "
#define SETHEBREW "\\sethebrew"
#define UNSETHEBREW "\\unsethebrew"
#define ITEM "\\item"

//char hebSegment::buffer[MAX_BUFF_LEN] ;

void modeStack::copy(modeStack& stack)
{
   while (stack.stackPointer > real_size) {
       real_size = stack.real_size ;
       delete data ;
       data = new modeStackElement[real_size] ;
   }
   for (int i=0; i<stack.stackPointer; i++)
        data[i] = stack.data[i] ;
   stackPointer = stack.stackPointer ;
}

int modeStack::isEqual(modeStack& stack)
{
    if (stackPointer != stack.stackPointer)
       return 0 ;

    for (int i=0; i<stackPointer; i++)
         if (!data[i].isEqual(stack.data[i]))
             return 0 ;

    return 1 ;
}

#define PREPEND(x)    strcpy(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;\
                      sprintf(tmpStack[tmpTop],"%s%s",(char *)((const char *)(x)),tmpStack[tmpTop+1]) ;
/*
#define PREPEND(x)    strcpy(tmpStack[tmpTop+1], tmpStack[tmpTop]) ; \
                                           strcpy(tmpStack[tmpTop], (char *)(const char *)(x)) ; \
                                           strcat(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
*/
#define APPEND(x) strcat(tmpStack[tmpTop], (char *)(const char *)(x)) ;

#define APPEND_CHAR(c) { int l=strlen(tmpStack[tmpTop]) ; tmpStack[tmpTop][l]=(c) ; tmpStack[tmpTop][l+1]='\0' ; }
#define PREPEND_CHAR(c)   strcpy(tmpStack[tmpTop+1],tmpStack[tmpTop]) ; \
                      sprintf(tmpStack[tmpTop], "%c%s",c,tmpStack[tmpTop+1]) ;
/*
#define PREPEND_CHAR(c)   tmpStack[tmpTop+1][0]=(c) ; tmpStack[tmpTop+1][1] = '\0' ; \
                                                        strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ; \
                                                        strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
*/
hebSegment::hebSegment(HebrewEditor *he, const char *t1,int from, int startHebrew, Screen &scr, int margin, int comment,
         int length_lim, modeStack &stack, int show_line_end_marks, int activeSpelling) :
         he(he),
         wrongSpelling(0) ,
         modeChange(stack.majorMode()), modeChanged(0), _margin(margin) , _comment(comment),
         last_length_limit(length_lim)
{
//   char sseparator = scr.special_separator ;
   char left_end_mark = scr.get_left_end_mark() ;
   char right_end_mark = scr.get_right_end_mark() ;

   static char tmpStack[MAX_LANGUAGE_DEPTH][MAX_SCREEN_WIDTH] ;
   Locations *locStack[MAX_LANGUAGE_DEPTH] ;
   aString lastWord ;
   Locations lastLocations , tmpLocation ;
   int length_limit = length_lim - margin ;
   int tmpTop=0 ;
   char *t = (char *)t1 + from ;
    char *ptr = (char *)t ;
    char *oldptr = ptr ;
    char *lastWordPtr = ptr ;
    int token ;
    int cont=1 ;
    _length = 0 ;
   int sepcount = 0 ;
   int firstCommand ;

   int margin_save = _margin ;
   int comment_save = _comment ;

   int last_time_a_start_segment_was_inserted = 0 ;
   char *oldptr_at_last_segment_insertion = 0 ;
   char *tmpStack_at_last_segment_insertion = 0 ;
   Locations *locStack_at_last_segment_insertion = 0 ;

   last_mode_stack.copy(stack) ;

   tmpStack[tmpTop][0] = '\0' ;
   locStack[tmpTop] = new Locations(0) ;
   lastLocations.init(0) ;
    _separate_command = 0 ;
    token = _getNextToken(&ptr,stack) ;

    while ((ptr - t <= length_limit-(_separate_command+sepcount+1)) && cont && *oldptr && token) {
          if (_comment < 0) _comment = _findCommentStart(t,oldptr) ;
          switch(token) {
             case SEGMENT_START:
             case HEBREW_SEGMENT_START:
             case ENGLISH_SEGMENT_START:
             case MATH_SEGMENT_START:
             case MATH_SEGMENT_START2:
                if (!from) {
                   if (_areAllWhiteSpaces(t, oldptr)) {
                       _margin = (oldptr-t) - MARGIN_FIX  ;
                       if (_margin < 0) _margin = 0 ;
                       if (_margin > length_limit/2) _margin = length_limit/2 ;
                   }
                }
                firstCommand = 0 ;
                if (!from && _areAllWhiteSpaces(t,oldptr)) firstCommand = 1 ;
                lastWordPtr = ptr ;
                if ((lastWord.length())) {
                   if (stack.topMode() == StrHebrew) {
                     if (!activeSpelling || (he->hebrewDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                      PREPEND(lastWord) ;
                      locStack[tmpTop]->addLeft(lastLocations) ;
                   } else {
                     if (!activeSpelling || (he->englishDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                      APPEND(lastWord) ;
                      locStack[tmpTop]->addRight(lastLocations) ;
                   }
                   lastWord="" ;
                }
                // TAKE CARE OF BACKTRACKING HERE
                last_time_a_start_segment_was_inserted = 1 ;
                oldptr_at_last_segment_insertion = oldptr ;
                if (tmpStack_at_last_segment_insertion)
                  delete tmpStack_at_last_segment_insertion ;
                if (locStack_at_last_segment_insertion)
                  delete locStack_at_last_segment_insertion ;
                tmpStack_at_last_segment_insertion = strdup(tmpStack[tmpTop]) ;
                locStack_at_last_segment_insertion = new Locations(*locStack[tmpTop]) ;

                if (stack.topMode() == StrEnglish) {
                  if (*buffer) {
                    int code = INVALID_LAXET_COMMAND ;
                    if (activeSpelling && (he->laxetDictionary->findMatch(buffer))) code = VALID_LAXET_COMMAND ;
                    else wrongSpelling = 1 ;
                    if (!activeSpelling) code = 0 ;
                    char opener[2] ;
                    strcpy(opener, buffer+strlen(buffer)-1) ;
                    buffer[strlen(buffer)-1] = '\0' ;
                      APPEND(buffer) ;
                      APPEND(opener) ;
                      locStack[tmpTop]->addRight(buffer, StrEnglish,code) ;
                      locStack[tmpTop]->addRight(opener, StrEnglish) ;
                  } else { // this is a  transition from english to hebrew with no real sign from the text, other than hebrew letters
//                     int l = strlen(tmpStack[tmpTop]) ;
//                     tmpStack[tmpTop][l++] = sseparator ;
//                     tmpStack[tmpTop][l] = '\0' ;
//                    locStack[tmpTop]->addSplitsRight(1,StrEnglish) ;
//                    sepcount++ ;
                  }
                } else { // stack.topMode() == StrHebrew
                if (*buffer) {
                    int code = INVALID_LAXET_COMMAND ;
                    if (activeSpelling && (he->laxetDictionary->findMatch(buffer))) code = VALID_LAXET_COMMAND ;
                    else wrongSpelling = 1 ;
                    if (!activeSpelling) code = 0 ;
                    char opener[2] ;
                    strcpy(opener, buffer+strlen(buffer)-1) ;
                    buffer[strlen(buffer)-1] = '\0' ;
                    strcpy(tmpStack[tmpTop+1], reverse(opener)) ;
                    strcat(tmpStack[tmpTop+1], buffer) ;
                    if (!firstCommand) {
//                        int l = strlen(tmpStack[tmpTop+1]) ;
//                        tmpStack[tmpTop+1][l] = sseparator ;
//                        tmpStack[tmpTop+1][l+1] = '\0' ;
                        strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                        strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
//                        sepcount++ ;
//                        locStack[tmpTop]->addSplitsLeft(1, StrHebrew) ;
                    } else {
                          strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                          strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
                    }

                       locStack[tmpTop]->addLeft(buffer,StrEnglish,code) ;
                       locStack[tmpTop]->addLeft(opener,StrEnglish) ;
                  } else { // buffer is empty
//                      PREPEND_CHAR(sseparator) ;
//                      sepcount++ ;
//                      locStack[tmpTop]->addSplitsLeft(1, StrHebrew) ;
                  }
                }
                tmpTop++ ;
                tmpStack[tmpTop][0] = '\0' ;
                locStack[tmpTop] = new Locations(locStack[tmpTop-1]->last()) ;
                lastLocations.init(locStack[tmpTop-1]->last()) ;
                switch (token) {
                   case HEBREW_SEGMENT_START:
                       if (*buffer)
                            stack.push(StrHebrew, "}", locStack[tmpTop-1]->last(),0,2) ;
                       else
                            stack.push(StrHebrew, "", locStack[tmpTop-1]->last(),0,1) ;
                    break ;

                    case ENGLISH_SEGMENT_START:
                        if (*buffer)
                            stack.push(StrEnglish, "}", locStack[tmpTop-1]->last(),0,2) ;
                        else
                            stack.push(StrEnglish, "", locStack[tmpTop-1]->last(),0,1) ;
                     break ;
                     case MATH_SEGMENT_START:
                            stack.push(StrEnglish, "$", locStack[tmpTop-1]->last(), 1) ;
                     break ;
                     case MATH_SEGMENT_START2:
                            stack.push(StrEnglish, "$$", locStack[tmpTop-1]->last(), 1) ;
                     break ;
                     default:
                            stack.push(stack.topMode(), reverse(buffer), locStack[tmpTop-1]->last()) ;
                     break ;
                 } // end of internal switch
                break ;

             case LATEX_COMMAND:
                /* Handle mode changes */
                if (!from) {
                   if (_areAllWhiteSpaces(t, oldptr)) {
                       _margin = (oldptr-t) - MARGIN_FIX  ;
                       if (_margin < 0) _margin = 0 ;
                       if (_margin > length_limit/2) _margin = length_limit/2 ;
                   }
                }
                firstCommand = 0 ;
                if (!from && _areAllWhiteSpaces(t,oldptr)) firstCommand = 1 ;
                if (!strcmp(buffer, SETHEBREW)) { modeChange = StrHebrew ; modeChanged=1 ; }
                if (!strcmp(buffer, UNSETHEBREW)) { modeChange = StrEnglish ; modeChanged=1 ; }
                if (!strcmp(buffer, SETHEBREW_S)) { modeChange = StrHebrew ; modeChanged=1 ; }
                if (!strcmp(buffer, UNSETHEBREW_S)) { modeChange = StrEnglish ; modeChanged=1 ; }
                if ((!strcmp(buffer,ITEM) || !strcmp(buffer,ITEM_S)) && firstCommand) { // check if this is the first command
                       _margin = (ptr-t) - MARGIN_FIX  ;
                       if (_margin < 0) _margin = 0 ;
                       if (_margin > length_limit/2) _margin = length_limit/2 ;
                }
                last_time_a_start_segment_was_inserted = 0 ;
                lastWordPtr = ptr ;
                if (!(lastWord == "")) {
                  if (stack.topMode() == StrHebrew) {
                     if (!activeSpelling || (he->hebrewDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                     PREPEND(lastWord) ;
                     locStack[tmpTop]->addLeft(lastLocations) ;
                  } else {
                     if (!activeSpelling || (he->englishDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                     APPEND(lastWord) ;
                     locStack[tmpTop]->addRight(lastLocations) ;
                  }
                }
                lastWord="" ;
                if (stack.topMode() == StrHebrew) {
                     strcpy(tmpStack[tmpTop+1], buffer) ;
                   if (!firstCommand) {
//                      int l = strlen(tmpStack[tmpTop+1]) ;
//                      tmpStack[tmpTop+1][l] = sseparator ;
//                      tmpStack[tmpTop+1][l+1] = '\0' ;
                      strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                      strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
//                      sepcount++ ;
//                    locStack[tmpTop]->addSplitsLeft(1,StrHebrew) ;
                   } else {
                          strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                          strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
                    }
                    int code = INVALID_LAXET_COMMAND ;
                    if (activeSpelling && (he->laxetDictionary->findMatch(buffer))) code = VALID_LAXET_COMMAND ;
                    else wrongSpelling = 1 ;
                    if (!activeSpelling) code = 0 ;
                    locStack[tmpTop]->addLeft(buffer,StrEnglish,code) ;
                } else {
                    int code = INVALID_LAXET_COMMAND ;
                    if (activeSpelling && (he->laxetDictionary->findMatch(buffer))) code =  VALID_LAXET_COMMAND;
                    else wrongSpelling = 1 ;
                    if (!activeSpelling) code = 0 ;
                   locStack[tmpTop]->addRight(buffer, StrEnglish,code) ;
//                   strcat(tmpStack[tmpTop], buffer) ;
                   APPEND(buffer) ;
                }
                lastLocations.init(locStack[tmpTop]->last()) ;
                break ;

             case SEGMENT_END:
              case MATH_SEGMENT_END:
              case MATH_SEGMENT_END2:
                lastWordPtr = ptr ;
                if (stack.topMode() == StrHebrew) {
                     if (!activeSpelling || (he->hebrewDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                   PREPEND(lastWord) ;
                   locStack[tmpTop]->addLeft(lastLocations) ;
                } else {
                     if (!activeSpelling || (he->englishDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                   APPEND(lastWord) ;
                   locStack[tmpTop]->addRight(lastLocations) ;
                }
                last_time_a_start_segment_was_inserted = 0 ;
                lastWord="" ;
                if ((stack.depth()==1))
//                ||
//                    (stack.topLeft() && *buffer && *(stack.topLeft()) && strcmp(stack.topLeft(),buffer)))
                    { // this is not a legal finishing segment end
 //                  cont = 0 ;
                   if (stack.topMode() == StrHebrew) { // use it as simple character, and let LaXeT deal with it.
                      strcpy(tmpStack[tmpTop+1], reverse(buffer)) ;
                      strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                      strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
                      locStack[tmpTop]->addLeft(buffer, StrHebrew) ;
                   } else {
                      APPEND(buffer) ;
                      locStack[tmpTop]->addRight(buffer, StrEnglish) ;
                   }
                } else if (stack.depth() > 1) {
                    if (tmpTop == 0) { // this is a segment-end of a segment that started in a previous segment.
                                           // use it to end this segment, as well, NO!
                       // cont = 0 ;
// added here
                       if (stack.peekMode(1) == StrEnglish)  {
                         if (*buffer) {
                            APPEND(buffer) ;
                            locStack[tmpTop]->addRight(buffer, stack.topMode()) ;
                         } else {
//                             int l = strlen(tmpStack[tmpTop]) ;
//                             tmpStack[tmpTop][l] = sseparator ;
//                             tmpStack[tmpTop][l+1] = '\0' ;
//                             locStack[tmpTop]->addSplitsRight(1,StrEnglish) ;
//                             sepcount++ ;
                         }
                       } else {
                         if (*buffer) {
                          PREPEND(reverse(buffer)) ;
                          locStack[tmpTop]->addLeft(buffer, stack.topMode()) ;
                         } else {
//                          PREPEND_CHAR(sseparator) ;
//                          if (token==MATH_SEGMENT_END)
//                                locStack[tmpTop]->addSplitsLeft(1, stack.topMode()) ;
//                          else
//                                locStack[tmpTop]->addSplitsLeft(1,StrHebrew) ;
//                          sepcount++ ;
                         }
                       }
                       stack.pop() ;
                    } else {
                        if (stack.peekMode(1) == StrEnglish) {
                         if (*buffer) {
                            APPEND(buffer) ;
                            locStack[tmpTop]->addRight(buffer, stack.topMode()) ;
                         } else {
//                          APPEND_CHAR(sseparator) ;
//                          locStack[tmpTop]->addSplitsRight(1,StrEnglish) ;
//                          sepcount++ ;
                         }
                        } else {
                         if (*buffer) {
                           PREPEND(reverse(buffer)) ;
                           locStack[tmpTop]->addLeft(buffer, stack.topMode()) ;
                         } else {
//                          PREPEND_CHAR(sseparator) ;
//                          if (token == MATH_SEGMENT_END)
//                               locStack[tmpTop]->addSplitsLeft(1,stack.topMode()) ;
//                          else
//                               locStack[tmpTop]->addSplitsLeft(1,StrHebrew) ;
//                          sepcount++ ;
                         }
                        }
                        stack.pop() ; tmpTop-- ;
                        if (stack.topMode() == StrHebrew) { // this is a legal segment end
                            strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                            strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
                            locStack[tmpTop]->addLeft(locStack[tmpTop+1]) ;
                       } else {
                           strcat(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
                           locStack[tmpTop]->addRight(locStack[tmpTop+1]) ;
                       }
                       delete locStack[tmpTop+1] ;
                    }
                }
                lastLocations.init(locStack[tmpTop]->last()) ;
                break ;

             case ' ':
             case '-':
                if ((!lastWord.length()) ||
                       (lastWord.length() && (!strcmp(lastWord.at(lastWord.length()-1,lastWord.length())," "))) ||
                       (lastWord.length() && (!strcmp(lastWord.at(lastWord.length()-1,lastWord.length()),"-"))) ||
                       (lastWord.length() && (strcmp(lastWord.at(0,1), " ")))) {
                  lastWordPtr = ptr ;
                  last_time_a_start_segment_was_inserted = 0 ;
                  if (stack.topMode() == StrHebrew) {
                     if (!activeSpelling || (he->hebrewDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;
                     tmpStack[tmpTop+1][0]=*buffer ;
                     tmpStack[tmpTop+1][1]='\0' ;
                     strcat(tmpStack[tmpTop+1], (char *)(const char *)(lastWord)) ;
                     strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
                     strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
//                     tmpStack[tmpTop] = ' ' + lastWord + tmpStack[tmpTop] ;
                     locStack[tmpTop]->addLeft(lastLocations) ;
                     locStack[tmpTop]->addLeft(buffer, StrHebrew) ;
                  } else {
                     if (!activeSpelling || (he->englishDictionary->findMatch((char *)((const char*)lastWord))))
                        lastLocations.clearCodes() ;

                     APPEND(lastWord) ;
                     APPEND_CHAR(*buffer) ;
//                     tmpStack[tmpTop] += lastWord + ' ' ;
                     locStack[tmpTop]->addRight(lastLocations) ;
                     locStack[tmpTop]->addRight(buffer, StrEnglish) ;
                  }
                  lastWord="" ;
                  lastLocations.init(locStack[tmpTop]->last()) ;
                } else { // lastWord is not "", and no last space
                     if (stack.topMode() == StrHebrew) {
                       lastWord = *buffer + lastWord;
                       lastLocations.addLeft(buffer, StrHebrew) ;
                    } else {
                       lastWord += *buffer ;
                       lastLocations.addRight(buffer, StrEnglish) ;
                    }
                }
                break ;

             default: // simple char
                last_time_a_start_segment_was_inserted = 0 ;
                if (!from) {
                   if (_areAllWhiteSpaces(t, oldptr)) {
                       _margin = (oldptr-t) - MARGIN_FIX  ;
                       if (_margin < 0) _margin = 0 ;
                       if (_margin > length_limit/2) _margin = length_limit/2 ;
                   }
                }
                if ((lastWord.length()) &&
                    ((!strcmp(lastWord.at(lastWord.length()-1, lastWord.length()), " ")) ||
                     (!strcmp(lastWord.at(0,1)," ")))) {
                  lastWordPtr = oldptr ;
                  if (stack.topMode() == StrHebrew) {
                     PREPEND(lastWord) ;
                     locStack[tmpTop]->addLeft(lastLocations) ;
                  } else {
                     APPEND(lastWord) ;
                     locStack[tmpTop]->addRight(lastLocations) ;
                  }
                  lastWord="" ;
                  lastLocations.init(locStack[tmpTop]->last()) ;
                }

                if (stack.topMode() == StrHebrew) {
                   lastWord = (char )token + lastWord;
                   if (strchr(HEBREW_CHARS "'",(char)token)) {
                     lastLocations.addLeft(buffer, StrHebrew,
                                           INVALID_HEBREW_WORD) ;
                     wrongSpelling=1 ;
                   }
                   else 
                     lastLocations.addLeft(buffer, StrHebrew) ;
                } else {
                   lastWord += (char )token ;
                   if (strchr(ENGLISH_CHARS "'",(char)token)) {
                      lastLocations.addRight(buffer, StrEnglish,INVALID_ENGLISH_WORD) ;
                      wrongSpelling = 1 ;
                   }
                   else
                      lastLocations.addRight(buffer, StrEnglish) ;
                }
                break ;

          } /* end of switch */
          oldptr = ptr ;
//         _separate_command = 0 ;
         token = _getNextToken(&ptr, stack) ;
    } /* end of while */
   // take back if no more space for start_segment
   if (last_time_a_start_segment_was_inserted) {
     lastWordPtr = oldptr = oldptr_at_last_segment_insertion ;
     if (tmpTop > 0) {
       delete locStack[tmpTop] ;
       tmpTop-- ;
     }
     stack.pop() ;
     strcpy(tmpStack[tmpTop], tmpStack_at_last_segment_insertion) ;
     delete tmpStack_at_last_segment_insertion ;
     Locations *tmp = locStack[tmpTop] ;
     locStack[tmpTop] = locStack_at_last_segment_insertion ;
     delete tmp ;
   }
     if (!(*oldptr) || ((ptr-t > length_limit-(_separate_command+sepcount+1)) && (lastWordPtr == t))) { // end of line, or reached length limit!
          lastWordPtr = oldptr ;
          if (stack.topMode() == StrHebrew) {
                PREPEND(lastWord) ;
                locStack[tmpTop]->addLeft(lastLocations) ;
           } else {
               APPEND(lastWord) ;
               locStack[tmpTop]->addRight(lastLocations) ;
          }
          lastWord="" ;
          lastLocations.init(locStack[tmpTop]->last()) ;
     }
    int depth=0 ;
    while (tmpTop>0) { // in the middle of a segment the length limit stroke, so we have to add all we have
                                         // calculated so far to a whole segment.
           tmpTop-- ;
           depth++ ;
           if (stack.peekMode(depth) == StrHebrew) {
              strcat(tmpStack[tmpTop+1], tmpStack[tmpTop]) ;
              strcpy(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
//              tmpStack[tmpTop] = /*stack.peekLeft(depth-1) + */ tmpStack[tmpTop+1] + tmpStack[tmpTop] ;
              locStack[tmpTop]->addLeft(locStack[tmpTop+1]) ;
           } else {
              strcat(tmpStack[tmpTop], tmpStack[tmpTop+1]) ;
//              tmpStack[tmpTop] += /* stack.peekLeft(depth-1) + */tmpStack[tmpTop+1] ;
              locStack[tmpTop]->addRight(locStack[tmpTop+1]) ;
           }
           delete locStack[tmpTop+1] ;
     }
     (aString &)(*this) = tmpStack[tmpTop] ;
     if (stack.majorMode() == StrHebrew) {
        int len = ((aString &)(*this)).length() ;
        int u = 0 ;
        if ((len <= length_limit) && (!*oldptr)){ // add this only in the last segment
//           tmpStack[tmpTop] = " " + tmpStack[tmpTop] ;
//           locStack[tmpTop]->addLeft(" ", stack.topMode()) ;

          if (show_line_end_marks) {
             PREPEND_CHAR(left_end_mark) ;
//           tmpStack[tmpTop] = left_end_mark + tmpStack[tmpTop] ;

//           locStack[tmpTop]->addLeft(left_end_mark, stack.topMode()) ;
             locStack[tmpTop]->addSplitsLeft(1, stack.topMode()) ;
             u = 1 ;
           }
        }
        if (len+u <= length_limit) {
           PREPEND(replicate(' ', length_limit - (len+u))) ;
           (aString &)(*this) = tmpStack[tmpTop] ;
//           (aString &)(*this) = replicate(' ', length_limit - (len+u)) + tmpStack[tmpTop] ;
           locStack[tmpTop]->addSplitsLeft(length_limit-(len+u), StrHebrew) ;
        }
     } else {
        int len = ((aString &)(*this)).length() ;
        int u = 0 ;
        if ((len <= length_limit) && (!*oldptr)) { // add this only in the last segment!
//           tmpStack[tmpTop] += " " ;
//           locStack[tmpTop]->addRight(" ", stack.topMode()) ;
          if (show_line_end_marks) {
            APPEND_CHAR(right_end_mark) ;
            //           tmpStack[tmpTop] += right_end_mark ;

            //           locStack[tmpTop]->addRight(right_end_mark, stack.topMode()) ;
            locStack[tmpTop]->addSplitsRight(1, stack.topMode()) ;
            u = 1 ;
          }
          (aString &)(*this) = tmpStack[tmpTop] ;
        }
        // notice changes here 18/4/97
        if (len + u< length_limit) {
//           (String &)(*this) += replicate(' ', length_limit - (len+u)) ;
//           locStack[tmpTop]->addSplitsRight(length_limit-(len+u), StrEnglish) ;
           (aString &)(*this) += replicate(' ', length_limit - (len+u)) ;
           locStack[tmpTop]->addSplitsRight(length_limit-(len+u), StrEnglish) ;
        }
     }
     /* Add margins at the beginning of the string */
     if (stack.majorMode() == StrHebrew) {
        int len = ((aString &)(*this)).length() ;
        if (len < length_lim)  {
            if ((comment_save < 0) || (comment_save > _margin))
               (aString &)(*this) += replicate(' ', length_lim -len) ;
            else {
              aString str , str2;
              str2 = replicate(' ', ((length_lim-len)-1)-_comment) ;
              str2 += '%' ;
              str = replicate(' ',_comment) ;
              str2 += str ;
              (aString &)(*this) += str2 ;
            }
            locStack[tmpTop]->addSplitsRight(length_lim-len, StrHebrew) ;
        }
      } else { // english mode
        int len = ((aString &)(*this)).length() ;
        if (len+_margin <= length_lim)  {
            if ((comment_save < 0) || (comment_save > _margin))
               (aString &)(*this) = replicate(' ', _margin) + (aString &)(*this) ;
            else {
              aString str , str2;
              str = replicate(' ',_comment) ;
              str += '%' ;
              str2 = replicate(' ', (_margin-1)-_comment) ;
              str += str2 ;
              (aString &)(*this) = str + (aString &)(*this) ;
            }
            locStack[tmpTop]->addSplitsLeft(_margin, StrEnglish) ;
        }
     }
    _locations = locStack[tmpTop] ;
    _locations->setMinVal(from) ;
    if (lastWordPtr != t)
       _length = lastWordPtr - t ;
    else
       _length = oldptr-t ;
    // if the line began with a margin, then the comment may be measured from the
    // margin, and though appear not correctly
    if (_comment != comment_save)
      _comment += margin_save ;

    if (_comment > length_lim / 2  - 2) {
            _comment = length_lim / 2 - 2 ;
            if (_comment < 0) _comment = 0 ;
    }
    if (_margin < _comment) _margin = _comment + 2 ;
}


int
hebSegment::_getNextToken(char **str, modeStack& stack)
{

   static int buffer_was_space = 0 ;
   static int buffer_was_was_space = 0 ;
   buffer_was_was_space = buffer_was_space ;
   if (buffer[0] == ' ') buffer_was_space = 1 ;
   else buffer_was_space = 0 ;

   if (!**str) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      return buffer[0]='\0' ;
   }

   if (!strncmp(*str,"\\R{",3)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"\\R{") ;
      (*str)+=3 ;
      return HEBREW_SEGMENT_START ;
   }

   if (!strncmp(*str,"{",1)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"{") ;
      (*str)++ ;
      return SEGMENT_START ;
   }
   if ((!strncmp(*str,"}",1))  && (!stack.topMath())){
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"}") ;
      (*str)++ ;
      return SEGMENT_END ;
   }
   if (!strncmp(*str,"[",1)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"[") ;
      (*str)++ ;
      return ENGLISH_SEGMENT_START ;
   }
   if ((!strncmp(*str,"]",1)) && (!stack.topMath())) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"]") ;
      (*str)++ ;
      return SEGMENT_END ;
   }
   if (!strncmp(*str,"$$",2)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"$$") ;
      (*str)+=2 ;
      if (!stack.topMath())
         return MATH_SEGMENT_START2 ;
      return MATH_SEGMENT_END2 ;
   }
   if (!strncmp(*str,"$",1)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"$") ;
      (*str)+=1 ;
      if (!stack.topMath())
         return MATH_SEGMENT_START ;
      return MATH_SEGMENT_END ;
   }
   if (stack.topMath()) {
      char *p = *str ;
//      while (*p==' ') p++ ;

      if (strchr(HEBREW_CHARS, *p)) {
          buffer[0] = '\0' ;
          return MATH_SEGMENT_END ;
      }
   }
   if (stack.topLangChange() && (stack.topMode()==StrEnglish)) {
      if (strchr(HEBREW_CHARS, **str)) {
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      if (**str == ' ') {
        char *p = *str ;
        if (*(++p)!= '\0')
          while (*p && (*p==' ')) p++ ;
        // if spaces to the end of the line, allow only one space to default to topMode()
        if ((!*p) && buffer_was_space && buffer_was_was_space) {
            buffer[0] = '\0' ;
            return SEGMENT_END ;
        }
        if (*p && strchr(HEBREW_CHARS,*p) && buffer_was_space && buffer_was_was_space) {
            buffer[0] = '\0' ;
            return SEGMENT_END ;
        }
      }
   }
   if (stack.topLangChange() && (stack.topMode()==StrHebrew)) {
      if (strchr(ENGLISH_CHARS, **str)) {
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      if (**str == ' ') {
        char *p = *str ;
        if (*(++p)!= '\0')
          while (*p && (*p==' ')) p++ ;
        // if spaces to the end of the line, allow only one space to default to topMode()
        if ((!*p) && buffer_was_space && buffer_was_was_space) {
            buffer[0] = '\0' ;
            return SEGMENT_END ;
        }
        if (*p && strchr(ENGLISH_CHARS,*p) && buffer_was_space && buffer_was_was_space) {
            buffer[0] = '\0' ;
            return SEGMENT_END ;
        }
      }
   }

   if ((stack.topMode()==StrHebrew) && (!stack.topLangChange())) {
      if (strchr(ENGLISH_CHARS, **str)) {
          buffer[0] = '\0' ;
          return ENGLISH_SEGMENT_START ;
      }
   }

   if ((stack.topMode()==StrEnglish) && (!stack.topLangChange())) {
      if (strchr(HEBREW_CHARS, **str)) {
          buffer[0] = '\0' ;
          return HEBREW_SEGMENT_START ;
      }
   }

   if (!strncmp(*str,"\\[",2)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"\\[") ;
      (*str)+=2 ;
      return MATH_SEGMENT_START ;
   }
   if (!strncmp(*str,"\\]",2)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"\\]") ;
      (*str)+=2 ;
      return MATH_SEGMENT_END ;
   }
   if (!strncmp(*str,"\\(",2)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"\\(") ;
      (*str)+=2 ;
      return MATH_SEGMENT_START ;
   }
   if (!strncmp(*str,"\\)",2)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      strcpy(buffer,"\\)") ;
      (*str)+=2 ;
      return MATH_SEGMENT_END ;
   }
   if (!strncmp(*str,"\\",1)) {
       if (stack.topLangChange()==1) { // preform an epsilon-move to reduce the langchange from the stack
          buffer[0] = '\0' ;
          return SEGMENT_END ;
      }
      return _processLatexCommand(buffer, str, stack) ;
   }
   buffer[0] = *(*str)++ ;
   buffer[1] = '\0' ;
   return buffer[0] ;
}

char *
hebSegment::reverse(char *str)
{
    strcpy(reverse_buffer, str) ;
    char *s = reverse_buffer+strlen(reverse_buffer)-1 ;

    if (s>=reverse_buffer) {
      if (!strcmp(s,"{")) strcpy(s,"}") ;
      else
      if (!strcmp(s,"}")) strcpy(s,"{") ;
      else
      if (!strcmp(s,"[")) strcpy(s,"]") ;
      else
      if (!strcmp(s,"]")) strcpy(s,"[") ;
      else
      if (!strcmp(s,"(")) strcpy(s,")") ;
      else
      if (!strcmp(s,")")) strcpy(s,"(") ;
    }

    return reverse_buffer ;
}

char *hebrew_segment_starters[] = { "\\R{", "\\section{","\\section*{", "\\subsection{",
    "\\subsection*{","\\subsubsection{","\\subsubsection*{", "\\chapter{","\\chapter*{","\\item[","\\footnote{","\\bchapter{","\\bsection{","\\bsubsection{",
"\\bsubsubsection{", "\\caption{","\\bcaption{"} ;

#define alpha "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define anum "0123456789*+=-?@!%^&~:'\".,;()`<>/|_"
#define alphanum alpha ## "0123456789*+=-?@!%^&~:'\".,;()`<>/|"
#define all alphanum ## "${}^[]"
int
hebSegment::_processLatexCommand(char *buffer,  char **str, modeStack& stack)
{
    char *ptr = buffer ;
    // skip the first backslash
    *ptr++ = *(*str)++ ;

    // if the first char is not [a-zA-Z_] then this is a special latex macro of a single character
    if (stack.topMode() == StrHebrew)
       _separate_command ++ ;
    if (!**str) {
       *ptr = '\0' ;
       return buffer[0] ;
    }
    if (!strchr(alpha, **str)) {
        *ptr++ = *(*str)++ ;
        *ptr = '\0' ;
        return LATEX_COMMAND ;
    } ;
    while (**str && strchr(alpha, **str) && ((ptr-buffer < 5) || strncmp(buffer,"\\verb",5) || ((ptr-buffer > 5) && (strchr(alpha,buffer[5])))))
        *ptr++ = *(*str)++ ;
    if (ptr-buffer > 6)
       if ((!strncmp(buffer,"\\verb",5)) && (!strchr(alpha,buffer[5]))) {
         int c = buffer[5] ;
         while (**str && strchr(all, **str) && (**str != c))
            *ptr++ = *(*str)++ ;
         if (**str == c) *ptr++ = *(*str)++ ;
         *ptr = '\0' ;
         return LATEX_COMMAND ;
       }
    if ((**str == '{') || (**str == '[')) {
       *ptr++ = *(*str)++ ;
       *ptr = '\0' ;
       if (stack.majorMode() == StrHebrew)
         for (int i=0 ; i<(int)(sizeof(hebrew_segment_starters) / sizeof(char *)) ; i++)
            if (!strcmp(buffer, hebrew_segment_starters[i]))
                  return HEBREW_SEGMENT_START ;
       return ENGLISH_SEGMENT_START ;
    }
    // include one space after the command with the command itself!
    if (**str && (**str == ' '))
        *ptr++ = *(*str)++ ;
    *ptr = '\0' ;
    return LATEX_COMMAND ;
 }

int
hebSegment::_areAllWhiteSpaces(char *from, char *to)
{
   while (from < to) {
      if ((*from != ' ') && (*from != '\t') && (*from != '%'))
        return 0 ;
      from++ ;
   }
   return 1 ;
}

int
hebSegment::_findCommentStart(char *from, char *to)
{
   char *from_orig = from ;

   while (from < to) {
      if (*from == '%')
        if (from > from_orig) {
           if (*(from-1) != '\\')
              return from-from_orig ;
        } else {
          return 0 ;
        }
      from++ ;
   } // end of while
   return -1 ;
}

