/***************************************************************************
                          hebSegment.h - Hebrew substring handling
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __hebSegment_h__
#define __hebSegment_h__

#include "Locations.h"
#include "Screen.h"
#include "aString.h"
#include <string.h>
/*
  The kind of segments we want to deal with are those of LaXeT, meaning
  a segment is of the form
  \\[LR]\{...\}
  or
  \\[a-zA-Z_*+#\[\]\-\\]+(\{...\})?

  where ...   indicates free form text, including internal segments

  We will use a simple implementation of recursive descent parsing.
*/

#define MAX_LANGUAGE_DEPTH 80

#define INITIAL_LANGUAGE_DEPTH 4

#define LATEX_COMMAND_START 4096
#define HEBREW_SEGMENT_START 4097
#define ENGLISH_SEGMENT_START 4098
#define SEGMENT_START 4099
#define SEGMENT_END 4100
#define LATEX_COMMAND 4101
#define MATH_SEGMENT  4102
#define MATH_SEGMENT_START 4103
#define MATH_SEGMENT_START2 4105
#define MATH_SEGMENT_END 4104
#define MATH_SEGMENT_END2 4106

#define MARGIN_FIX -2

struct  modeStackElement {
   int location ;
   char left[10] ;
   short mode ;
   short mathmode, lang_change ;
   modeStackElement() {
      strcpy(left,"") ;
   }
   modeStackElement operator =(modeStackElement &a) {
     location=a.location ;// left = a.left ;
     mode=a.mode ; mathmode = a.mathmode ;
     lang_change=a.lang_change ;
     strcpy(left, a.left) ;
     return *this ; }
   int isEqual(modeStackElement &a) {
     return (location==a.location)&&(mode==a.mode)&&(mathmode==a.mathmode) &&
            (lang_change == a.lang_change) ; // && !strcmp(left, a.left);
            }
} ;

class modeStack {
    modeStackElement *data ;
    int stackPointer ;
    int real_size ;
    hebStringMode asMode(short x) { return (x==0) ? StrEnglish : StrHebrew ; }
    short asShort(hebStringMode m) { return (m == StrEnglish) ? 0 : 1 ; }
    aString empty ;
    void _expand_size(int factor) { // PORT: void
       real_size *= factor ;
       modeStackElement *tmp = new modeStackElement[real_size] ;
       for (int i=0; i < stackPointer ; i++ ) {
          tmp[i] = data[i] ;
       } /* endfor */
       delete data ;
       data = tmp ;
    }
public:
    modeStack() : stackPointer(0), real_size(INITIAL_LANGUAGE_DEPTH)  {
      data = new modeStackElement[real_size] ;
    } ;
    ~modeStack() { delete data ; }
    hebStringMode topMode() {
      return (stackPointer >0)?asMode(data[stackPointer-1].mode) : StrEnglish ; }
    int topLocation() { return (stackPointer > 0)?data[stackPointer-1].location : 0 ; }
//    aString topLeft() { return (stackPointer > 0)?data[stackPointer-1].left : empty ; }
    short topMath() { return (stackPointer > 0)?data[stackPointer-1].mathmode : 0; }
    short topLangChange() { return (stackPointer > 0)?
                             data[stackPointer-1].lang_change: 0; }
    const char* topLeft() { return (stackPointer >0)?(data[stackPointer-1].left) : 0 ; }
    hebStringMode peekMode(int depth) {
      return (stackPointer > depth)?asMode(data[stackPointer-(depth+1)].mode):
        StrEnglish ; }
//    aString peekLeft(int depth) {
//      return (stackPointer > depth)?data[stackPointer-(depth+1)].left:
//      empty ; }
    hebStringMode majorMode() {
      return (stackPointer > 0) ? asMode(data[0].mode) : StrEnglish ; }
    void push(hebStringMode mode, char *left, int location, int math=0,
                 short lang_change = 0) {
      if (stackPointer >= real_size) {
         _expand_size(2) ;
      } /* endif */
      data[stackPointer].mode = asShort(mode) ;
      data[stackPointer].location = location ;
      data[stackPointer].mathmode = math ;
      data[stackPointer].lang_change = lang_change ;
      strcpy(data[stackPointer++].left,left) ;
      }
    void pop() { if (stackPointer>0) --stackPointer ; }
    int depth() { return stackPointer ; }
    void copy(modeStack& stack) ;
    int isEqual(modeStack& stack) ;
    void clear() { stackPointer = 0 ; } // for mode changers
} ;


class HebrewEditor ;

class hebSegment : public aString {
   HebrewEditor *he ;
   int wrongSpelling ;
   char buffer[MAX_SCREEN_WIDTH] ;
   char reverse_buffer[2] ;
   int _separate_command ;
   int   _processLatexCommand(char *buffer, char **str, modeStack &stack) ;
   int   _getNextToken(char **str, modeStack &stack) ;
   int _areAllWhiteSpaces(char *from, char *to) ;
   int _findCommentStart(char *from, char *to) ;
   char *reverse(char *s) ;
   int _length ;
   Locations *_locations ;
   hebStringMode modeChange ;
   int modeChanged ;
   int _margin ;
   int _comment ;
   modeStack last_mode_stack ;
   int last_length_limit ;
   int activeSpelling ;
public:
    int getWrongSpelling() { return wrongSpelling ; }
    hebSegment(HebrewEditor *he, const char *t,int from, int startHebrew,
               Screen &scr, int margin,  int comment, int lenght_limit, modeStack &stack,
               int show_line_end_marks=1, int activeSpelling = 0) ;
    ~hebSegment() { (aString &)(*this) = "" ; delete _locations ; }

    int length() { return _length ; } // return the actual length of the segment
    Locations *getLocations() {  return _locations ; }
    hebStringMode getModeChange() { return modeChange ; }
    int getModeChanged() { return modeChanged ; }
    int getMargin() { return _margin ; }
    int getComment() { return _comment ; }

    int getMinLocation() { return _locations->getMinVal() ; }
    int getMaxLocation() { return _locations->getMaxVal() ; }
    void setMinLocation(int m) { _locations->setMinVal(m) ; }
    void updateMinLocation(int u)  { _locations->setMinVal( _locations->getMinVal() + u ) ; }
    int noNeedToRecompile(int from, int margin, int length_limit, modeStack &stack) {
      return (last_mode_stack.isEqual(stack)) &&
        (from == _locations->getMinVal()) &&
        (last_length_limit == length_limit) &&
        (_margin == margin) ; }
    modeStack& getLastModeStack() { return last_mode_stack ; }
} ;

#endif
