/***************************************************************************
                          hebString.cxx - Hebrew string handling
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "hebString.h"
#include <string.h>
#include <iostream.h>
#include <assert.h>


hebString::~hebString()
{
    // discard old representation 18/4/97 (to handle memory leakage)
    for (int j=0; j < last_representation.get_size() ; j++)
         delete last_representation[j] ;

    last_representation.clear() ;
}

//void
//hebString::printLocations()
//{
//   for (int i =0 ; i<last_representation.get_size() ;i++) {
//      Locations *locs = last_representation[i]->getLocations() ;
//      locs->print() ;
//   }
//}

int
hebString::line_count(int line_length)
{
  if (line_length != last_line_length) modified = 1 ;

  check_recompile(line_length) ;

  return last_representation.get_size() ;
}

char *
hebString::represent(int line_length, int line_offset)
{
    if (line_offset >= line_count(line_length)) // also recompiles if needed
      return (char *)0 ;

    return (char *)(const char *)(*last_representation[line_offset]) ;
}


void hebString::check_recompile(int line_width, int line_offset)
{
    if (!modified) return ;
    int margin = 0 , from=0, len = 0 , comment = -1 ;

    const char *txt = (const char *)(aString &)(*this) ;
    if (*txt)
        if (txt[strlen(txt)-1] != ' ')
               (aString &)(*this) += " " ;

    // added this 19/04/97
     if (line_offset > 0) line_offset-- ;

    if (line_offset > 0) {
       margin = last_representation[line_offset-1]->getMargin() ;
       comment = last_representation[line_offset-1]->getComment() ;
       from = last_representation[line_offset-1]->getMaxLocation() ;
    }
    modeStack stack ;
    stack.copy(last_representation[line_offset]->getLastModeStack()) ;
    int count = 0 ;
    do {
       recompile_line(line_offset, line_width, from, margin, comment, stack) ;
       hebSegment *seg = last_representation[line_offset++] ;
       len = seg->length() ;
       margin = seg->getMargin() ;
       comment = seg->getComment() ;
       from=seg->getMaxLocation() ;
       count++ ;
       //assert(count == 1) ;
    } while ((line_offset < last_representation.get_size()) );// &&
//                    !last_representation[line_offset]->noNeedToRecompile(from,margin, line_width, stack)) ;
    // NOTICE THAT LINES MAY BE DELETED FROM last_representation UPON DELETING CHARACTERS FROM
    // THE STRING
    // in case new lines were added
    if (line_offset >= last_representation.get_size()) {
        const char *text = (const char *)(aString &)(*this) ;
        hebStringMode mode = stack.majorMode() ;
        int len = ((aString *)this)->length() ;
        int length = 0 ;
        int count = last_representation.get_size() ;
        if (count > 0)
            length = last_representation[count-1]->getMaxLocation() ;
           while (length < len) {
              hebSegment *segment = new
                   hebSegment(he, text, length, startHebrew,   screen, margin, comment, line_width, stack, show_line_end_marks, activeSpelling) ;
              length += segment->length() ;
              margin = segment->getMargin() ;
              comment = segment->getComment() ;
              last_representation.append(segment) ;
              if (segment->getModeChanged())
                   mode = segment->getModeChange() ;
         }
        if (mode != stack.majorMode()) { // Major mode was changed here
            stack.clear() ;
            stack.push(mode, "", 0) ;
        }
        last_stack_depth = stack.depth() ;
    }
    modified = 0 ;
    last_line_length=  line_width ;
    last_str_mode = stack.majorMode() ;
}


void hebString::recompile_line(int line, int line_width, int from, int margin, int comment, modeStack& stack)
{
    const char *txt = (const char *)(aString &)(*this) ;
    if (*txt)
        if (txt[strlen(txt)-1] != ' ')
               (aString &)(*this) += " " ;
    const char *text = (const char *)(aString &)(*this) ;
//    int len = ((aString *)this)->length() ;
    hebSegment *seg = last_representation[line] ;
    int length = from ;
    delete seg ;
    hebSegment *segment = new
             hebSegment(he, text, length, startHebrew,   screen, margin, comment, line_width, stack,
                        show_line_end_marks, activeSpelling) ;
    last_representation[line] = segment ;
}



void hebString::recompile(int line_width, modeStack &activeStack)
{
    const char *txt = (const char *)(aString &)(*this) ;

    // use compiled flag to note that the stack is valid
    compiled = 1 ;

    if (*txt)
        if (txt[strlen(txt)-1] != ' ')
               (aString &)(*this) += " " ;
    const char *text = (const char *)(aString &)(*this) ;
    int len = ((aString *)this)->length() ;
    int length = 0 ;
    last_mode_stack.copy(activeStack) ;
    hebStringMode mode = activeStack.majorMode() ;
    int margin = 0, comment = -1 ;

    // discard old representation 18/4/97 (to handle memory leakage)
    for (int j=0; j < last_representation.get_size() ; j++)
         delete last_representation[j] ;

    last_representation.clear() ;
    // handle the special case where a line is empty!
    if (len == 0) {
        hebSegment *segment = new
             hebSegment(he, " ", length, startHebrew,   screen, margin, comment, line_width,
                        activeStack, show_line_end_marks,activeSpelling) ;
        length += segment->length() ;
        margin = segment->getMargin() ;
        comment = segment->getComment() ;
        last_representation.append(segment) ;
        if (segment->getModeChanged())
           mode = segment->getModeChange() ;
     }
    while (length < len) {
        hebSegment *segment = new
             hebSegment(he, text, length, startHebrew,   screen, margin, comment, line_width,
                        activeStack, show_line_end_marks,activeSpelling) ;
        length += segment->length() ;
        margin = segment->getMargin() ;
        comment = segment->getComment() ;
        last_representation.append(segment) ;
        if (segment->getModeChanged())
           mode = segment->getModeChange() ;
    }
    if (mode != activeStack.majorMode()) { // Major mode was changed here
        activeStack.clear() ;
        activeStack.push(mode, "", 0) ;
    }
    modified = 0 ;
    last_line_length=  line_width ;
    last_str_mode = activeStack.majorMode() ;
    last_stack_depth = activeStack.depth() ;
}


void hebString::respell(int line_width, modeStack &activeStack)
{
    const char *txt = (const char *)(aString &)(*this) ;

    // use compiled flag to note that the stack is valid
    compiled = 1 ;

    if (*txt)
        if (txt[strlen(txt)-1] != ' ')
               (aString &)(*this) += " " ;
    const char *text = (const char *)(aString &)(*this) ;
    int len = ((aString *)this)->length() ;
    int length = 0 ;
    last_mode_stack.copy(activeStack) ;
    hebStringMode mode = activeStack.majorMode() ;
    int margin = 0, comment = -1 ;

    // discard old representation 18/4/97 (to handle memory leakage)
    int need_to_recompile = 0 ;

    for (int j=0; j < last_representation.get_size() ; j++)
         need_to_recompile += last_representation[j]->getWrongSpelling() ;

    if (!need_to_recompile)
            return ;

    for (int j=0; j < last_representation.get_size() ; j++)
         delete last_representation[j] ;

    last_representation.clear() ;
    // handle the special case where a line is empty!
    if (len == 0) {
        hebSegment *segment = new
             hebSegment(he, " ", length, startHebrew,   screen, margin, comment, line_width,
                        activeStack, show_line_end_marks,activeSpelling) ;
        length += segment->length() ;
        margin = segment->getMargin() ;
        comment = segment->getComment() ;
        last_representation.append(segment) ;
        if (segment->getModeChanged())
           mode = segment->getModeChange() ;
     }
    while (length < len) {
        hebSegment *segment = new
             hebSegment(he, text, length, startHebrew,   screen, margin, comment, line_width,
                        activeStack, show_line_end_marks,activeSpelling) ;
        length += segment->length() ;
        margin = segment->getMargin() ;
        comment = segment->getComment() ;
        last_representation.append(segment) ;
        if (segment->getModeChanged())
           mode = segment->getModeChange() ;
    }
    if (mode != activeStack.majorMode()) { // Major mode was changed here
        activeStack.clear() ;
        activeStack.push(mode, "", 0) ;
    }
    modified = 0 ;
    last_line_length=  line_width ;
    last_str_mode = activeStack.majorMode() ;
    last_stack_depth = activeStack.depth() ;
}

int
hebString::getCurrentXlocation(int line_offset, int x_pos)
{
    if (line_offset >= last_representation.get_size())
       return SPLIT_VALUE ; // just a safety guard
    if (line_offset < 0)
       return SPLIT_VALUE ;
    if (x_pos < 0) return SPLIT_VALUE ;

    Locations *locs = last_representation[line_offset]->getLocations() ;

    int pos = (*locs)[ x_pos] ;
    if (pos > 0)
       return pos ;
    return -pos ;
}

int
hebString::getCurrentXcode(int line_offset, int x_pos)
{
    if (line_offset >= last_representation.get_size())
       return SPLIT_VALUE ; // just a safety guard
    if (line_offset < 0)
       return SPLIT_VALUE ;
    if (x_pos < 0) return SPLIT_VALUE ;

    Locations *locs = last_representation[line_offset]->getLocations() ;

    return (*locs)[x_pos].getCode() ;
}

hebStringMode
hebString::getCurrentXlang(int line_offset, int x_pos)
{
    if (line_offset >= last_representation.get_size())
       return StrEnglish ; // just a safety guard
    if (line_offset < 0)
       return StrEnglish ;
    if (x_pos < 0) return StrEnglish ;

    Locations *locs = last_representation[line_offset]->getLocations() ;

    int pos = (*locs)[x_pos] ;
    if (pos > 0)
       return StrEnglish ;
    return StrHebrew ;
}

/*
void
hebString::delete_ch(int at,int line_length)
{
   Array<int> locations ;
   aString tmp = (const char *)(aString &)(*this) ;
   int count = line_count(line_length) ;

   tmp += replicate(' ',count*line_length - length()) ;
   calculate_locations(tmp, locations) ;
   if ((at >=0) && (at < locations.get_size()))
     _delete_ch(locations[at]) ;
   locations.clear() ;
}
*/
void
hebString::_delete_ch(int at, int line_offset)
{
   modified = 1 ;
   aString &tmp = (aString &)(*this) ;
//   aString tmp2 = "" ;
   at-- ; // assume at > 0

   if (at >= tmp.length())
     return ;

//   if (at > 0)
//     tmp2 = tmp.at(0,at) ;

//   tmp2 += at+1+(const char *)tmp ;
//   tmp = tmp2 ;
   tmp.delete_ch(at) ;
   for (int i=line_offset+1; i < last_representation.get_size() ; i++)
        last_representation[i]->updateMinLocation(-1) ;
             // decrease by one because we deleted a character
   check_recompile(last_line_length, line_offset) ;
}


int
hebString::_insert_ch(int at, int line_offset, unsigned char ch, int x_pos)
{
   modified = 1 ;
   aString &tmp = (aString &)(*this) ;
//   char before = ' ';
//   char before2 = ' ' ;
   at-- ; // asume at > 0

   int move = 1 ;

   if (at > tmp.length()) {
     tmp += ch ;
     check_recompile(last_line_length, line_offset) ;
     return  move;
   }

//   if (at > 0) {
//     tmp2 = tmp.at(0,at) ;
//     before = *((const char *)tmp+at-1) ;
//     if (at > 1) before2 = *((const char *)tmp + at - 2) ;
//   }
//   if (((ch == '}') || (ch == '{')) && (before != '\\')) {
//      if (((before == 'R') || (before == 'L')) && (before2 == '\\'))
//           tmp2 += "{" ;
//      else tmp2 += ch ; }
//   tmp2+=ch ;

//   tmp2 += at+(const char *)tmp ;
   tmp.insert_ch(at,ch) ;
   for (int i=line_offset+1; i < last_representation.get_size() ; i++)
        last_representation[i]->updateMinLocation(1) ; // increase by one because we inserted a character
// returned the following command
   check_recompile(last_line_length, line_offset) ;
   return move ;
}
/*
void
hebString::insert_ch(int at, unsigned char ch)
{
}

void
hebString::_replace_ch(int at, unsigned char ch)
{
}

void
hebString::replace_ch(int at, unsigned char ch)
{
}
*/
char *
hebString::split(int at)
{
   modified = 1  ;
   aString &tmp = (aString &)(*this) ;
   aString tmp2 = "" ;

   if (at >0) at-- ; // since curx is now handled from 1 and above
   if (at > tmp.length())
     return 0;

   if (at > 0)
     tmp2 = tmp.at(0,at) ;

   work_area = at+(const char *)tmp ;
   tmp = tmp2 ;

   return (char *)(const char *)work_area ;
}

