/***************************************************************************
                          hebString.h - Hebrew string handling
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __hebString_h__
#define __hebString_h__

#include "Array.h"
#include "aString.h"
#include "Locations.h"
#include "hebSegment.h"
#include "Screen.h"

class HebrewEditor ;

class hebString : public aString {
    HebrewEditor *he ;
    int startHebrew ;
    int modified ; // keep up with string representation, for better
                   // performance
    Array<hebSegment*> last_representation ;
    int last_line_length ;
    hebStringMode last_str_mode ;
    int special_separator ;
    modeStack last_mode_stack ; // just before recompilation
    int last_stack_depth ; // checks if recompilation of this line affects next line
    void recompile_line(int line, int line_width, int from,  int margin, int comment, modeStack& stack) ;
    aString work_area ;
    Screen& screen ;
    int compiled ;
    int show_line_end_marks ;
    int activeSpelling ;
public:
    void deactivateSpelling() { activeSpelling = 0 ; }
    hebString(HebrewEditor *he, const char *t,int startHebrew, hebStringMode majorMode, Screen &scr,
              int show_line_end_marks=1, int activeSpelling=0) :
        aString(t),
        he(he),
        startHebrew(startHebrew),
        modified(1),
        last_str_mode(majorMode),
        special_separator(scr.special_separator),
        screen(scr),
        compiled(0),
        show_line_end_marks(show_line_end_marks),
        activeSpelling(activeSpelling) {
       last_mode_stack.push(majorMode,"",0) ;
    }
    virtual ~hebString() ;
    /* Show how a line should be displayed on the screen */
    char *represent(int line_width, // actually this is the window width
                    int line_offset) ;// the relative screen line number with in
                                    // the actual text
    void recompile(int line_width, modeStack& activeStack) ; // incase this line is recompiled in reference to
    void respell(int line_width, modeStack& activeStack) ; // incase this line is recompiled in reference to
                                                                                                              // previous lines
    void check_recompile(int line_width, int line_offset=0) ; // check if modified then recompile
    int line_count(int line_width) ; // return the number of virtual lines
    int needToRecompileNextLine(int line_length) { check_recompile(line_length) ; return last_stack_depth > 1; }
    void _delete_ch(int at, int line_offset) ;
    void delete_ch(int at,int line_length) ; // virtual location
    int _insert_ch(int at, int line_offset, unsigned char ch, int x_pos=-1) ;
    void insert_ch(int at,unsigned char ch) ; // virtual location
    void _replace_ch(int at,unsigned char ch) ;
    void replace_ch(int at,unsigned char ch) ; // virtual location
    char *split(int at) ;
    hebStringMode getMajorMode() { return last_mode_stack.majorMode() ; }
    int getCurrentXlocation(int line_offset, int x_pos) ;
    hebStringMode getCurrentXlang(int line_offset, int x_pos) ;
    int getCurrentXcode(int line_offset, int x_pos) ;
    modeStack& getLastModeStack() { return last_mode_stack ; }

    void printLocations() ;
    int isStackValid()  { return compiled ; }
    int getMargin() { return compiled ? last_representation[0]->getMargin() : 0; } //PORT: condition changed to return 0 when !compiled
    void set_show_line_end_marks(int v) { show_line_end_marks = v ; }
} ;
#endif
