/***************************************************************************
                          sysdep.h - System dependent definitions
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// in a unix system use curses for screen management

#include "util.h"

#define DEFAULT_LATEX "laxet"

#ifdef IBMOS2
#include "VioScr.h"
#define HEBREW_NEWCODE 128
#define HEBREW_ALTERNATE_CODE 224
#define SCREEN VioScreen
#define CASE_COMPARE stricmp
#define DEFAULT_DVIVIEW "pmdvi"
#define DISCARD_OUTPUT " 2>/dev/nul"
#define LSTAT stat
#elif WIN32
#include "ConsoleScr.h"
#define HEBREW_NEWCODE 128
#define HEBREW_ALTERNATE_CODE 224
#define SCREEN ConsoleScreen
#define CASE_COMPARE stricmp
#define DEFAULT_DVIVIEW "windvi"
#define DISCARD_OUTPUT " 2>/dev/nul"
#define LSTAT stat
#else
#include "CursesScreen.h"
#define HEBREW_NEWCODE 224
#define HEBREW_ALTERNATE_CODE 128
#define SCREEN CursesScreen
#define CASE_COMPARE strcasecmp
#define DEFAULT_DVIVIEW "xdvi"
#define DISCARD_OUTPUT " 2>/dev/null"
#define LSTAT lstat
#endif

#define PROGRAM_PREFIX_VAR "HEDIR"
#define KEY_BINDINGS_FILE ".he2rc"
