#!/bin/sh
# $Id: healthdc_wrapper.sh,v 1.1.2.1 2003/01/26 15:38:37 housley Exp $
# Wrapper for healthdc
# Call with no args to get an ASCII table, otherwise acts like healthdc
if [ x$1 = x-- -o `expr "x$1" : x-` != 2 ]; then
    [ x$1 = x-- ] && shift
    healthdc -h -- $@ | awk '{
        gsub(/<[^>]*>/, " ");
        if (NF <= 1) {
            print $NF;
        } else {
            s=$1;
            for (i=2; i<NF; i++) { s = s " " $i; }
            printf "   %-25s %s\n", s, $NF;
        }
    }'
else
    healthdc $@
fi
