#!/bin/sh
#
# $Id: healthd.sh,v 1.1.2.7 2004/06/23 14:11:57 housley Exp $
#

# PROVIDE: healthd
# REQUIRE: LOGIN
# KEYWORD: FreeBSD shutdown

#
# Add the following line to /etc/rc.conf to enable healthd:
#
#healthd_enable="YES"
#
# For IPv4 only operation add the following line to /etc/rc.conf:
#
#healthd_flags="-6"
#
# Other options are listed in healthd(8)
#

. /usr/local/etc/rc.subr

name=healthd
rcvar=`set_rcvar`

extra_commands="reload"

command=/usr/local/sbin/healthd
required_files=/usr/local/etc/${name}.conf

# set defaults

healthd_enable=${healthd_enable:-"NO"}
healthd_flags=${healthd_flags:-""}

load_rc_config ${name}
run_rc_command "$1"
