/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <ctype.h>
#include <stdio.h>
#include <time.h>
#include "x10.h"
#include "version.h"
#include "process.h"

extern char hc2char();
extern unsigned int x2unitmap();

extern int Irev, Idays, Ihours, Iminutes, Ijday, Iseconds;
extern int Istatdim, Istatmon, Iaddmon;

extern unsigned int Ibattery;

extern unsigned char Ihcode;
extern void error();
extern char *heyu_tzname[];
extern struct tm *cm11a_to_legal();
extern CONFIG config;

extern char *wdays[];

/* ARGSUSED */

int c_info( int argc, char *argv[] )
{
    char RCSID[]= "@(#) $Id: info.c,v 1.10 1999/12/13 21:04:14 dbs Exp $\n";
    extern int usage(), get_status();
    extern char *bits2day(), *b2s();

    static char *m_names[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                              "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    struct tm *tms;
    int expire;
    char error_msg[127];


    display(RCSID);

    if (argc != 2)
	usage(E_2MANY);

    if ( config.device_type & DEV_CM10A ) {
       printf("CM10A interface on %s\n", config.tty);
       return 0;
    }
    
    if ( get_status() < 0 ) {
	 sprintf(error_msg, 
	    "No response from the CM11A on %s\nProgram exiting.",
	        config.tty);
         error(error_msg);
    }

    printf("Heyu version %s\n", VERSION);
    printf("Interface on %s\n", config.tty);
    printf("Firmware revision Level = %d\n", Irev );

    /* Display CM11a battery timer */
    if ( Ibattery == 0xFFFF ) 
       (void) printf("Interface battery usage = Unknown (0xFFFF)\n");
    else
       (void) printf("Interface battery usage = %d:%02d  (hh:mm)\n", 
                                          Ibattery / 60, Ibattery % 60);

    if ((Ihours + Iminutes + Idays + Ijday) != 0 )  {
	(void) printf("Raw interface clock: %s, %02d:%02d:%02d, Day %d\n",
		      bits2day(Idays), Ihours, Iminutes, Iseconds, Ijday);

        tms = cm11a_to_legal(&Idays, &Ijday, &Ihours, &Iminutes, &Iseconds, &expire);

        if ( expire != BAD_RECORD_FILE ) {
           (void) printf("(--> Civil Time: %s  %02d:%02d:%02d  %s %02d %d %s)\n",
               bits2day(Idays), tms->tm_hour, tms->tm_min, tms->tm_sec, 
               m_names[tms->tm_mon], tms->tm_mday, tms->tm_year + 1900,
               heyu_tzname[tms->tm_isdst]);
        }
        
        display_status_message( expire );
    }
    else
	(void) printf("Interface clock not yet set\n");

    (void) printf("Housecode = %c\n", toupper(hc2char(Ihcode)));
    
    (void) printf("0 = off, 1 = on,               unit  16.......8...4..1\n");

    (void) printf("Last addressed device =       0x%04x (%s)\n", Iaddmon,
            b2s(x2unitmap(Iaddmon)) );
    (void) printf("Status of monitored devices = 0x%04x (%s)\n", Istatmon,
            b2s(x2unitmap(Istatmon)) );
    (void) printf("Status of dimmed devices =    0x%04x (%s)\n", Istatdim,
            b2s(x2unitmap(Istatdim)) );
    return(0);
}

void wait_next_tick (void )
{
   time_t first, now;
   int j;

   time(&first);
   
   for ( j = 0; j < 25; j++ ) {
      time(&now);
      if ( now > first )
         break;
      millisleep(50);
   }
   return;
}   
   
      
	
int c_readclock( int argc, char *argv[] )
{
    extern int usage(), get_status();
    extern char *bits2day(), *b2s();

    static char *m_names[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                              "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    time_t    now;			      
    struct tm *tms;
    int expire;
    char error_msg[127];


    if (argc != 2)
	usage(E_2MANY);

    if ( config.device_type & DEV_CM10A ) {
       printf("CM10A interface has no clock.\n");
       return 1;
    }

    wait_next_tick();

    if ( get_status() < 0 ) {
	 sprintf(error_msg, 
	    "No response from the CM11A on %s\nProgram exiting.",
	        config.tty);
         error(error_msg);
    }

    if ((Ihours + Iminutes + Idays + Ijday) != 0 )  {

        tms = cm11a_to_legal(&Idays, &Ijday, &Ihours, &Iminutes, &Iseconds, &expire);

        if ( expire != BAD_RECORD_FILE ) {
           (void) printf("CM11A Time : %s  %02d:%02d:%02d  %s %02d %d %s\n",
               bits2day(Idays), tms->tm_hour, tms->tm_min, tms->tm_sec, 
               m_names[tms->tm_mon], tms->tm_mday, tms->tm_year + 1900,
               heyu_tzname[tms->tm_isdst]);
	   time(&now);
	   tms = localtime(&now);
	   (void) printf("System Time: %s  %02d:%02d:%02d  %s %02d %d %s\n",
	       bits2day(1 << tms->tm_wday), tms->tm_hour, tms->tm_min, tms->tm_sec,
	       m_names[tms->tm_mon], tms->tm_mday, tms->tm_year + 1900,
	       heyu_tzname[tms->tm_isdst]);
		      
        }
	else {
	   (void) fprintf(stderr, "File x10record has been corrupted.\n");
	   return 1;
	}
    }
    else
	(void) printf("Interface clock not yet set\n");

    return 0;
}
