
/* Some array length limits */
#define NAME_LEN         32   /* Alias label length */
#define MACRO_LEN        32   /* Macro label length */
#define SCENE_LEN        32   /* Scene label length */
#define PATH_LEN        127   /* File paths */
#define LINE_LEN       4096   /* Line length in input files */ 

/* Values for x10config variables DAWN_OPTION and DUSK_OPTION */
#define FIRST        1
#define EARLIEST     2
#define LATEST       3
#define AVERAGE      4
#define MEDIAN       5

/* Bitmaps for x10config variables LAUNCH_SOURCE */
#define SNDC     1
#define SNDM     2
#define SNDP     4
#define SNDS     8
#define SNDT    16
#define RCVI    32
#define RCVT    64
#define SNDA   128
#define LSNONE 256
#define LSALL  (SNDC | SNDM | SNDT | RCVI | RCVT | SNDA)

enum {SndC, SndM, SndP, SndS, SndT, RcvI, RcvT, SndA};

/* Bitmaps for script options */
#define SCRIPT_HEYU     0  /* Generate heyu environment for scripts */
#define SCRIPT_XTEND    1  /* Generate xtend environment for scripts */
#define LEVEL_RAW       2  /* Heyu environ variables use raw levels */
#define ENV_ALIAS       4  /* Include X10_<alias label> environ variables */
#define SCRIPT_NOENV    8  /* Create no new environment variables */
#define SCRIPT_QUIET   16  /* Suppress display of command line in log file */

#if 0
/* Used by get_script(), get_launcher() */
#define HAS_NOLABEL  0
#define HAS_LABEL    1
#endif

/* Values for script_mode */
#define HEYU_SCRIPT     0  /* Use general heyu scripting */
#define HEYU_HELPER     1  /* Use heyuhelper */

/* Function Modes */
#define FUNC_ACTUAL   0
#define FUNC_GENERIC  1

/* Flags for alias options (Preset modules only) */
#define ALFLAG_RESUME  1     /* 'resume level' has been set */
#define ALFLAG_FIXED   2     /* 'fixed on level' has been set */

/* Values for x10config variabe RESOLVE_OVERLAP */
#define RES_OVLAP_SEPARATE  0
#define RES_OVLAP_COMBINED  1

/* Yes/No */
#define NO      0
#define YES     1
#define VERBOSE 3

/* Old/New */
#define OLD     0
#define NEW     1

/* Manual or Automatic */
#define MANUAL    0
#define AUTOMATIC 1

/* For MIN/MAX DAWN/DUSK */
#define OFF    -1

/* Bitmaps for mode variables */
#define UNSPECIFIED  0
#define COMPATIBLE   1
#define HEYU_MODE    2
#define HAS_TIMERS  16

/* Values for variable CM11A_DAY_ZERO */
#define ZERO         0
#define TODAY        1
#define MIXED        2

/* Values involving the X10 Record File */
#define VALID_RECORD_FILE   0
#define SCHEDULE_EXPIRED   -1
#define NO_EXPIRATION      -2
#define NO_RECORD_FILE     -3
#define BAD_RECORD_FILE    -4

/* Prefixes for combined and delay-modified macro names */
#define COMB_MAC_PREFIX     "_co"
#define DELAY_MAC_PREFIX    "_de"
#define SECUR_MAC_PREFIX    "_se"
    
#if 0
/* Location where config and other fixed files are stored */
#define HOMEBASEDIR           ".heyu/"     /* If under user $HOME */
#define HEYU_BASE_HOME        ".heyu/"     /* If under user $HOME */
#define HEYU_BASE_SYS         "/etc/heyu/" /* If under system */
#endif

/* Prefix for subdirectories under xxxBASEDIR      */
/* (For optional use with command line parameters  */
/* -0 ... -9 when there is a CM11A interface on    */
/* more than one serial port.)                     */
#define HEYUSUB_PREFIX        ""

#if 0
/* Location where report and other files are written */
#define ALTBASEDIR            HOMEBASEDIR
#define ALT_BASE_HOME         HEYU_BASE_HOME
#endif

/* Files which must have a fixed name and be */
/* in a fixed location.                      */

#define CONFIG_FILE           "x10config"
#define CONFIG_FILE_ETC       "x10.conf"
#define RECORD_FILE           "x10record"
#define MACROXREF_FILE        "x10macroxref"
#define IMAGE_FILE            "x10image"
#define STATE_FILE            "x10state"

/* Device types */
#define DEV_CM11A    0
#define DEV_CM10A    1
#define DEV_CM17A    2
#define DEV_W800RF32 4
#define DEV_MR26A    8

/* The state file in SPOOLDIR/ */
#if 0
#define X10STATE_FILE     "heyu.state"
#endif

/* The state engine lockfile */
#define STATE_LOCKFILE    "heyu.engine"

/* These files are written for 'heyu upload' or    */
/* 'heyu upload check' if the WRITE_CHECK_FILES    */
/* directive in the x10config file is YES.         */
#define RECORD_FILE_CHECK     "x10record.check"
#define MACROXREF_FILE_CHECK  "x10macroxref.check"
#define IMAGE_BIN_FILE        "x10image.bin"
#define IMAGE_FILE_CHECK      "x10image.check"
#define IMAGE_HEX_FILE        "x10image.hex"

/* Other files */
#define REPORT_FILE       "report.txt"
#define CRON_REPORT_FILE  "cronreport.txt"
#define SUN_TABLE_FILE    "sun_%d.txt"

enum {RiseSet, CivilTwi, NautTwi, AstroTwi};

/* Default values for X10 configuration file */

#define DEF_MODE                  COMPATIBLE
#define DEF_SCHEDFILE             "x10.sched"
#define DEF_PROGRAM_DAYS          366
#define DEF_COMBINE_EVENTS        YES
#define DEF_COMPRESS_MACROS       NO 
#define DEF_FEB_KLUGE             YES
#define DEF_HOUSECODE             'A'
#define DEF_DAWN_OPTION           FIRST
#define DEF_DUSK_OPTION           FIRST
#define DEF_DAWN_SUBSTITUTE       (6*60)
#define DEF_DUSK_SUBSTITUTE       (18*60)
#define DEF_MIN_DAWN              OFF
#define DEF_MAX_DAWN              OFF
#define DEF_MIN_DUSK              OFF
#define DEF_MAX_DUSK              OFF
#define DEF_CHECK_FILES           NO
#define DEF_TTY                   "/dev/ttyS0"
#define DEF_REPL_DELAYED_MACROS   YES
#define DEF_FORCE_ADDR            NO
#define DEF_ACK_HAILS             NO
#define DEF_TRIGGER_TAG           YES
#define DEF_XREF_APPEND           NO
#define DEF_RCS_TEMPERATURE       NO
#define DEF_MACTERM               YES
#define DEF_MAX_PPARMS            8
#define DEF_STATUS_TIMEOUT        2
#define DEF_SPF_TIMEOUT           3
#define DEF_DISPLAY_OFFSET        YES
#define DEF_RESERVED_TIMERS       0
#define DEF_DISPLAY_EXP_MACROS    YES
#define DEF_AUTO_CHAIN            NO
#define DEF_MODULE_TYPES          YES
#define DEF_LAUNCH_MODE           TMODE_SIGNAL
#define DEF_LAUNCH_SOURCE         RCVI
#define DEF_RES_OVERLAP           RES_OVLAP_SEPARATE
#define DEF_DEFAULT_MODULE        "LM"
#define DEF_SCRIPT_OPTION         SCRIPT_HEYU
#define DEF_SCRIPT_MODE           HEYU_SCRIPT
#define DEF_FUNCTION_MODE         FUNC_ACTUAL
#define DEF_LOGFILE               "/dev/null"
#define DEF_ISDARK_OFFSET         30
#define DEF_ENV_ALIAS_PREFIX      "x10"
#define DEF_DEVICE_TYPE           DEV_CM11A
#define DEF_SUNMODE               RiseSet
#define DEF_FIX_5A                YES
#define DEF_AUTOFETCH             YES
#define DEF_PFAIL_UPDATE          YES
#define DEF_CM17A_BIT_DELAY       500
#define DEF_RF_BURST_SPACING      110
#define DEF_RF_TIMER_TWEAK        20
#define DEF_RF_POST_DELAY         850
#define DEF_RF_FARB_DELAY         850
#define DEF_DISP_RF_XMIT          YES
#define DEF_RF_BURSTS              5
#define DEF_RESTRICT_DIMS         YES
#define DEF_STATE_FORMAT          NEW
#define DEF_CM11_POST_DELAY        80  /* 4 cycles @ 50 Hz */
#define DEF_START_ENGINE          MANUAL
#define DEF_RF_NOSWITCH           NO
#define DEF_RESPOOL_PERMS         01777
#define DEF_SPOOLFILE_MAX         1000000
#define DEF_CHECK_RI_LINE         YES
#define DEF_SEND_RETRIES           3

#define SPOOLFILE_ABSMIN  20
#define SPOOLFILE_ABSMAX  0x100000

/* Max errors to display before quitting when */
/* parsing configuration or schedule files.   */

#define MAX_ERRORS     15  

/* Bitmap flags for timers and tevents */
#define NO_EVENT           0
#define CLOCK_EVENT        1
#define DAWN_EVENT         2
#define DUSK_EVENT         4
#define SEC_EVENT          8

#define PRT_EVENT         16
#define COMB_EVENT        32
#define SUBST_EVENT       64
#define LOST_EVENT       128

#define TMP_EVENT        256
#define ACTIVE_EVENT     512
#define NOW_EVENT       1024
#define CHAIN_EVENT     2048
#define CANCEL_EVENT    4096
#define INVALID_EVENT   0xFFFF
#define TIME_EVENTS     (CLOCK_EVENT | DAWN_EVENT | DUSK_EVENT)
#define NOCOPY_EVENTS   (PRT_EVENT | LOST_EVENT)

/* Event cancellation flags */
#define MIN_DAWN_CANCEL   1
#define MAX_DAWN_CANCEL   2
#define MIN_DUSK_CANCEL   4
#define MAX_DUSK_CANCEL   8

/* Dawn/Dusk limit option flags */
#define DAWNGT   1
#define DAWNLT   2
#define DUSKGT   4
#define DUSKLT   8

/* Bitmap for shifted events */
#define SAME_DAY       0
#define PREV_DAY       1
#define NEXT_DAY       2

/* Bitmap used by function macro_index() */
#define MACRO_PARSER     1
#define TIMER_PARSER     2
#define TRIGGER_PARSER   4
#define CHAIN_PARSER     8
#define MACRO_DUPLICATE 16
#define DERIVED_MACRO   32

/* Macro modification bitmap */
#define UNMODIFIED    0
#define COMBINED      1
#define COMPRESSED    2
#define DELAY_MOD     4
#define SECURITY_MOD  8
#define TERMINATE    16
#define CHAINED      32

#define NULL_MACRO_INDEX  0
#define NULL_MACRO_OFFSET 0
#define NULL_TIME         (120 * 0x0f + 0x7f)  /* ( = 1927 minutes ) */

/* Flag values for valid Lat/Long. */
#define LATITUDE       1
#define LONGITUDE      2

/* Controls accepted by function get_freespace() */
#define ALL_TIMERS   1
#define CLK_TIMERS   2

/* Arguments for process_data() */
#define PROC_CHECK   1
#define PROC_UPLOAD  2

/* Identifies macros which are used over the programmed interval */
#define NOTUSED   0
#define USED      1

#define ACTIVE_START 1
#define ACTIVE_STOP  2

/* Values for Trigger Off/On mode in schedule */
#define TRIGGER_OFF  0
#define TRIGGER_ON   1

/* Value for Trigger Tag */
#define TRIGGER_TAG  0x40
#define TIMER_EXEC    0
#define TRIGGER_EXEC  1

/* Values for CM11a security mode bits and offset adjustment */
#define SECURITY_OFF  0x00
#define SECURITY_ON   0x02
#define SECURITY_OFFSET_ADJUST 30

/* Bitmap flags for "as-of" dates and times */
#define ASIF_NONE  0
#define ASIF_DATE  1
#define ASIF_TIME  2

/* Controls for time_adjust() */
#define LGL2STD    0
#define STD2LGL    1

/* Bitmap flags for SCENE/USERSYN */
#define F_SCENE    1
#define F_USYN     2

/* How to interpret undefined legal times, e.g., in the */
/* USA, times between 02:00 and 02:59 on the day when   */
/* Daylight Time goes into effect.                      */
#define STD_TIME      0
#define DST_TIME      1
#define UNDEF_TIME    STD_TIME

/* An env variable name for use by the relay */
#define CLOCKSTAMP    "HEYUCLOCKSTAMP"

/* Delay after setclock, reset, purge, or clear */
#define SETCLOCK_DELAY    2000  /* milliseconds */

/* Flags for parse_addr() function */
#define A_VALID   1
#define A_HCODE   2
#define A_BMAP    4
#define A_PLUS    8
#define A_MINUS  16
#define A_ALIAS  32
#define A_DUMMY  64
#define A_MULT  128

/* CM17A RF Timing modes */
#define RF_SLOW  0
#define RF_FAST  1

/* Origin of call to parse_config_tail() */
#define SRC_CONFIG    1
#define SRC_SCHED     2
#define SRC_ENVIRON   4
#define SRC_STOP      8
#define SRC_HELP     16
#define SRC_SYSCHECK 32

/* Phase synch modes */
#define NO_SYNC      0
#define RISE_SYNC    1
#define FALL_SYNC    2

/* State engine command functions  */
/* 3 bytes: header, function, data */
#define ST_COMMAND       0x7b  /* header */
#define ST_INIT_ALL      0
#define ST_INIT          1
#define ST_WRITE         2
#define ST_LAUNCH        3
#define ST_LAUNCH_GLOBAL 4
#define ST_CHKSUM        5
#define ST_APPEND        6
#define ST_EXIT          7
#define ST_MSG           8
#define ST_XMITRF        9
#define ST_RESETRF      10
#define ST_REWIND       11
#define ST_INIT_OTHERS  12
#define ST_BUSYWAIT     13
#define ST_SOURCE       14
#define ST_FLAGS        15
#define ST_PFAIL        16
#define ST_SHOWBYTE     17
#define ST_CLRSTATUS    18
#define ST_VDATA        19

/* Launch trigger modes */
#define TMODE_SIGNAL  0
#define TMODE_MODULE  1

/* Launcher types */
#define L_NORMAL    0
#define L_POWERFAIL 1
#define L_ADDRESS   2

/* Flags for powerfail time relative to relay startup */
#define R_ATSTART     1
#define R_NOTATSTART  2
/* Time in seconds defining R_ATSTART versus R_NOTATSTART */
#define ATSTART_DELAY 10

/* Daemon which launches script */
#define D_CMDLINE   0
#define D_ENGINE    1
#define D_RELAY     2
#define D_AUXDEV    3

/* Flag modification modes */
#define CLRFLAG  0
#define SETFLAG  1

/* Bitmap definitions for Heyu script environment variables */
#define HEYUMAP_LEVEL 0x00ff  /* Lowest byte is level 0-100 */
#define HEYUMAP_APPL  0x0100  /* Appliance (non-dimmable) module */
#define HEYUMAP_OFF   0x0200  /* Off state */
#define HEYUMAP_ADDR  0x0400  /* Addressed state */
#define HEYUMAP_CHG   0x0800  /* Changed state */
#define HEYUMAP_DIM   0x1000  /* Dimmed state */
#define HEYUMAP_ON    0x2000  /* On state */

/* Bitmap definitions for Xtend script environment variables */
#define XTMAP_APPL  32   /* Appliance module */
#define XTMAP_ADDR  64   /* Addressed state */
#define XTMAP_ON    128  /* On state */

/* Types of data written to the spoolfile by heyu */
enum {SENT_WRMI, SENT_ADDR, SENT_FUNC, SENT_EXTFUNC, SENT_STCMD, SENT_OTHER,
      SENT_MESSAGE, SENT_RF, SENT_FLAGS, SENT_PFAIL, SENT_CLRSTATUS, SENT_VDATA};
  
/* X10 generic signal types */
enum {
  AllOffSignal, LightsOnSignal, OnSignal, OffSignal,
  DimSignal, BriSignal, LightsOffSignal, Ext3Signal, Ext3DimSignal,
  AllOnSignal, PresetSignal, StatusSignal, StatusOnSignal, StatusOffSignal
};

/* Module masks */
enum {
   AllOffMask, LightsOnMask, OnMask, OffMask, DimMask, BriMask,
   BriDimMask, LightsOffMask, StdMask, Ext3Mask, Ext3DimMask, AllOnMask,
   PresetMask, StatusMask, StatusOnMask, StatusOffMask,
   LightsOnFullMask, OnFullMask, OnFullOffMask, ResumeMask,
   TargMask, Exc16Mask, Exc8Mask, Exc4Mask, Ext0Mask, VdataMask, NumModMasks
};

/* Launch trigger types */
enum {
   AllOffTrig, LightsOnTrig, OnTrig, OffTrig, DimTrig, BriTrig,
   LightsOffTrig, ExtendedTrig, HailReqTrig, HailAckTrig,
   PresetTrig, PresetTrig2, DataXferTrig, StatusOnTrig, StatusOffTrig,
   StatusReqTrig, AllOnTrig, ExtPowerUpTrig, VdataTrig, NumTriggers
};

/* X10 functions (must align with funclabel[] in code) */
enum {
   AllOffFunc, LightsOnFunc, OnFunc, OffFunc, DimFunc,
   BrightFunc, LightsOffFunc, ExtendedFunc, HailFunc,
   HailAckFunc, Preset1Func, Preset2Func, DataXferFunc,
   StatusOnFunc, StatusOffFunc, StatusReqFunc, AllOnFunc,
   ExtPowerUpFunc, VdataFunc
};

/* Place to store an alias from user's x10config file */
typedef struct {
  int           line_no;
  char          label[NAME_LEN + 1];
  char          housecode;
  unsigned int  unitbmap;
  int           modtype;
  unsigned long flags;
  unsigned long optflags;
  int           onlevel;
  int           maxlevel;
} ALIAS;

/* Place to store scene definition from config file */
typedef struct {
  int          line_no;
  int          nparms;
  unsigned int type;
  char         label[SCENE_LEN + 1];
  char         *body;
} SCENE;

/* Place to store script info from config file */
typedef struct {
   int line_no;
   char label[NAME_LEN + 1];
   unsigned char script_option;
   unsigned char done;
   char *cmdline;
} SCRIPT ;
 
typedef struct {
   int            line_no;
   char           label[NAME_LEN + 1];
   int            scriptnum;
   unsigned char  type;
   unsigned char  oksofar;
   unsigned int   source;
   unsigned int   nosource;
   unsigned char  hcode;
   unsigned long  afuncmap;
   unsigned long  gfuncmap;
   unsigned int   signal;
   unsigned int   module;
   unsigned int   bmaptrig;
   unsigned int   bmaptrigemu;
   unsigned int   chgtrig;
   unsigned int   flags;
   unsigned int   notflags;
   unsigned char  bootflag;

   unsigned char  genfunc;
   unsigned char  actfunc;
   unsigned char  xfunc;
   unsigned char  level;
   unsigned char  rawdim;
   unsigned int   bmaplaunch;
} LAUNCHER;
 
/* Place to store info from the user's x10config file */
/* and timezone from the system clock/calendar.       */

typedef struct {
  unsigned char read_flag;        /* Indicates config file has been processed */
  unsigned char mode;             /* HEYU or COMPATIBLE (with ActiveHome (tm)) */
  char          schedfile[PATH_LEN + 1];   /* Pathname of x10 schedule file */
  long int      asif_date;        /* Assumed program date (yyyymmdd) instead of today */
  int           asif_time;        /* Assumed minutes after 00:00 Legal time  */
  int           program_days_in;  /* Number of days to program, beginning today */
  int           program_days;     /* Number of days to program, beginning today */
  int           lat_d;            /* Latitude degrees */
  int           lat_m;            /* Latitude minutes */
  int           lon_d;            /* Longitude degrees */
  int           lon_m;            /* Longitude minutes */
  double        latitude;         /* Latitude degrees as double */
  double        longitude;        /* Longitude degrees as double */
  unsigned char loc_flag;         /* Indicates valid Lat and Lon */
  unsigned char feb_kluge;        /* Use FEB_KLUGE config option */
  unsigned char dawn_option;      /* Use First, Average, Median, etc.*/
  unsigned char dusk_option;      /* Use First, Average, Median, etc.*/
  int           sunmode;          /* Definition of Dawn/Dusk */
  int           dawn_substitute;  /* For days when there's no dawn */
  int           dusk_substitute;  /* For days when there's no dusk */
  int           min_dawn;         /* Lower bound on dawn */
  int           max_dawn;         /* Upper bound on dawn */
  int           min_dusk;         /* Lower bound on dusk */
  int           max_dusk;         /* Upper bound on dusk */
  unsigned char combine_events;   /* Similar timed events should be combined */
  unsigned char compress_macros;  /* Merge unit codes in uploaded macro commands */
  unsigned char repl_delay;       /* Flag: Replace delayed macros */
  unsigned char display_offset;   /* Display offsets in report file */
  char          tty[PATH_LEN + 1];   /* Serial port to use */
  char          suffix[PATH_LEN + 1]; /* Suffix for file locks */
  char          ttyaux[PATH_LEN + 1]; /* Auxiliary input serial port */
  char          suffixaux[PATH_LEN + 1]; /* Suffix for aux file lock */
  char          housecode;        /* Base housecode */
  char          force_addr;       /* Send an address byte for all commands */
  unsigned char device_type;      /* Identify non-CM11A interfaces */
  unsigned char auxdev;           /* Auxilliary device type */
  unsigned char newformat;        /* NEWFORMAT flag */
  unsigned char checkfiles;       /* Write .check, .bin, and .hex files? */
  long int      tzone;            /* Timezone */
  unsigned char isdst;            /* Indicates Daylight Time is in effect */
                                  /*   at some time during the year. (Don't */
                                  /*   confuse with CALEND.isdst)           */
  int           dstminutes;       /* Minutes to add to standard time to get DST  */
  ALIAS         *aliasp;          /* Pointer to array of ALIAS structures */
  SCENE         *scenep;          /* Pointer to array of SCENE structures */
  SCRIPT        *scriptp;         /* Pointer to array of SCRIPT structures */
  LAUNCHER      *launcherp;       /* Pointer to array of LAUNCHER structures */
  int           max_pparms;       /* Maximum number of positional parameters */
  int           trigger_tag;      /* Tag trigger events. */
  unsigned int  rcs_temperature;  /* Housecode bitmap for translation via RCS table */
  int           xref_append;      /* Append helper events to x10macroxref entries */
  int           ack_hails;        /* Send hail_ack when a hail is received */
  int           macterm;          /* Terminate each macro */
  int           status_timeout;   /* Loop count for status timeout */
  int           spf_timeout;      /* Loop count for special func timeout */
  int           reserved_timers;  /* Number of timers to hold in reserve */
  int           disp_exp_mac;     /* Display commands in macro in monitor */
  int           auto_chain;       /* Use chained macros for events *WIP* */
  int           module_types;     /* Customize behavior per module type */
  int           launch_mode;      /* Launch on signal or module characteristic */
  int           function_mode;    /* Launch on actual or generic function types */
  unsigned int  launch_source;    /* Signal sources allowed to launch a script */
  unsigned char res_overlap;      /* Resolve overlaps separately or combined */
  int           default_module;   /* Default module type */
  char          script_shell[PATH_LEN + 1]; /* Default shell for scripts */
  char          logfile[PATH_LEN + 1]; /* Log file for state engine output */
  unsigned char script_mode;      /* Use heyuhelper vs general scripts */
  int           isdark_offset;    /* Minutes after Dusk and before Dawn */
  char          env_alias_prefix[8]; /* Prefix for alias env variables */
  unsigned char fix_5a;           /* Modify 5A checksum if possible */
  unsigned char autofetch;        /* Rewrite state file at every state cmd */
  unsigned char pfail_update;     /* Set clock after power restored */
  int           cm11_post_delay;  /* Delay between direct commands */
  int           cm17a_bit_delay;  /* Intra-bit delay for CM17A commands (us) */
  int           rf_burst_spacing; /* Time between successive CM17A RF bursts */
  int           rf_timer_tweak;   /* Correct for millisleep low resolution */
  int           rf_post_delay;    /* Post-delay for normal CM17A commands (ms) */
  int           rf_farb_delay;    /* Post delay for farb CM17A command (ms) */
  unsigned char disp_rf_xmit;     /* Display CM17A transmissions in monitor */
  unsigned char def_rf_bursts;    /* Nominal CM17A RF bursts */
  unsigned char rf_bursts[8];     /* CM17A RF bursts for each CM11A function */
  unsigned long timer_loopcount;  /* 1 second countdown base for timing loops */
  unsigned char restrict_dims;    /* Restrict dims/brights to range 1-22 */
  unsigned char state_format;     /* New or old (heyuhelper-style) state format */
  char          *pfail_script;    /* Script command line run by relay after power fail */
  unsigned char start_engine;     /* Start engine automatically or manually */
  unsigned char rf_noswitch;      /* Suppress switch in TM751 and RR501 Xceivers */
  unsigned int  respool_perms;    /* Permissions for re-creating SPOOLDIR */
  unsigned long spool_max;        /* Spool file size when rewind is attempted. */
  unsigned char check_RI_line;    /* Check RI serial line before sending command. */
  int           send_retries;     /* Number of times to try sending a command */
} CONFIG;


/* Place to store timed events from timers */
typedef struct {
   int            line_no;          /* Line number in input file */
   unsigned char  pos;              /* Start (1) or stop (2) position in input timer. */
   int            link;             /* Index to next tevent in linked list */
   int            plink;            /* Backlink for printing */
   int            chain_len;        /* Length of chain of macros */
   int            timer;            /* Index of input timer */
   int            trig;             /* Index to trigger, if any */
   unsigned char  generation;       /* Parent or Child */
   unsigned char  done;             /* Has been processed. */
   unsigned char  combined;         /* Number of combined tevents */
   unsigned char  cancel;           /* Min/Max Dawn/Dusk cancel flags */
   int            print;            /* Number of headers to be printed */
   unsigned char  dow_bmap;         /* Days of Week bitmap */
   int            sched_beg;        /* Begin date as integer mmdd */
   int            sched_end;        /* End date as integer mmdd */
   unsigned char  spflag;           /* (Reserved) */
   int            spindex;          /* (Reserved) */
   int            *spdata;          /* (Reserved) */
   int            notify;           /* Notify days before expire */
   int            resolv_beg;       /* Resolved day of year to begin */
   int            resolv_end;       /* Resolved day of year to end */
   unsigned int   flag;             /* Clock, Dawn, or Dusk, plus other flags */
   unsigned int   flag2;            /* Auxilliary flag */                       
   int            offset;           /* Minutes from Midnight or Dawn/Dusk */
   unsigned char  delay;            /* Macro delay, 0-240 min */
   int            security;         /* Security event offset */
   unsigned char  ddoptions;        /* Dawn/Dusk option flags */
   int            dawnlt;           /* DAWNLT time */
   int            dawngt;           /* DAWNGT time */
   int            dusklt;           /* DUSKLT time */
   int            duskgt;           /* DUSKGT time */
   int            lostday;          /* Day shifted out of program period */
   int            macro;            /* Index into MACRO array */
   int            *ptr;             /* Pointer used in resolve_times() */
   int            intv;             /* Index into array of subintervals */
   int            nintv;            /* Number of subintervals */
} TEVENT;

/* Place to store info about a timer command */
typedef struct {
   int            line_no;          /* Line number in input file */
   int            line1;            /* Start event original timer */
   int            line2;            /* Stop event original timer */
   unsigned char  pos1;             /* Start event original timer start or stop */
   unsigned char  pos2;             /* Stop event original timer start or stop */
   int            link;             /* Index of next timer in linked list */
   int            tevent_start;     /* Index of ancestor tevent for start */
   int            tevent_stop;      /* Index of ancestor tevent for stop */
   unsigned char  generation;       /* Parent or Child */
   unsigned char  dow_bmap;         /* Days of Week bitmap */
   int            sched_beg;        /* Begin date as integer mmdd */
   int            sched_end;        /* End date as integer mmdd */
   unsigned char  spflag;           /* (Reserved) */
   int            spindex;          /* (Reserved) */
   int            *spdata;          /* (Reserved) */
   int            notify;           /* Notify days before expire. */
   int            resolv_beg;       /* Resolved day of year to begin */
   int            resolv_end;       /* Resolved day of year to end */
   unsigned int   flag_start;       /* Start based on Clock, Dawn, or Dusk */
   unsigned int   flag_stop;        /* Stop based on Clock, Dawn, or Dusk */
   unsigned int   flag_combined;    /* Above flags or'd together */
   int            dawnlt;           /* DAWNLT option - minutes from midnight */
   int            dawngt;           /* DAWNGT option - minutes from midnight */
   int            dusklt;           /* DUSKLT option - minutes from midnight */
   int            duskgt;           /* DUSKGT option - minutes from midnight */
   unsigned char  ddoptions;        /* Flags for above options */
   unsigned char  cancel;           /* Min/Max Dawn/Dusk cancel flags */
   int            offset_start;     /* Minutes from Midnight or Dawn/Dusk */
   int            offset_stop;      /* Minutes from Midnight or Dawn/Dusk */
   unsigned char  delay_start;      /* Macro delay, 0-240 min */
   unsigned char  delay_stop;       /* Macro delay, 0-240 min */
   int            security_start;   /* Security mode flag for start time */
   int            security_stop;    /* Security mode flag for stop time */
   int            macro_start;      /* Index into MACRO array */
   int            macro_stop;       /* Index into MACRO array */
   int            error_start;      /* Max Dawn/Dusk error in start time */
   int            error_stop;       /* Max Dawn/Dusk error in stop time */
   int            *ptr_start;       /* Pointer used in resolve_sun_times() */
   int            *ptr_stop;        /* Pointer used in resolve_sun_times() */
   int            num_ptr;          /* Number of above pointers actually used */
   int            intv;             /* Index into array of subintervals */
   int            nintv;            /* Number of subintervals */
   int            memloc;           /* Offset of timer in Cm11a memory image */
} TIMER;

/* Place to store info about a trigger command */
typedef struct {
   int           line_no;          /* Line number in input file */
   unsigned char housecode;        /* x10 code for housecode */
   unsigned char unitcode;         /* x10 code for unit code */
   unsigned char command;          /* Command: ON = 1, OFF = 0 */
   int           macro;            /* Index into MACRO array */
   unsigned char tag;              /* Sequence number 1-7 for triggers to above macro */
   int           memloc;           /* Offset of trigger in Cm11a memory image */
} TRIGGER;

/* Place to store info about a macro */
typedef struct {
   int           line_no;          /* Line number in input file */
   int           link;             /* Index of next macro in linked list */
   int           rlink;            /* Index of previous macro in linked list */
   char          label[MACRO_LEN + 1]; /* Name of macro             */
   unsigned char refer;            /* Indicates parsers which reference the macro */
   int           trig;             /* Trigger index, if any */
   unsigned char use;              /* Use macro in current program */
   unsigned char flag;             /* Macro flags */
   unsigned char modflag;          /* Macro modification flags */
   unsigned char delay;            /* Delay time in seconds 0-240 */
   int           offset;           /* Offset of macro in CM11a memory image */
   int           element;          /* Index into list of macro elements. */
   int           nelem;            /* Number of elements. */
   int           total;            /* Total size of element code (bytes) */
   unsigned char isnull;           /* Indicates if this is the null macro */
} MACRO;

/* Place to store calendar information */
typedef struct {
  int           year;        /* year */
  int           month;       /* month (1-12) */
  int           mday;        /* day of month (1-31) */
  int           yday;        /* day of year (0-365) */
  int           create_day;  /* day of year (0-365) */
  int           minutes;     /* minutes from 0:00 hours Legal time */
  int           day_zero;    /* day of year corresponding to CM11a day 0 */
  long          jan1day;     /* Day number on 1 Jan counted from 1 Jan 1970 */
  long          today;       /* Day number today counted from 1 Jan 1970 */
  unsigned char isdst;       /* Indicates daylight time is in effect this day */
                             /* (Don't confuse with CONFIG.isdst)             */
  unsigned char valid;       /* Indicates the above info has been filled in */
  unsigned char asif_flag;   /* 0 indicates today's date; 1 indicates noon on */
                             /*  ASIF_DATE in configuration file. */
} CALEND;

/* Structure used by heyu_getopt() */
struct opt_st {
   char *configp;
   char *schedp;
   char *subp;
   int  verbose;
   int  linesync;
};

/* Contains info written to or read from the x10record file */
struct record_info {
   unsigned char isready;
   long int      dayset;
   int           yday;
   int           day_zero;
   long int      tzone;
   unsigned int  flags;
   int           dstminutes;
   int           program_days;
};

/* Used by function write_macroxref() */
struct macindx {
   int  index;
   int  offset;
};

/* Used by function display_events() */
struct ev_s {
   int tevent;
   int timer;
   int line;
   int pos;
   int tpos;
   int beg;
   int flag;
};

#ifndef min
#define min( a, b )  ((a) < (b) ? (a) : (b))
#endif

#ifndef max
#define max( a, b )  ((a) > (b) ? (a) : (b))
#endif

#ifndef abs
#define abs( a )   ((a) < 0 ? -(a) : (a))
#endif

int code2unit ( unsigned char );
int bmap2wday ( unsigned char );
int isleapyear ( int ); 
int get_dst_info ( int );
int isdst_test ( int, int );
int parse_latitude ( char * );
int parse_longitude ( char * );
int parse_config ( FILE * );
int get_alias ( ALIAS *, char *, char *, unsigned int * );
int alias_lookup ( char *, char *, unsigned int * );
int add_alias ( ALIAS **, char *, int, char, char *, int );
int parse_time_token ( char *, int * );
int spawn_child_tevent ( TEVENT **, int );
int spawn_child_timer ( TIMER **, int );
int timer_index ( TIMER ** );
int tevent_index ( TEVENT ** );
int update_current_timer_generation ( void );
int update_current_tevent_generation ( void );
int update_current_timer_generation_anyway ( void );
int trigger_index ( TRIGGER ** );
int macro_element_index ( unsigned char **, int );
int macro_index ( MACRO **, char *, unsigned char );
int intv_index ( int **, unsigned int * );
int parse_sched ( FILE *, TIMER **, TRIGGER **, MACRO **, unsigned char ** );
int parse_timer ( TIMER **, MACRO **, char * );
int parse_trigger ( TRIGGER **, MACRO **, char * );
int parse_macro ( MACRO **, unsigned char **, char * );
int is_compatible ( TEVENT *, TEVENT * );
int reconstruct_timers ( TEVENT *, TIMER ** );
int iter_mgr ( int, long *, long, int * );
int set_suntime ( int *, int, int, unsigned char, int * );
int resolve_sun_times ( TIMER **, CALEND *, int, int *, int * );
int get_freespace ( int, TIMER *, TRIGGER *, MACRO * );
int write_image_bin ( char *, unsigned char * );
int write_image_hex ( char *, unsigned char * );
int write_record_file ( char *, CALEND * );
int read_record_file ( void );
int get_upload_expire ( void ); 
int compmac ( struct macindx *, struct macindx * );
int write_macroxref ( char *, MACRO *, unsigned char *, int );
int process_data ( int );
int crontest ( void );
int write_sun_table ( int, int, int, int );
int comp_events ( struct ev_s *, struct ev_s * );
int display_events ( FILE *, TIMER *, TEVENT *, MACRO *, CALEND * );
int display_timers ( FILE *, TIMER *, TEVENT *, MACRO * );
int display_macros ( FILE *, unsigned char, MACRO *, unsigned char * );
int final_report ( char *, CALEND *, TIMER *, TEVENT *, 
                        TRIGGER *, MACRO *, unsigned char *, int );
int c_upload ( int, char ** );
int c_utility ( int argc, char ** );
int is_tevent_similar ( int, int, TEVENT * );
int compress_elements ( unsigned char *, int *, int * );
int verify_tevent_links ( TEVENT * );
int verify_timer_links ( TIMER * );
int macro_element_length ( unsigned char );

void tp ( int );
void bcx ( char *, int, int ); 
void dump_tevents_raw ( FILE *, TEVENT * );
void dump_tevents ( FILE *, TEVENT * );
void dump_timer_generation ( FILE *, TIMER *, int );
void display_sys_calendar ( void );
void calendar_today ( CALEND * );
void advance_calendar ( CALEND *, int );
void save_timer_config ( TIMER * );
void save_tevent_config ( TEVENT * );
void save_state ( TIMER *, TEVENT * );
void restore_timer_config ( TIMER * );
void restore_tevent_config ( TEVENT * );
void restore_state ( TIMER *, TEVENT * );
void increment_tevent_generation ( TEVENT *, int );
void increment_timer_generation ( TIMER *, int );
void resolve_dates ( TEVENT **, CALEND *, int );
void security_adjust_legal_old ( TEVENT * );
void security_adjust_legal ( TEVENT **, MACRO **, unsigned char ** );
void split_timers ( TIMER *, TEVENT ** );
void associate_tevent_triggers ( TEVENT *, MACRO * );
void identify_macros_in_use ( MACRO *, TEVENT * );
void resolve_tevent_overlap ( TEVENT ** );
void create_memory_image_high ( unsigned char *, TIMER *, TRIGGER *, MACRO *, unsigned char * );
void create_memory_image_low ( unsigned char *, TIMER *, TRIGGER *, MACRO *, unsigned char * );
void store_record_info ( CALEND * );
void remove_record_file ( void );
void display_cm11a_status ( int );
void display_status_message ( int );
void get_configuration ( void );
void yday2date ( long, int, int *, int *, int *, int * );
void find_heyu_path ( void );
void combine_similar_tevents ( TEVENT **, MACRO **, unsigned char ** );
void compress_macros ( MACRO *, unsigned char * );
void fix_february ( int, int, int, int *, int * );
void display_syn( void );
long day_count ( int, int, int, int );
long int daycount2JD ( long int ); 
char *strtrim ( char * );
char *strlower ( char * );
char *strupper ( char * );
char *strncpy2 ( char *, char *, int );
char *get_token ( char *, char **, char *, int );
char code2hc ( unsigned char );
char *bmap2dow ( unsigned char );
char *bmap2units ( unsigned int );
char *bmap2asc ( unsigned int, char *);
char *bmap2rasc ( unsigned int, char *);
char *legal_time_string ( void );
char *pathspec ( char * );
char *unique_macro_name ( int *, int, MACRO *, char * ) ;
char flag_def ( unsigned int );
unsigned char unit2code ( int );
unsigned char dow2bmap ( char * );
unsigned char rev_low_nybble ( unsigned char ); 
unsigned char lrotbmap ( unsigned char );
unsigned char rrotbmap ( unsigned char );
unsigned char single_bmap_unit( unsigned int );
unsigned char checksum( unsigned char *, int );
unsigned int units2bmap ( char * );
unsigned int flags2bmap ( char * );
int lookup_scene ( SCENE *, char * );
void free_scenes ( SCENE ** );
void free_scripts ( SCRIPT ** );
void free_launchers ( LAUNCHER ** );
void free_aliases ( ALIAS ** );
int tokenize2 ( char *, char *, int *, char ** );
int tokenize ( char *, char *, int *, char *** );
int is_admin_cmd ( char * );
int is_direct_cmd ( char * );
int is_heyu_cmd ( char * );
int verify_scene ( char * );
int macro_command( int, char **, int *, int *, unsigned char * );
void clear_error_message( void );
void store_error_message ( char * );
void add_error_prefix ( char * );
void add_error_suffix ( char * );
char *error_message ( void );
unsigned char hc2code ( char );
int max_parms ( int, char ** );
int lookup_macro ( int, char *, int * );
char *alias_rev_lookup_mult ( char, unsigned int, int * );
char *alias_rev_lookup ( char, unsigned int );
int parse_units ( char *, unsigned int * );
void replace_dummy_parms ( int, char ***, char ** );
int image_chksum ( unsigned char * );
int macro_dupe ( MACRO **, int, unsigned char **, char * );
unsigned int parse_addr ( char *, char *, unsigned int * );
int add_scene ( SCENE **, char *, int, char *, unsigned int );
void get_std_timezone ( void );
int parse_config_tail ( char *, unsigned char );
void display_config_overrides ( FILE * );
int finalize_config ( void );
int environment_config( void );
void millisleep ( long );
void microsleep ( long );
void write_x10state_file ( void );
void x10state_update_sticky_addr ( unsigned char );
void x10state_update_addr ( unsigned char, int * );
void x10state_update_func ( unsigned char *, int * );
void x10state_update_ext3func ( unsigned char *, int * );
void x10state_update_ext0func ( unsigned char *, int * );
void x10state_update_extotherfunc ( unsigned char *, int * );
void x10state_update_virtual ( unsigned char *, int * );
void x10state_init_all ( void );
void x10state_init_others ( void );
void update_flags ( unsigned char * );
int  send_clear_statusflags ( unsigned char, unsigned int );
void clear_statusflags ( unsigned char, unsigned int );
void x10state_init ( unsigned char );
void x10state_show ( unsigned char );
void x10state_update_bitmap ( unsigned char, unsigned int );
int load_image ( int * );
int loadcheck_image ( int );
void display_trigger( char *, unsigned int, unsigned char );
int expand_macro( char *, unsigned int, int );
char *translate_sent ( unsigned char *, int, int * );
char *translate_virtual ( unsigned char *, int * );
void x10state_reset_all_triggers ( void );
void x10state_reset_all_modmasks ( void );
int parse_launch ( char * );
int launch_script ( int *);
void send_sptty_x10state_command ( int, unsigned char, unsigned char );
void send_x10state_command ( unsigned char, unsigned char );
void set_module_masks ( ALIAS * );
int lookup_module_type ( char * );
void finalize_launch ( void );
char *lookup_module_name ( int );
int absdims( int );
unsigned char level2dims( unsigned char, char **, char ** );
void show_hc_dimlevel ( unsigned char );
void show_all_dimlevels ( void );
int add_script( SCRIPT **, LAUNCHER **, int, char * );
int add_launchers ( LAUNCHER **, int, char * );
int send_address ( unsigned char, unsigned int, int );
int send_command ( unsigned char *, int, unsigned int, int );
int heyu_getopt( int, char **, struct opt_st * );
int alias_count ( void );
int launch_heyuhelper ( unsigned char, unsigned int, unsigned char );
void module_attributes ( int, unsigned long *, int * );
int add_module_options ( int, char **, int );
char *display_module_options ( int );
long int systime_now ( void );
long int dawndusk_today ( unsigned char );
int unlock_state_engine( void );
void free_all_arrays ( void );
int display_x10state_message( char * );
int c_cm10a_init( int, char ** );
int invalidate_for_cm10a ( void );
void wait_next_tick ( void );
void send_virtual_data ( unsigned char, unsigned char );

