/*
 * Changes for use with CM11A copyright 1996, 1997 Daniel B. Suthers,
 * Pleasanton Ca, 94588 USA
 * E-mail dbs@tanj.com
 */
/*
 * Copyright 1986 by Larry Campbell, 73 Concord Street, Maynard MA 01754 USA
 * (maynard!campbell).  You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 * John Chmielewski (tesla!jlc until 9/1/86, then rogue!jlc) assisted
 * by doing the System V port and adding some nice features.  Thanks!
 * 
 */

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#if defined(SYSV) || defined(FREEBSD) || defined(OPENBSD)
#include <string.h>
#else
#include <strings.h>
#endif
#include <time.h>
#include <signal.h>
#include "x10.h"
#include "version.h"
#include <syslog.h>
#include "process.h" 

#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <sys/types.h>
#endif

extern int tty;
extern int sptty;
extern char x10_tty[PATH_LEN + 1];
extern int usage();
extern int start_relay(),setup_sp_tty(), xread(), unit2int();
extern void error(), quit();
extern int lock_for_write();
extern int munlock();
extern CONFIG config;  /* CWS - Structure with all configuration data */

int x10_housecode;
int verbose;
int i_am_relay = 0;	/* flag to differentiate the relay process */
int port_locked = 0;	/* flag to show that the tty port is locked */
int i_am_monitor = 0;
int i_am_state = 0;
int heyu_parent = D_CMDLINE;  

FILE *fdsout;
FILE *fdserr;

void sigtimer(), err();
char hc2char();
void init();
int check4poll();

char
 syncmsg[SYNCN], flag;


char macroxref[PATH_LEN + 1];		/* path name to store macro cross reference */
char heyuprogname[PATH_LEN + 1 + 10];

struct opt_st options;
struct opt_st *optptr = &options;

struct hstruct			/* table to map housecodes into letters */
 housetab[] =
{
    {HC_A, 'a'},
    {HC_B, 'b'},
    {HC_C, 'c'},
    {HC_D, 'd'},
    {HC_E, 'e'},
    {HC_F, 'f'},
    {HC_G, 'g'},
    {HC_H, 'h'},
    {HC_I, 'i'},
    {HC_J, 'j'},
    {HC_K, 'k'},
    {HC_L, 'l'},
    {HC_M, 'm'},
    {HC_N, 'n'},
    {HC_O, 'o'},
    {HC_P, 'p'}
};

char *wdays[] =
{"Sunday", "Monday", "Tuesday", "Wednesday",
 "Thursday", "Friday", "Saturday", "<day not set>"};

/* Table for mapping units (1-16) or house codes (a-p) to 4 bit nibbles.
 * element 0 equates to unit 1 or code a
 */
unsigned char cm11map[]=
{  06, 016, 02, 012, 01, 011, 05, 015,
   07, 017, 03, 013, 0, 010, 04, 014
};

/* Table for mapping an x10 format bitmap to a unit number.  It's
 * the reverse of the one above.
 * Note that the unit numbers are 1-16, but the array is 0-15.
 */
unsigned char map2cm11[]=
{
    13, 5, 3, 11, 15, 7, 1, 9, 14, 6, 4, 12, 16, 8, 2, 10
};

int timeout = TIMEOUT, Irev, Iminutes, Iseconds, Ihours, Idays, Ijday;
int Istatdim, Istatmon, Iaddmon;
int newformat;  /* for the output format */
unsigned char Ihcode;

extern int
 c_data(), c_date(), c_delete(), c_diagnostic(), c_dump(), c_fdump(),
 c_finfo(), c_fload(), c_info(), c_monitor(), c_reset(), c_schedule(),
 c_setclock(), c_turn(), c_dbs(), c_stop(), c_erase(), c_preset(),
 c_upload(), c_utility(), c_setclockraw(), c_command(), is_heyu_cmd(),
 c_set_status(), c_show1(), c_show2(), c_x10state(), c_ping(), c_busywait(),
 c_catchup(), c_macro(), c_start_engine(), c_logmsg(), c_readclock(),
 c_flagstate(), c_cm10a_ident(), c_turn_rts_off(), c_turn_rts_on(),
 c_trigger(), c_status_state(), c_dummy(), c_powerfailtest(),
 c_show_modem_lines(), c_ri_disable(), c_ri_enable(), c_port_line_test();

extern unsigned char low_nybble_rev();
void init ( char * );
void create_alerts ( void );

extern int c_qerase(), c_list();

int c_help(), c_version();

struct cmdentry {
    char *cmd_name;
    int (*cmd_routine) ();
    int lock_needed;
} cmdtab[] = {
    {"___", c_command,1},
    {"date", c_date,1} ,
    {"erase", c_erase,1},
    {"_help", c_help,0},
    {"info", c_info,1},
    {"list", c_list,0},
    {"monitor", c_monitor,0},
    {"_preset", c_preset,1},
    {"cmd", c_command,1},
    {"reset", c_reset,1},
    {"setclock", c_setclock,1},
    {"readclock", c_readclock,1},
    {"setclockraw", c_setclockraw, 1}, /* undocumented, see source - CWS */
    {"_status", c_turn,1},
    {"stop", c_stop,0},
    {"_turn", c_turn,1},
    {"upload", c_upload, 1},  /* (added by CWS) */
    {"utility", c_utility, 0}, /* (added by CWS) */
    {"newbattery", c_set_status, 1}, 
    {"purge", c_set_status, 1},
    {"clear", c_set_status, 1},
    {"reserved", c_set_status, 1}, /* undocumented, see source - CWS */
    {"version", c_version,0},
    {"_hail", c_turn,1},  /* hidden feature */
    {"qerase", c_qerase,1},  /* hidden feature */
    {"enginestate", c_x10state,1},
    {"initstate", c_x10state,1},
    {"initothers", c_x10state,1},
    {"fetchstate", c_x10state,1},
    {"onstate", c_x10state, 1},
    {"dimstate", c_x10state, 1},
    {"chgstate", c_x10state, 1},
    {"addrstate", c_x10state, 1},
    {"dimlevel", c_x10state, 1},
    {"rawlevel", c_x10state, 1},
    {"memlevel", c_x10state, 1},
    {"rawmemlevel", c_x10state, 1},
    {"statestr", c_x10state, 1},
    {"heyu_state", c_x10state, 1},
    {"heyu_rawstate", c_x10state, 1},
    {"xtend_state", c_x10state, 1},
    {"catchup", c_catchup, 1},
    {"macro", c_macro, 1},
    {"trigger", c_trigger, 1},
    {"ping", c_ping, 1},
    {"show", c_show2, 1},
    {"engine", c_start_engine, 1},
    {"logmsg", c_logmsg, 1},
    {"wait", c_busywait, 1},
    {"flagstate", c_flagstate, 1},
    {"statusstate", c_status_state, 1},
    {"cm10a_init", c_cm10a_init, 1},
    {"cm10a_ident", c_cm10a_ident, 1},
    {"turn_rts_off", c_turn_rts_off, 1},    
    {"turn_rts_on", c_turn_rts_on, 1},
    {"show_modem_lines", c_show_modem_lines, 1},
    {"dummy", c_dummy, 1},
    {"powerfailtest", c_powerfailtest, 1},
    {"ri_disable", c_ri_disable, 1},
    {"ri_enable", c_ri_enable, 1},
    {"port_line_test", c_port_line_test, 1},
    {"", NULL , 0}
};

char *argptr;

/*-------------------------------------------------------------------+
 |  Main                                                             |
 +-------------------------------------------------------------------*/
int main ( int argc, char *argv[] )
{
    register int i;
    int (*rtn) ();
    struct cmdentry *c;
    struct stat statb;
    char RCSID[]= "@(#) $Id: x10.c,v 1.26 1999/12/26 20:37:17 dbs Exp $\n";
    void read_config(), read_minimal_config();
    int retcode;
    int ntokens;
    int perms;
    char writefilename[PATH_LEN + 1];
    char *cptr;
    int start_engine_main();
    int check_for_engine();
	
    display(RCSID);


    strncpy2(heyuprogname, argv[0], sizeof(heyuprogname) - 10);

    /* Record if heyu was executed downstream of the heyu state engine or relay */
    heyu_parent = D_CMDLINE;
    if ( (cptr = getenv("HEYU_PARENT")) != NULL ) {
       if ( strcmp(cptr, "RELAY") == 0 ) {
          heyu_parent = D_RELAY;
          i_am_state = 0;
       }    
       else if ( strcmp(cptr, "ENGINE") == 0 ) {
          heyu_parent = D_ENGINE;
          i_am_state = 0;
       }
    }

    fdsout = stdout;
    fdserr = stderr;

    rtn = NULL;


    /* Check for and store options in options structure */
    /* Return number of tokens used for options, or -1  */
    /* if a usage error.                                */
    ntokens = heyu_getopt(argc, argv, optptr);

    if ( ntokens < 0 || (argc - ntokens) < 2 ) {
       fprintf(stderr, "Version:%4s\n", VERSION );
       fprintf(stderr, 
          "Usage: heyu [options] <command>  (Enter 'heyu help' for commands.)\n");
       return 1;
    }

    verbose = optptr->verbose;
    if( verbose )
	printf( "Version:%4s\n", VERSION );

    /* Remove the tokens used for options from the argument list */
    for ( i = 1; i < (argc - ntokens); i++ ) {
       argv[i] = argv[i + ntokens];
    }
    argc -= ntokens;

    if ( strcmp(argv[1], "list") == 0 ) {
       c_list();
       return 0;
    } 


    if ( strcmp(argv[1], "help") == 0 ||
         strcmp(argv[1], "syn") == 0    ) {
       c_command(argc, argv);
       return 0;
    }

    if ( strcmp(argv[1], "utility") == 0 ) {
          c_utility(argc, argv);
          return 0;
    }

    if ( strcmp(argv[1], "show") == 0 ) {
       retcode = c_show1(argc, argv);
       if ( retcode == 0 ) {
          free_all_arrays();
          return 0;
       }
    }

    /* Commands other than those handled above require */
    /* a configuration file and file locking.          */

    if ( strcmp(argv[1], "stop") == 0 )
       read_minimal_config ( SRC_STOP );
    else
       read_config();
  
    if ( is_heyu_cmd(argv[1]) ) {
         /* This is a direct command */
         c = cmdtab;
         rtn = c->cmd_routine;
    }
    else 
    {
        /* This is an administrative or legacy command */
        for (c = cmdtab + 1; c->cmd_routine != NULL; c++) {
	    if (strcmp(argv[1], c->cmd_name) == 0) {
	        rtn = c->cmd_routine;
	        break;
	    }
        }
    }


    if (rtn == NULL)
    {
       fprintf(stderr, 
          "Usage: heyu [options] <command>  (Enter 'heyu help' for commands.)\n");
       return 1;
    }

    if ( stat(SPOOLDIR, &statb) != 0 ) {
       perms = config.respool_perms;
#ifdef RESPOOL
       if ( mkdir(SPOOLDIR, perms) == 0 && chmod(SPOOLDIR, perms) == 0 && stat(SPOOLDIR, &statb) == 0 ) {
          fprintf(stderr, "Directory %s has been re-created with permissions %05o\n", SPOOLDIR, perms);
       }
       else {
          fprintf(stderr, "Unable to re-create missing directory %s with permissions %05o\n", SPOOLDIR, perms);
          exit(3);
       }
#else
       fprintf(stderr, "Please build the %s directory with permissions 1777\n", SPOOLDIR);
       exit(3);
#endif  /* End ifdef RESPOOL */
    }

    if(  (statb.st_mode & S_IRWXO) != S_IRWXO )
    {
    	fprintf( stderr, "Please change the %s directory's permissions to 1777\n", SPOOLDIR);
	exit(3);
    }

    if( ( strcmp("stop", c->cmd_name) == 0 ) || 
        (strcmp("version", c->cmd_name) == 0) ||
        (strcmp("help", c->cmd_name) == 0) )
    {
        retcode = (*rtn)();		/* exits */
        free_all_arrays();
	return retcode;
    }

    if (c->lock_needed == 1 )
    {
        if( lock_for_write() < 0 )
            error("Program exiting.\n");
	port_locked = 1;
    }

    argptr = argv[0];

    /* Setup alert command arrays */
    create_alerts();

    /* Future: A command line of 'relay' directs this copy to start the relay 
     * process.  If that's the case, don't check for relay.
     */
    if ( strcmp("relay", c->cmd_name) != 0 ) {
	start_relay(x10_tty);
	if( ! i_am_relay ) {
	    setup_sp_tty();
	}
    }


#ifdef MINIEXCH
    mxconnect(MINIXPORT);
#endif

    init(c->cmd_name);

    retcode = (*rtn) (argc, argv);
    if( port_locked == 1 ) {
        sprintf(writefilename, "%s%s", WRITEFILE, config.suffix);
        munlock(writefilename);
    } 
    free_all_arrays();
    return retcode;
}

/*-------------------------------------------------------------------+
 |  Init                                                             |
 +-------------------------------------------------------------------*/

void init ( char *cmd_name )
{

    timeout = TIMEOUT;
    if( strcmp(cmd_name, "monitor") == 0 )
    {
	check4poll(1, 2);
    }
    else if ( strcmp(cmd_name, "engine") == 0 )
        check4poll(0, 0);
    else if ( strcmp(cmd_name, "info") == 0 )
        check4poll(0, 0) ; 
    else
	check4poll(0, 0);

    /* Now check the status of the interface. */
    /* if( get_status() < 1)
        error("could not get the interface status");
    */
}


/*
 * Convert X10-style day of week (bit map, bit 0=monday, 6=sunday)
 * to UNIX localtime(3) style day of week (integer, 0=sunday)
 */
/* DBS  NOTE:  This is valid for CP290, not for CM11A.
 * The CM11A uses unix style.
 */


int dowX2U(b)
register char b;
{
    register int n;

    for (n = 1; (!(b & 1)) && n < 8; n++, b = b >> 1)
    	;
    if (n == 7)
	n = 0;
    if (n == 8)
	n = 7;
    return (n);
}

int dowU2X(d)
int d;
{
    if (d == 0)
	d = 7;
    return (1 << (d - 1));
}


char hc2char(code)
unsigned code;
{
    register int i;

    for (i = 0; i < 16; i++)
	if (housetab[i].h_code == code)
	    return i + 'a';
    return ('?');
}

int char2hc(hletter)
int hletter;
{
    if (isupper(hletter))
	hletter = tolower(hletter);
    if (! ('a' <= hletter && hletter <= 'p') ) 
	error("invalid house code");

    return (housetab[hletter - 'a'].h_code);

}

/*
 * Parse string of comma-separated unit numbers and return bitmap
 * (big-endian) of units specified.  '*' means "all units".
 */

unsigned int  getunits(p)
register char *p;
{

#define DIGBUFN 80		/* maximum line length */

    unsigned int bitmsk, n, unit, lastunit, range;
    char digbuf[DIGBUFN];

    bitmsk = 0;
    lastunit = 0;
    range = 0;
    while (*p) {
	if (*p == '*') {
	    bitmsk = 0xFFFF;
	    break;
	}
	for (n = 0; n < DIGBUFN && isdigit((int)*p); n++, p++)
	    digbuf[n] = *p;
	digbuf[n] = '\0';
	if ((unit = atoi(digbuf)) < 1 || unit > 16)
	    error("bad unit code, must be between 1 and 16");

	bitmsk |= (0x01 << (unit-1)) ;
	if( range == 1)
	{
	    for( n = lastunit; n <= unit; n++)
		bitmsk |= (0x01 << (n-1)) ;
	}

	if (*p)
	{
	    if (*p == '-')
	    {
		lastunit = unit;
		range = 1;
		p++;
	    }
	    else
	    {
		if (*p == ',')
		{
		    lastunit = 0;
		    range=0;
		    p++;
		}
		else
		{
		    error("bad unit separator, use comma or dash please");
		}
	    }
	}
    }
    return (bitmsk);
}

int dimstate(p, level)
register char *p, *level;
{
    unsigned levelnum;
    unsigned dim;

    dim = (unsigned)(-1);
    if (strcmp(p, "alloff") == 0)
	return (0);
    if (strcmp(p, "lightson") == 0)
	return (1);
    if (strcmp(p, "on") == 0)
	return (2);
    if (strcmp(p, "off") == 0)
	return (3);
    if (strcmp(p, "down") == 0 || strcmp(p, "dim") == 0)
	dim = 4;
    if (strcmp(p, "up") == 0 || strcmp(p, "bright") == 0 )
	dim = 5;
    if (strcmp(p, "lightsoff") == 0)
	return(6);
    if (dim == (unsigned)(-1) )
	error("bad state keyword");
    if (sscanf(level, "%u", &levelnum) == 0)
	error("dim value must be numeric");
    if (levelnum > 23)
	error("dim value out of range, must be between 0 and 23");
    timeout = DTIMEOUT;
    return ((levelnum << 3) | dim);
}

struct nstruct dtab[] =
{
    {"monday", 0x01},
    {"tuesday", 0x02},
    {"wednesday", 0x04},
    {"thursday", 0x08},
    {"friday", 0x10},
    {"saturday", 0x20},
    {"sunday", 0x40},
    {"everyday", 0x7f},
    {"weekdays", 0x1f},
    {"weekends", 0x60},
    {"", 0x00 }
};

int day2bits(p)
char *p;
{
    int n, mask, length;

    if (strcasecmp(p,"Today") == 0)
    	return (Idays);
    length = strlen(p);
    mask = 0;
    for (n = 0; dtab[n].n_name[0] != 0; n++) {
	if (strncasecmp(dtab[n].n_name, p, length) == 0) {
	    if (mask != 0)
		error("ambiguous day abbreviation");
	    mask = dtab[n].n_code;
	}
    }
    if (mask == 0)
	error("bad day keyword");
    return (mask);
}

#define MODULES 255
#define UNIT_LEN 50

struct x10_mod {
	char name[NAME_LEN+1];
	char hc;
	char un[UNIT_LEN];
} x10_modules[MODULES];


void read_config( void ) 
{  
    ALIAS  *aliasp;
    int    j;


   /* Read the user's Heyu configuration file and store in */
   /* global CONFIG structure 'config'.  Transfer some of  */
   /* the data into existing variables.                    */
  
   get_configuration();

   aliasp = config.aliasp;

   (void) strncpy2(x10_tty, config.tty, sizeof(x10_tty) - 1);
   x10_housecode = char2hc(config.housecode);
   newformat = config.newformat;

   j = 0;
   while ( aliasp && *(aliasp[j].label) && j < MODULES - 1  ) {
      x10_modules[j].hc = tolower(aliasp[j].housecode);
      (void) strncpy2(x10_modules[j].un, bmap2units(aliasp[j].unitbmap), UNIT_LEN - 1);
      (void) strncpy2(x10_modules[j].name, aliasp[j].label, NAME_LEN);
      j++;
   }
   x10_modules[j].hc = tolower(code2hc(config.housecode));
   (void) strncpy2(x10_modules[j].un, "*", UNIT_LEN - 1);
   (void) strncpy2(x10_modules[j].name, "all", NAME_LEN);

   (void) strncpy2(macroxref, pathspec(MACROXREF_FILE), sizeof(macroxref) - 1);  
    
   return;
}


struct x10_mod *
xmod_lookup(name)
char *name;
{
	int i = 0;
	struct x10_mod *xm;

	xm = x10_modules;
	while (i < MODULES) {
		if (!xm->name[0])
			break;
		if (strcmp(name, xm->name) == 0)
			return xm;
		i++;
		xm++;
	}
	if (!i) {
		err("no config at all", NULL);
	}
	return NULL;
}


void parse_unit(name,hcp,unitp)
char *name;
int *hcp;
char **unitp;
{
    struct x10_mod *x;
    int hletter;

    if (isalpha((int)name[0]) && (isdigit((int)name[1]) || name[1] == '*')) {
	hletter = name[0];
	if (isupper(hletter))
	    hletter = tolower(hletter);
	*unitp = &name[1];
    } else {
	x = xmod_lookup(name);
	if (!x) {
		err("bad alias %s",name);
		quit();
	}
	hletter = x->hc;
	*unitp = x->un;
    }
    *hcp = char2hc(hletter);

}


void err(m,s)
char *m, *s;
{
	fprintf(stderr, "HEYU: ");
	fprintf(stderr, m, s);
	fprintf(stderr, "\n");
}

/* Takes the bits in CM11A format (as used in the reply to a status) 
 * and returns a day string.
 * The b parameter is for bitmap */
char *bits2day(b)
int b;
{
   
   switch(b)
   {
       case 1:
	   return("Sun");
       case 2:
	   return("Mon");
       case 4:
	   return("Tue");
       case 8:
	   return("Wed");
       case 16:
	   return("Thu");
       case 32:
	   return("Fri");
       case 64:
	   return("Sat");
    }
    return("Error");
}

int c_version()
{
    printf( "Version:%4s\n", VERSION );
    return(0);
}

int c_help()
{
    usage(NULL);
    return(0);
}

void display(RCCS)
char *RCCS;
{

    /* This is not used much so far */
    if( verbose > 1)
        printf( "%s\n", RCCS);
}

/* take the simple bitmap produced by getunits() and turn it into the
 * cm11 style, where bit 0 represents unit 13, bit 1 represents unit 5, etc
 */
unsigned int cm11bitmap(bits)
unsigned int bits;
{
    unsigned int cm11bits;
    int x;

    cm11bits=0;
    for(x=0; x < 16; x++)
    {
        if( ( bits & (1 << x ) ) != 0 )
            cm11bits |= (1 << (cm11map[x]) );
    }


return(cm11bits);
}

/* List the variables as built into the program at compile time */
int c_list()
{
    	if( verbose )
    	{
            printf( "Version:%4s\n", VERSION );
	    printf( "The SPOOLDIR is %s\n", SPOOLDIR);
	    printf( "The LOCKDIR is %s\n", LOCKDIR);
            printf( "The SYSBASEDIR is %s\n", SYSBASEDIR);
	}
	else
	{
	    printf( "Version=%s\n", VERSION );
	    printf( "SPOOLDIR=%s\n", SPOOLDIR);
	    printf( "LOCKDIR=%s\n", LOCKDIR);
            printf( "SYSBASEDIR=%s\n", SYSBASEDIR);
	}

return(0);
}

/* Dummy command for debugging does nothing */
int c_dummy( int argc, char *argv[] )
{
   return 0;
}


