//
// hfstools - a Macintosh filesystem access tool
// (C) Copyright 1993 by Equivalence
//
// This file part of hfs.
//
// hfs is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// hfs is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with hfs; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
//
//
// $Id: config.h,v 1.7 1994/07/02 05:04:21 craigs Exp $
// $Log: config.h,v $
// Revision 1.7  1994/07/02  05:04:21  craigs
// Added support for CDROM drives under MSDOS
//
// Revision 1.6  1994/06/30  14:39:24  craigs
// Changes for bigger blocks and partitions
//
// Revision 1.5  1994/01/11  00:41:01  craigs
// Added STRNICMP macro to make strncasecmp portable
//
// Revision 1.4  1994/01/06  03:05:08  craigs
// Final checkin to include GNU header
//
// Revision 1.3  1993/12/23  15:16:00  craigs
// Changed default HFS device to a:
//
// Revision 1.2  1993/12/16  20:15:02  craigs
// Changed name of environment variable to match the name of
// the new executable
//
// Revision 1.1  1993/11/22  22:27:51  craigs
// Initial revision
//
//
//

//
// the following definitions are platform independent
//  DISK_DEVICE_ENV     name of env variable giving device identifier
//
//  PARTITION_ENV     name of env variable giving paritiion identifier
//
//  STATFILE_ENV    name of env variable giving status file
//
//  DEFAULT_DISK_DEVICE   either "a:" or "b:"
//

//
// the following definitions are platform dependent
//  STAT_FILE_NAME    name of file which keeps current HFS directory 
//        device. If MSDOS, this file will be in TEMP
//        directory, or in current directory, other wise
//        file goes in user's home directory
//
//  DRIVE_A_DEVICE    names of the two devices corresponding to
//  DRIVE_B_DEVICE    "A:" and "B:" drive
//
//  DIR_SEP         character used to separate path elements in
//        the host file system
//
//  STRNICMP    name of case insensitive string compare function
//

#ifndef _CONFIG_H
#define _CONFIG_H

/////////////////////////////////////////////////////////////
//
// the following definitions should be platform independent
//

//
// environment variable used to set different disk device and partitions
//
#define DISK_DEVICE_ENV   "HFS_DEVICE"
#define PARTITION_ENV   "HFS_PARTITION"
#define STATFILE_ENV    "HFS_STATUSFILE"

//
// default disk device if not set in Makefile
//
#ifndef DEFAULT_DISK_DEVICE
#define DEFAULT_DISK_DEVICE "a:"
#endif

/////////////////////////////////////////////////////////////
//
// Linux definitions
//

#if __linux__

#define DRIVE_A_DEVICE    "/dev/fd0H1440"
#define DRIVE_B_DEVICE    "/dev/fd1H1440"

#define _PACK_      __attribute__ ((packed))

#endif

/////////////////////////////////////////////////////////////
//
// FreeBSD definitions
//

#if __FreeBSD__

#define DRIVE_A_DEVICE    "/dev/rfd0.1440"
#define DRIVE_B_DEVICE    "/dev/rfd1.1440"

#endif

/////////////////////////////////////////////////////////////
//
// MSDOS/Windows NT definitions
//

#if defined(_MSDOS) || defined(WIN32)

#define STRNICMP strnicmp

#define DIR_SEP '\\'

// these are defined as empty as the code in volume.cxx handles the
// MSDOS and NT cases explicitly
#define DRIVE_A_DEVICE    
#define DRIVE_B_DEVICE  

#define STAT_FILE_NAME   "macdir.sts"

#if defined(_MSC_VER)
#pragma warning(disable:4201)  // nonstandard extension used
#pragma warning(disable:4505)  // unreferenced local functions
#pragma warning(disable:4514)  // unreferenced inlines
#endif

#endif

/////////////////////////////////////////////////////////////
//
// default definitions
//

#ifndef STAT_FILE_NAME
#define STAT_FILE_NAME   ".macdir"
#endif

#ifndef STRNICMP
#define STRNICMP    strncasecmp
#endif

#ifndef DIR_SEP
#define DIR_SEP     '/'
#endif

#ifndef DRIVE_A_DEVICE
#error  "Must define DRIVE_A_DEVICE"
#endif

#ifndef DRIVE_B_DEVICE
#error  "Must define DRIVE_B_DEVICE"
#endif

#endif
