################################################################
# english theme
# $Id: theme.ph,v 1.20.2.1 2001/05/10 11:36:23 kenji Exp $

################################################################
# User variable
#  parameter %value is expanded to value of the user variable.
#  you can use other value of user variable by noting as "%user{BASHO}".
package HNS::Hnf::UserVar;
$Templates{'TENKI'}  = "[%value]";
$Templates{'BASHO'}  = "(%value)";
$Templates{'TAION'}  = " Temperature:%value";
$Templates{'TAIJU'}  = " Weight:%value" . "Kg";
$Templates{'SUIMIN'} = " Hours Sleep:%value";
$Templates{'BGM'}    = " BGM:%value";
$Templates{'HOSU'}   = " %value" . " steps";
$Templates{'HON'}    = " Book:%value";
$Templates{'KITAKU'} = " Homecoming:%value";
$Templates{'WALK'}   = " Walking:%value";
$Templates{'RUN'}    = " Running:%value";

################################################################
# Mark
package HNS::Hnf::Command::MARK;
# image size is automatically set
$List{"(^^)"}    = "icons/usaniko.png";
$List{"(-_-)"}   = "icons/usamesen.png";
$List{"(^^;"}    = "icons/usaase.png";
$List{"(;_;)"}   = "icons/usauru.png";
$List{"(T_T)"}   = "icons/usauru2.png";
$List{"v(^^)"}   = "icons/usav.png";
$List{"m(__)m"}  = "icons/usapeko.png";
$List{"!!"}      = "icons/usadoki.png";
$List{"??"}      = "icons/usahatena.png";
$List{"!?"}      = "icons/usanaze.png";
$List{":-)"}     = "icons/usasmile2.png";
$List{":-("}     = "icons/usaheno2.png";
$List{":-P"}     = "icons/usabe2.png";

################################################################
# Language
package HNS::System;
$Lang = "en";

################################################################
# CategoryList
package HNS::CategoryList;
$CatDir = "cat";

$TitleLabel = "Title List";
$SubmitLabel = "Show!";
$Template = qq(<img src="%src" width="%width" height="%height" alt="">%value<br>\n);
$Categorize = "Categorize";

################################################################
# Extend HTML
package HNS::ExtHTML;
$DOCTYPE = qq(<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
	"http://www.w3.org/TR/REC-html40/loose.dtd">\n);
#$Head = undef;
$Head = qq(<meta http-equiv="Content-Style-Type" content="text/css">
<style type="text/css"><!--
 body { background: white }
 h3.new { margin-left: 1em }
 div.uservar { font-weight: bold; }
 div.section { margin-left: 2em; margin-top: 0 }
 div.sub { margin-left: 1em; margin-top: 0 }
 div.list { margin-left: 1em }
 div.fn { margin-left: 1em; margin-top: 0 }
 div.url { margin-bottom: 0 }
 pre { 
  white-space:  pre;
  padding:      0.5em;
  border-color: #ffeeb0;
  border-style: outset;
  border-width: 4px
 }
 a.hide:link { color: black; text-decoration: none }
 span.bold-red { color: red; font-weight: bold }
 div.bold-red { color: red; font-weight: bold }
--></style>
);

#$BodyVal = undef;
##$BodyVal = "bgcolor=#ffffcc";
#$DynamicPrintFunc = undef;
##$DynamicPrintFunc = \&PrintTime;
##sub PrintTime
##{
##    print qq(<div align="center">time is);
##    print join(':', reverse ((localtime)[0..2]));
##    print qq(</div>);
##}
################################################################
package HNS::Collection;
# %num : number of showing diarys
$FootMessages{'HasContent'} = "Diary for %num day(s).\n";
$FootMessages{'NoContent'} = "No match.\n";


################################################################
# PIM
# Schedule
package HNS::PIM::Schedule;
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu',
        'Fri', '<font color="blue">Sat</font>');
@ABCString = ('low', 'mid', 'high');
$Unfixed = '??';
$ContentTemplate = qq(<li><strong>%month/%day%week</strong> %content</li>\n);
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

# TODO
package HNS::PIM::Todo;
$ContentTemplate = "<li><strong>%priority</strong> %content</li>\n";
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

################################################################
# Calendar
package HNS::Calendar::Table;
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu',
        'Fri', '<font color="blue">Sat</font>');
$TableBorder = 0;
$NextTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">Next</a>);
$PrevTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">Prev</a>);
$ThisTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate =
        qq(<a href="$HNS::System::MyDiaryURI?%year%month%abc#%{ymd}0">%day</a>);

package HNS::Calendar::NoTable;
$NextTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">&gt;&gt;</a>);
$PrevTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">&lt;&lt;</a>);
$ThisTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate =
        qq(<a href="$HNS::System::MyDiaryURI?%year%month%abc#%{ymd}0">%day</a>);

################################################################
# DateSelect
package HNS::DateSelect;
$YearTemplate = "%year/";
$MonthTemplate = "%month/";
$DayTemplate = "%start_day - %end_day";
$AllLabel = "All";

################################################################
# Direct Ctalendar
package HNS::Calendar::Direct;
$SubmitLabel = "Go!";

################################################################
# Style
package HNS::Style;
$Templates{Table}->{pim} = qq(
<hr>
<table summary="pim" width="100%">
<tr>
 <th align="left">Schedule</th>
 <th align="left">TODO</th>
 <th align="left">Link</th>
</tr>
<tr>
 <td valign="top">
 %schedule
 </td>
 <td valign="top">
 %todo
 </td>
 <td valign="top">
 %link
 </td>
</tr>
</table>
);

$Templates{Table}->{head_style} = qq( 
%pim
<hr>
<table summary="calendar">
<tr>
<td rowspan="2" valign="top">
%calendar
</td>
<td valign="top">
%unagi
</td>
</tr>
<tr>
<td valign="bottom">
%direct_calendar
</td>
</tr>
</table>
<hr>
);

$Templates{Table}->{foot_style} = "\n<hr>\n%category_list";

$Templates{Table}->{head_recent_style} = $Templates{Table}->{head_style};
$Templates{Table}->{foot_recent_style} = $Templates{Table}->{foot_style};

# template for no table browser
$Templates{NoTable} = {
    pim => qq(<hr>\n%schedule %todo %link),
    head_style => qq(%pim\n<hr>\n%unagi\n<hr>\n%calendar
		      %direct_calendar\n<hr>\n),
    foot_style=> "<hr>\n%category_list"
    };

$Templates{NoTable}->{head_recent_style} = $Templates{NoTable}->{head_style};
$Templates{NoTable}->{foot_recent_style} = $Templates{NoTable}->{foot_style};

# unagi template
$UnagiTemplate = qq( 
<a href="%namazu_url">Namazu</a> for hns, Search Engine<br>
for detail see <a href="%unagi_url">help</a>
<form method="GET" action="%unagi_url">
<strong>keyword:</strong>
<input type="TEXT" name="key" size="30" value="">
<input type="SUBMIT" name="submit" value="Search!">
<input type="HIDDEN" name="whence" value="0">
</form>
);

$NoUnagiTemplate = qq(
<a href="http://www.h14m.org/"><img src="./icons/hns-logo.png" width="200" height="40" align="right" alt="HNS logo"></a>
);



################################################################
# Warning
package HNS::Hnf::Warning;
$Head = "<br><font color=\"red\">\[- Warning:";
$Foot = "-\]</font><br>\n";

# parameters:
#  %c : the command name
#  %p : command name of inserted position
#
$Messages{'IllegalHeader'} = "illegal header.";
$Messages{'UndefinedUserVar'} = "undefined user var %c";
$Messages{'Reserved'} = "command '%c' is reserved. ";
$Messages{'NotDefined'} = "term '%t' is not defined in %c definition file.";
$Messages{'NoMatch'} =
    "command '%c' is not allowed in command '%p'. command '%c' is missing ?";

################################################################
# Version Message
# paramter:
#  %homepage
#  %public_version
#  %current_version

package HNS;
$VersionMessages{'Public'} = q(<hr>
<div>hns - Hyper NIKKI System - Version %public</div>);

$VersionMessages{'NonPublic'} = qq(<hr>
<div>
<font color="red">Caution: </font>
current version is %current,
public released version is %public.
</div>
);

################################################################
# Template
# usable parameter (%[A-Za-z0-9_]) is:
#  date:
#   %year, %month, %day	: year, month, day
#   %high		: int(day/10)
#   %abc		: day 1-10 -> a, 11-20 -> b, 21-31 -> c
#  counter:
#   %new, %sub, %fn	: counter of NEW, SUB, FN
#   %mark		: for GRP mark, if not in GRP the same as %new

package HNS::Diary;
################
# diary limited parameter:
#   %week		: week string
#
#  user-variable
#   %user{VARNAME}	: string as which user-var-format is expanded using
#			  value of user-variable VARNAME.
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu',
        'Fri', '<font color="blue">Sat</font>');

$Head = qq(
<h2><a class="hide" href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%{day}0#%year%month%{day}0"
name="%year%month%{day}0">%year/%month/%day(%week)</a>
[<a href="$HNS::System::MyDiaryURI?%month%day">n year diary</a>]</h2>
);

$UserVar = qq(<div class="uservar">
 %user{TENKI}%user{BASHO}%user{TAIJU}%user{TAION}%user{SUIMIN}%user{BGM}
 %user{HOSU}%user{HON}%user{KITAKU}
</div>);

$Foot = qq(<hr>\n);

package HNS::Hnf::Command::CAT;
$Template = qq([<a href="./title.cgi?CAT=%enc_var">%var</a>]);
$ImgTemplate = qq(<a href="./title.cgi?CAT=%enc_var">%img</a>);

package HNS::Hnf::Command::NEW;
$Template = qq(
<h3 class="new"><a class="hide" name="%year%month%day%new" title="%year%month%day%new" 
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%new#%year%month%day%new">#%mark</a>
%cat %content</h3>
<div class="section">\n);
$EndTemplate = "</div><!-- end of NEW -->\n";

package HNS::Hnf::Command::LNEW;
$Template = qq(
<h3 class="new"><a class="hide" name="%year%month%day%new" title="%year%month%day%new" 
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%new#%year%month%day%new">#%mark</a>
%cat <a href="%1">%content</a></h3>
<div class="section">\n);
$EndTemplate = "</div><!-- end of LNEW -->\n";

package HNS::Hnf::Command::RLNEW;
$Template = qq(
<h3 class="new"><a class="hide" name="%year%month%day%new" title="%year%month%day%new" 
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%new#%year%month%day%new">#%mark</a>
%cat <a href="%url%2">%content</a></h3>
<div class="section">\n);
$EndTemplate = "</div><!-- end of RLNEW -->\n";

package HNS::Hnf::Command::SUB;
$Template = qq(
<h4><a class="hide" name="%year%month%day%{new}S%sub" title="%year%month%day%{new}S%sub"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub"></a>
%content:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of SUB -->\n";

package HNS::Hnf::Command::LSUB;
$Template = qq(
<h4><a class="hide" name="%year%month%day%{new}S%sub" title="%year%month%day%{new}S%sub"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub"></a>
<a href="%1">%content</a>:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of LSUB -->\n";
$NumAttr = 1;

package HNS::Hnf::Command::RLSUB;
$Template = qq(
<h4><a class="hide" name="%year%month%day%{new}S%sub" title="%year%month%day%{new}S%sub"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub"></a>
<a href="%url%2">%content</a>:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of RLSUB -->\n";
$NumAttr = 2;

################################################################
# Inline Elements
# these element has no content commands,
# so $EndTemplate, $AllowCommands has no means.

package HNS::Hnf::Command::LINK;
$Template = qq(<a href="%1">%content</a>\n);
$NumAttr = 1;

package HNS::Hnf::Command::RLINK;
$Template = qq(<a href="%url%2">%content</a>\n);
$NumAttr = 2;
# overriden AsHTML

package HNS::Hnf::Command::URL;
$Template = qq(<div class="url">
<img alt="*" src="./icons/mark01.png" width="16" height="16">
<a href="%1">%content (%1)</a>
</div>\n);
$NumAttr = 1;

package HNS::Hnf::Command::STRIKE;
$Template = qq(<strike>%content</strike>\n);

package HNS::Hnf::Command::LSTRIKE;
$Template = qq(<strike><a href="%1">%content</a></strike>\n);
$NumAttr = 1;

package HNS::Hnf::Command::STRONG;
$Template = qq(<strong>%content</strong>\n);

package HNS::Hnf::Command::FONT;
$Template = qq(<font %1="%2">%content</font>\n);
$NumAttr = 2;

package HNS::Hnf::Command::IMG;
$Template = 
    qq(<img %align src="%2" alt="%content" width="%width" height="%height">\n);
$NumAttr = 2;
# overriden AsHTML

package HNS::Hnf::Command::MARK;
$Template = qq(<img src="%src" alt="%1" width="%width" height="%height">\n);
$NumAttr = 1;
# overriden AsHTML

package HNS::Hnf::Command::ALIAS;
$Template = "%term";
# overriden AsHTML

################################################################
# Block Commands
package HNS::Hnf::Command::PRE;
$Template = "<pre>\n";
$EndTemplate = "</pre>\n";

package HNS::Hnf::Command::CITE;
$Template = "<blockquote>\n";
$EndTemplate = "</blockquote>\n";

package HNS::Hnf::Command::UL;
$Template = "<ul>\n";
$EndTemplate = qq(</ul>\n);

package HNS::Hnf::Command::OL;
$Template = "<ol>\n";
$EndTemplate = qq(</ol>\n);

package HNS::Hnf::Command::LI;
$Template = q(<li>%content );
$EndTemplate = "</li>\n";

package HNS::Hnf::Command::HR;
$Template = q(<hr>\n);

package HNS::Hnf::Command::FN;
$Template = 
    qq(<a href="$ENV{'REQUEST_URI'}#%year%month%day%{new}F%fn"><small>*%fn</small></a>\n);

$HeaderTemplate = qq(<hr class="section" width="40%" align="left">
<div class="fn">\n);
$FooterTemplate = qq(</div>\n);

$ContentTemplate = qq(
<a class="hide" name="%year%month%day%{new}F%fn"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}F%fn#%year%month%day%{new}F%fn"><small>*%fn</small></a>: %content<br>
);
################################################################
1;
