
extern "C" {
	#include <stdlib.h>
}

#include "set_error.h"

#pragma implementation

#include "Bstream.h"

#ifndef OBSOLETE_LIBGXX
BOstream::BOstream ( ostream & orig ) : ostream(orig.rdbuf()) {
	ostream::setf(ios::scientific);
	ostream::precision(190);
}
#endif

void BOstream::ewrite(const void * p, int size) {
	write ((const unsigned char *)p, size);
	if (ostream::fail()) {
		set_error("BOstream::operator<< ","write-error");
	}
}

// ==============================================================
// BIstream 
// ==============================================================

#ifndef OBSOLETE_LIBGXX
BIstream::BIstream( istream & orig ) : istream(orig.rdbuf()) {

}
#endif

void BIstream::eread(void * p, int size) {
	read ((unsigned char *)p, size);
	if (istream::fail()) {
		set_error("BIstream::operator>> ","read-error");
	}
}

