
#ifndef Bstream_h
#define Bstream_h

#include <iostream.h>

#ifdef OBSOLETE_LIBGXX
	#include <fstream.h>
#endif 


#ifndef OBSOLETE_LIBGXX
class BOstream : public ostream {
#else
class BOstream : public ofstream {
#endif

protected:

	void ewrite(const void * p, int size);

public:

#ifndef OBSOLETE_LIBGXX
	BOstream( ostream & orig );
#endif

	BOstream & operator<< (int n)                { ewrite(&n, sizeof(n)); return *this; }
	BOstream & operator<< (long n)               { ewrite(&n, sizeof(n)); return *this; }
	BOstream & operator<< (unsigned long n)      { ewrite(&n, sizeof(n)); return *this; }
	BOstream & operator<< (unsigned long long n) { ewrite(&n, sizeof(n)); return *this; }
	BOstream & operator<< (double n)             { ewrite(&n, sizeof(n)); return *this; }
	BOstream & operator<< (bool n)               { ewrite(&n, sizeof(n)); return *this; }
	BOstream & operator<< (const void * n)       { ewrite(&n, sizeof(n)); return *this; }
	
	int mem_dump(const void * p, int size) {
		write ((const unsigned char *)p, size);
		return fail();
	}
};

#ifndef OBSOLETE_LIBGXX
class BIstream : public istream {
#else
class BIstream : public ifstream {
#endif

protected:

	void eread(void * p, int size);

public:
	
#ifndef OBSOLETE_LIBGXX
	BIstream( istream & orig );
#endif

	BIstream & operator>> (int & n)                { eread(&n, sizeof(n)); return *this; }
	BIstream & operator>> (long & n)               { eread(&n, sizeof(n)); return *this; }
	BIstream & operator>> (unsigned long & n)      { eread(&n, sizeof(n)); return *this; }
	BIstream & operator>> (unsigned long long & n) { eread(&n, sizeof(n)); return *this; }
	BIstream & operator>> (double & n)             { eread(&n, sizeof(n)); return *this; }
	BIstream & operator>> (bool & n)               { eread(&n, sizeof(n)); return *this; }
	BIstream & operator>> (void * & n)             { eread(&n, sizeof(n)); return *this; }

	int mem_undump(void * p, int size) {
		read ((unsigned char *)p, size);
		return fail();
	}
};



#endif Bstream_h

