/* $Id: lcd.h,v 1.1.1.2 1995/07/11 22:16:41 alex Exp $
 * LCD display control library for HP48.
 * Copyright (C) 1995 Eddie C. Dost
 *
 * This file is part of the HP48 C Library.
 *
 * The HP48 C Library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * The HP48 C Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hp48xgcc; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _SYS_LCD_H
#define _SYS_LCD_H

#include <hp48/fb.h>

/*
 * Some useful constants
 */
#define	LCD_WIDTH	FB_WIDTH
#define LCD_HEIGHT	FB_HEIGHT

/*
 * Initialization, must be called before any other function.
 * Will be done automatically in future versions.
 */
void	initscr (void);

/*
 * exitscr() should be called at program exit, or you won't see much.
 * This will be done by the library, once we have atexit(3). atexit(3)
 * will be there, once we have malloc(3).
 */
void	exitscr (void);

/*
 * Clear Screen
 */
void	clrscr (void);

/*
 * Set Pixel
 */
void	setpixel (eint x, eint y);

/*
 * Clear Pixel
 */
void	clrpixel (eint x, eint y);

#endif


