
;
; ASM implementation of push()
;  This should be part of the HP48 C library in the next release.
;  Copyright (C) 1996 Alex T. Ramos
;
; Usage:
;  Declare it in C code as: extern void push(hp_object *foo);
;  Pointer argument must have been allocated with sys_malloc()

_push
	exg.a	d1,c
	move.a	c,r0		; save the C frame pointer
	move.a	b,c
	move.a	c,r2		; save function argument 1
	jsr	restore_regs	; ctx-switch to native HP environment

	move.a	r2,c		; get the arg1
	sub.a	#5,d1		; make room in stack
	dec.a	d		; update memory accounting
	move.a	c,(d1)		; put object in HP user stack level 1

	jsr	save_regs	; save the HP environment

	move.a	r0,c
	exg.a	c,d1		; restore frame pointer

	rtn

