
/*
 * Reverse a string on the HP48 data stack.
 * Copyright (C) 1994 Alex T Ramos. All rights reserved. No warranty.
 * 
 */

#include <hp48/main.h>

#define SWAP(A,B,T) {(T)=(A);(A)=(B);(B)=(T);}

void	reverse (char *p, char *q)
{
    while (q>p) {
    	char c;
	SWAP(*p,*q,c);
	++p; --q;
    }
}

int main(int argc, char *argv[])
{
    hp_object *top = _STACK(0);
    reverse (OBJ_BODY (top), OBJ_BODY(top) + OBJ_LENGTH (top) - 1);
    return 0;
}

