/* Copyright (C) 1988 Free Software Foundation
     written by Doug Lea (dl@rocky.oswego.edu)
     adapted to HP48 by Eddie C. Dost

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _VALUES_H
#define _VALUES_H 1

#define BITSPERBYTE  8
#define __BITS(type) (BITSPERBYTE * (int)sizeof(type))

#define CHARBITS     __BITS(char)
#define SHORTBITS    __BITS(short)
#define INTBITS	     __BITS(int)
#define LONGBITS     __BITS(long)
#define PTRBITS	     __BITS(char *)
#define FLOATBITS    __BITS(float)
#define DOUBLEBITS   __BITS(double)

#define MINSHORT     ((short)(1 << (SHORTBITS - 1)))
#define MININT	     (1 << (INTBITS - 1))
#define MINLONG	     (1L << (LONGBITS - 1))

#define MAXSHORT     ((short)~MINSHORT)
#define MAXINT	     (~MININT)
#define MAXLONG	     (~MINLONG)

#define HIBITS	     MINSHORT
#define HIBITL	     MINLONG

#define MINDOUBLE    1.00000000000000e-49999
#define MAXDOUBLE    9.99999999999999e+49999
 
#define MINFLOAT     ((float)1.00000000000e-499)
#define MAXFLOAT     ((float)9.99999999999e+499)

#define _IEEE	     0
#define _DEXPLEN     12
#define _FEXPLEN     12
#define _HIDDENBIT   0
#define DMINEXP      (-DMAXEXP)
#define DMAXEXP      499
#define FMINEXP      (-FMINEXP)
#define FMAXEXP      499
 
#define DSIGNIF      39
#define FSIGNIF      39
#define DMAXPOWTWO   ((double)(1L << LONGBITS -2)*(1L << DSIGNIF - LONGBITS +1))
#define FMAXPOWTWO   ((float)(1L << FSIGNIF - 1))

#endif /* !_VALUES_H */
