
/*
 *  Symbolic names for some addresses in the HP48 ROM.
 *  List compiled by Alex Ramos, extended by Eddie Dost.
 */

#ifdef C_STYLE_HEX
#define HEX(n) 0x##n
#else
#define HEX(n) $##n
#endif

#define PUSHhxsLoop	HEX(0596d)	/* push A.P onto stack; goto RPL */
#define DOCOL		HEX(02d9d)	/* begin composite object ("::") */
#define DOHSTR		HEX(02a4e)	/* PROLOG of hex string */
#define DOCSTR		HEX(02a2c)	/* PROLOG of ascii string */
#define DOBINT		HEX(02911)	/* PROLOG of binary int */
#define DOCODE		HEX(02dcc)	/* PROLOG of code object */
#define SEMI		HEX(0312b)	/* end composite object (";") */
#define CK1NOLASTWD	HEX(18ab2)
#define CKandDISPATCH1	HEX(18fb2)
#define save_regs	HEX(0679b)
#define restore_regs    HEX(067d2)
#define d0_row1		HEX(01C31)	/* A=D0=<address of LCD display> */
#define d0_sft1		HEX(01C58)	/* A=D0=<address of Menu Area>   */
#define INITDISP	HEX(01C7F)
#define LINECOUNTg	HEX(069A)	/* Incomplete, prepend BASENIB   */
#define setmemerr	HEX(04FBB)	/* kaboom! out of memory (friendly) */
#define Errjmp		HEX(05023)	/* this didn't seem to work too well */

/*
 * Floating point functions:
 */
#define SPLITA		HEX(2BC4A)
#define SPLITAC		HEX(2BCA0)

#define POTF		HEX(2AAC0)

#define LN1PF		HEX(2B68F)
#define LNF		HEX(2B698)
#define LOGF		HEX(2B6A1)
#define EXPF		HEX(2B6AA)
#define EXPM1F		HEX(2B6B3)

#define ANGLEF		HEX(2B6D7)
#define SINF		HEX(2B6E0)
#define COSF		HEX(2B6E9)
#define TANF		HEX(2B6F2)
#define ATANF		HEX(2B6FB)
#define ASINF		HEX(2B704)
#define ACOSF		HEX(2B70D)
#define HYPF		HEX(2B731)
#define TANHF		HEX(2B73A)
#define ASINHF		HEX(2B743)
#define ACOSHF		HEX(2B74C)
#define ATANHF		HEX(2B755)

#define CEILF		HEX(2B75E)
#define FLOORF		HEX(2B767)

#define ADDF		HEX(2B7DC)
#define MULTF		HEX(2B91E)
#define DIVF		HEX(2B977)

#define SQRTF		HEX(2B9F3)

#define TST15		HEX(2BD76)

/*
 * Interger functions:
 */
#define HXSDIV		HEX(65807)

/*
 * Memory- and object- related
 */
#define CREATETEMP	HEX(06AD8)
#define MAKESTR		HEX(05B79)

