/* Copyright (C) 1995 Eddie C. Dost
This file is part of the HP48 C Library.

The HP48 C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License
as published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The HP48 C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Library General Public License for more details. */

#include <rom.h>

	xdef	_pop_real

_pop_real
	;
	; Pop real number from RPL data stack.
	;
	exg.a	c,d1
	move.a	c,r0		; save frame-pointer
	jsr	restore_regs

	move.a	(d1),c
	exg.a	c,d1
	add.a	#5,d1
	move.w	(d1),a

	move.a	c,d1
	add.a	#5,d1
	inc.a	d
	jsr	save_regs

	move.a	r0,c
	move.a	c,d1		; restore frame-pointer

	move.w	a,c
	rtn

	xdef _push

_push
	; Push the object pointed to by Arg1 into the user stack
	; Assume object was obtained via sys_malloc()!
        exg.a   d1,c
        move.a  c,r0            ; save the C frame pointer
        move.a  b,c
        move.a  c,r2            ; save function argument 1
        jsr     restore_regs    ; ctx-switch to native HP environment

        move.a  r2,c            ; get the arg1
        sub.a   #5,d1           ; make room in stack
        dec.a   d               ; update memory accounting
        move.a  c,(d1)          ; put object in HP user stack level 1

        jsr     save_regs       ; save the HP environment

        move.a  r0,c
        exg.a   c,d1            ; restore frame pointer

        rtn

	xdef	__hp_user_stack

__hp_user_stack
	; Return address of HP user stack (pointer to level 0 pointer)
	exg.a	d1,c
	move.a	c,r0		; save fp
	jsr	restore_regs	; ctx-switch. Now d1=stack
	move.a	r0,c
	exg.a	d1,c		; done! Nothing changed in HP env, no save.
	rtn	

