/* Copyright (C) 1994 Alex Ramos
This file is part of the HP48 C Library.

The HP48 C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License
as published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The HP48 C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Library General Public License for more details. */

#include <rom.h>

	xdef ___extendti
	xdef ___extendsidi2

	xdef ___divdi3
	xdef ___divti3
	xdef ___mulpdi3
	xdef ___muldi3
	xdef ___multi3

___extendti
	; Sign-extend "C.WP" to "A.W"
	clr.w	a
	move.wp	c,a	; a = c without high nibbles
	add.p	c,c
	move.p	a,c	; restore
	rtcc		; it's a positive number; we're done.
	not.w	a
	not.wp	a	; flip high bits
	move.1	#7,p
	rtn
	
___extendsidi2
	; Sign-extend "C.3" to "A.7"
	clr.wp	a
	move.1	#3,p
	move.wp	c,a	; a = c without high nibbles
	add.p	c,c
	move.p	a,c	; ???
	move.1	#7,p
	rtncc		; it's a positive number; we're done.
	not.wp	a
	move.1	#3,p
	not.wp	a	; flip high bits
	move.1	#7,p
	rtn

___divdi3
	; wp-mode c = b/r0

	move.1 	#7,p
	move.w	b,a
	move.8	#0,a.p
	move.w	a,b
	move.w	r0,c
	move.8	#0,c.p
	move.w	c,r0

___divti3
	; word-mode C = B / R0
	move.w	b,a	; a = parm 1
	move.w	r0,c	; c = parm 2
	jsr 	HXSDIV	; word-mode [[ a = c = a/c , b = a%c ]]
	move.1 #7,p
	rtn

___mulpdi3
	move.a	r0,a
	;;
	;; a-mode c = a * b
	;;
	clr.a	c
.t0
	clr.1	#2,hst
	lsr.a	#1,a
	beq	#2,hst,.t1
	add.a	b,c
.t1
	add.a	b,b
	bne.a	a,0,.t0
	rtncc


___muldi3
	move.wp	r0,a
	;; 
	;; wp-mode c = a * b
	;; make sure that p is set to desired # of nibbles-1 before entry
	;; 
	clr.wp	c
.t0
	clr.1	#2,hst
	lsr.wp	#1,a
	beq	#2,hst,.t1
	add.wp	b,c
.t1
	add.wp	b,b
	bne.wp	a,0,.t0
	rtncc
	

___multi3
	move.w	r0,a
	;;
	;; w-mode c = a * b
	;;
	clr.w	c
.t0
	clr.1	#2,hst
	lsr.w	#1,a
	beq	#2,hst,.t1
	add.w	b,c
.t1
	add.w	b,b
	bne.w	a,0,.t0
	rtncc
