
#include <hp48/lcd.h>

void
square_box (eint x1, eint y1, eint x2, eint y2)
{
  eint i;

  for (i = x1; i <= x2; i++)
    {
      clrpixel (i, y1);
      clrpixel (i, y2);
    }
  for (i = y1; i <= y2; i++)
    {
      clrpixel (x1, i);
      clrpixel (x2, i);
    }
}

int
main(int argc, char **argv)
{
    eint x, y;
    eint size;

    initscr ();

    for (y = 0; y < LCD_HEIGHT; y++)
      for (x = 0; x < LCD_WIDTH; x++)
        setpixel (x, y);

    for (size = 0; size < LCD_HEIGHT / 2; size += 2)
      square_box (size, size, LCD_WIDTH - size - 1, LCD_HEIGHT - size - 1);

    exitscr ();
    return 0;
}
