		/*===============================
		    header file for hpscat v1.3
		 ================================*/

/*--- user-definable part ---*/

/* titling fonts stuff */

#define  NameFont1   "AvantGarde-Book"		/* for "filename:" */
#define  NameFont2   "AvantGarde-Demi"		/* for real filename */
#define  PageNoFont  "AvantGarde-Demi"		/* for "page #" */
#define  TimeFont    "Palatino-BoldItalic"	/* for timestamp */
#define  LogoFont    "AvantGarde-Demi"
#define  DEF_TFONT   "NewCenturySchlbk-Bold"    /* for document title */

/* currently `hcode' is used for code-conversion */

#define  Converter  "hcode"

/** NOTE: you may give the compile option -DHPS in the Makefile
	only if you have hangul PS printer,
	for example, Trigem TG850, Qnix PSmII and so on. */

#ifdef  HPS
/* # define  HFont  "SMmu" */		/* this is set to QLBP PSmII font name */
 				/* change to whatever font-name you have */
# define  DEF_HFONT  "SMmu" 
# define  fromJH  "-tk"
# define  fromN   "-nk"
# define  fromI   "-ik"
#else
/* # define  HFont  "MunjoHan"  */
#ifdef ADV_HFONT           /* See Makefile for this option */
# define  DEF_HFONT Munjo  /* Choose default Hangul font */
                           /* Hangul fonts are defined below */
#else                            
# define  DEF_HFONT  "MunjoHan"  /* Choose default Hangul font. */
                                 /* You have to use exact font name */
#endif


# define  fromKS  "-kt"
# define  fromN   "-nt"
# define  fromI   "-it"
#endif  /* HPS */

/*------------------------------*\ 
|     don't touch below here     |
\*------------------------------*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <sys/time.h>

#ifdef __GNUC__
# define  PROT(x)  x
#else
# define  PROT(x)  ()
#endif

typedef enum { False, True } bool;

typedef enum { Korean, English } _cmode;
typedef enum { Plain, Bold } _efont;
typedef enum { Garo, Garo3, Sero, Sero2 } _layout;
typedef enum { KSC, Johap, Nbyte,ISO } _hcode;

#ifdef ADV_HFONT
/* Add mnimonics for Hangul fonts available before userfont   
   and list exact names for them in 'hfontname' in init.c */
typedef enum { Munjo,PCMunjo,MunjoBold,Gotic,userfont} _hfont;
#endif

#define HOR_SCALE_FAC 0.9  /* See showbuf.c */

/* For some mysterious asthetical reason, all horizontal scale
   in PS output is scaled by factor of 0.9 */
/* All horizontal values defined below are scaled by 1.0 / 0.9 
   expecting horizontal scaling down by factor 0.9 in PS output */

/*---  constants for layout  ---*/

#define   DEF_SW      24   /*  width of shadowed area  */
#define   DEF_SW_NL    3  /*  width of shaded area when no line # is to 
                                be printed */

#define   HEAD_height  20    /* height of header */
#define   FOOT_height  20    /* height of footer */

/*  landscape 2 column  */


/*
#define   L_width     420
#define   L_height    510

#define   L_LM1        53
#define   L_LM2      (L_LM1 + L_width)
#define   L_BM         45
#define   L_TM       (L_BM + L_height)
*/


/*  landscape 3 column  */

/*
#define   L3_width   (L_width*2/3)
#define   L3_height   L_height

#define   L3_LM1      L_LM1
#define   L3_LM2     (L3_LM1 + L3_width)
#define   L3_LM3     (L3_LM1 + L3_width*2)
#define   L3_BM       L_BM
#define   L3_TM       L_TM
*/

/*  portrait 1 column  */

/*
#define   P_width     575
#define   P_height    735

#define   P_LM         45
#define   P_BM         50
#define   P_TM       (P_BM + P_height)
*/

/*  portrait 2 column  */

/*
#define   P2_width   (P_width/2)
#define   P2_height   P_height

#define   P2_LM1      P_LM
#define   P2_LM2     (P2_LM1+P2_width)
#define   P2_BM       P_BM
#define   P2_TM       P_TM
*/

#define   Smallest    6
#define   Largest     30
#define   Defaultsize 8
#define   TI_FS       18 /* Document Title font size */

/* #define   Maxline    (P_height/Smallest)  */
/* #define   Maxchar    (P_width/Smallest*2) */

typedef struct {
    int  linenum;
    char *line;
} aline;

extern _hcode  hcode;      /*  input hangul code  */
extern _efont  efont;      /*  english font   - plain or bold */
extern _layout layout;     /*  layout format  - portrait or landscape  */

#ifdef ADV_HFONT
extern  _hfont hfont; 
extern char *hfontname[userfont+1];
#else
extern char *hfont;
#endif

extern char *tfont;  /* font for the document title */

extern char   *nalza;      /*  day & time  */

extern int     prows;      /*  # of rows a paper  */
extern int     fsize;      /*  font size  */
extern int     width;      /*  page buffer width  */
extern char    *title;     /*  document title */

extern _cmode  cmode;      /*  character mode - hangul or english  */
extern int     cpl;        /*  current line  */
extern int     pageno;     /*  current page  */
extern bool    nolnum;     /*  false if linenumber is required  */
extern bool    nobox;      /*  false if outlinebox is to be drawn  */
extern bool    noheader;   /*  false if header is to be put  */
extern bool    nofooter;   /*  false if footer is to be put  */
extern bool    notitle;    /*  false if document title is not known */
extern bool    cont;       /*  true if long line is to be wrapped   */
extern bool    to_stdout;  /*  true if write to stdout */
extern bool    cheat;      /*  true if cheating */
extern bool    narrow;     /*  false if normal courier is used */
extern FILE   *fp;         /*  file pointer to input file  */
extern FILE   *ofp;        /*  file pointer to output file  */

/***  EOF  ***/
