#include "hpscat.h"
#include "paper.h"

_hcode  hcode;
_efont  efont;
#ifdef ADV_HFONT
_hfont  hfont; 
#else  
char *hfont;
#endif
char *tfont;     /* Title font */
_layout layout;
_cmode  cmode;
char    *nalza;
int     prows, fsize, width;
bool    to_stdout, nolnum,nobox, cont;
bool    noheader,nofooter,notitle;
char    *title;
PAPER   paper;
int     min_bm;
int     min_lm;
int     s_width;
int     s_width_nl;

/* Exact hangul Postscript font names 
for corresponding entries in 'hfont' in hpscat.h */
#ifdef ADV_HFONT
char *hfontname[userfont+1] = {"MunjoHan","PCMunjoHan","MunjoBh","Gotich","userfont"};
#endif

/**************
   initialize
 **************/

void
init(ac,av)
  int  *ac;
  char *av[];
{
    int  i;
    extern void setnalza(), read_rc();
    extern void usage PROT((char *));

    /*  set default parameters  */
    hcode  = KSC;
    efont  = Plain;

#ifdef ADV_HFONT
    hfont  = DEF_HFONT; 
#else
    hfont  = (char *) malloc(strlen(DEF_HFONT));
    strcpy (hfont, DEF_HFONT);
#endif

    tfont  = (char *) malloc(strlen(DEF_TFONT));
    strcpy (tfont, DEF_TFONT);
    
    fsize  = Defaultsize;
    layout = Garo;
    nolnum = False;
    nobox  = False;
    noheader  = False;
    nofooter  = False;
    notitle   = True;
    to_stdout = True;
    cheat = False;
    narrow = True;
    paper  = DEFPAP;
    min_bm = DEF_MIN_BM;
    min_lm = DEF_MIN_LM;
    s_width = DEF_SW;      
    s_width_nl = DEF_SW_NL;
    

    read_rc();   /* read user's rc */

    /*  process command line arguments  */

    i = 1;
    while(av[i]) {
	if(av[i][0] == '-') {
	    if(!strcmp(av[i], "-f"))   to_stdout = False;
	    else if(!strcmp(av[i], "-l3")) layout = Garo3;
	    else if(!strcmp(av[i], "-l"))  goto next;
	    else if(!strcmp(av[i], "-p2")) layout = Sero2;
	    else if(!strcmp(av[i], "-p"))  layout = Sero;
	    else if(!strcmp(av[i], "-nl")) nolnum = True;
	    else if(!strcmp(av[i], "-nb")) nobox = True;
	    else if(!strcmp(av[i], "-nf")) nofooter = True;
	    else if(!strcmp(av[i], "-nh")) noheader = True;
	    else if(!strcmp(av[i], "-ks")) goto next;
	    else if(!strcmp(av[i], "-N"))  hcode = Nbyte;
	    else if(!strcmp(av[i], "-16")) hcode = Johap;
	    else if(!strcmp(av[i], "-i"))  hcode = ISO;
	    else if(!strcmp(av[i], "-bf")) efont = Bold;
	    else if(!strcmp(av[i], "-nn")) narrow = False;
	    else if(!strcmp(av[i], "-cheat")) cheat = True;
	    else if( !strncmp(av[i], "-T", 2)) {
                 title = (char *) malloc( strlen(av[i]+2)+1);
                 strcpy( title, av[i]+2); 
                 notitle = False;
            }
	    else if( !strncmp(av[i], "-fs", 3)) {
		int a = atoi(av[i]+3);
		if(a<Smallest||a>Largest) fatal("invalid font size");
		fsize = a;
            }
            else if(!strncmp(av[i], "-hf", 3)) {
#ifdef ADV_HFONT
                 _hfont j;
                 for ( j=Munjo; j< userfont; j++)
                    if ( ! strcmp(hfontname[j],av[i]+3) )
                      break;
                 if ( j == userfont) {
                     fprintf(stderr,"Hangul font %s is not known.\n",av[i]+3);
                     fprintf(stderr,"This font should be available to you\n");
                     hfontname[userfont] = (char *) malloc(strlen(av[i]+3)+1);
                     strcpy(hfontname[userfont],av[i]+3);
                 }
                 hfont = j;
#else
                 hfont = (char *) malloc(strlen(av[i]+3));
                 strcpy(hfont, av[i]+3);
#endif
            }
            else if(!strncmp(av[i], "-tf", 3)) {
                 tfont = (char *) malloc(strlen(av[i]+3));
                 strcpy(tfont, av[i]+3);
            }
            else if( !strncmp(av[i], "-p", 2) &&  
                     strncmp(av[i], "-ph",3) && strncmp(av[i],"-pw",3)  &&
                     strcmp(av[i],"-p") && strcmp(av[i],"-p2") ) {
                 PAPER j;
                 for ( j=a3; j< user; j++) 
                    if ( ! strcmp(papersize[j].name, av[i]+2) )
                      break;
                 if ( j == user) fatal("invalid paper type");
                 paper =  j; 
	    }
            else if ( !strncmp(av[i], "-ph",3) ) {
                 int a = a2point(av[i]+3);
/*               if ( a < PHMIN || a > PHMAX ) fatal("invalid paper height"); */
                 papersize[user].width = papersize[paper].width;
                 paper = user;
                 papersize[paper].height =  (long) a;
            }
            else if ( !strncmp(av[i], "-pw",3) ) {
                 int a = a2point(av[i]+3);
/*               if ( a < PWMIN || a > PWMAX ) fatal("invalid paper width"); */
                 papersize[user].height = papersize[paper].height;
                 paper = user;
                 papersize[paper].width = (long) a;
            }
            else if ( !strncmp(av[i], "-mbm",4) ) {
                 int a = a2point(av[i]+4);
                 if ( a < ABS_MIN_BM ) fatal("invalid min. bottom margin");
                 min_bm = a;
            }
            else if ( !strncmp(av[i], "-mlm",4) ) {
                 int a = a2point(av[i]+4);
                 if ( a < ABS_MIN_LM ) fatal("invalid min. left margin");
                 min_lm = a;
            }
            else if ( !strncmp(av[i], "-sw",3) ) {
                 int a = a2point(av[i]+3);
/*               if ( a < ABS_MIN_SW ) fatal("invalid shaded area width");*/
                 s_width = a;
            }
            else if ( !strncmp(av[i], "-sn",3) ) {
                 int a = a2point(av[i]+3);
/*               if ( a < ABS_MIN_SW_NL) fatal("invalid shaded area width"); */
                 s_width_nl = a;
            }
	    else usage(av[0]);
	  next:
	    { /* shifting arguments */
	        int j;
	        for(j=i; j<*ac; j++) av[j] = av[j+1];
	    }
	    (*ac)--;
	}
	else i++;
    }
    cont = False;

    setmargin();
    
    
    s_width = nolnum ? ( nobox ? 0 : s_width_nl ) : s_width ; 

    switch(layout) {
      case Garo:  prows = l_height/fsize-1; width = l_width-s_width;  break;
      case Garo3: prows = l_height/fsize-1; width = l3_width-s_width; break;
      case Sero:  prows = p_height/fsize-1; width = p_width-s_width;  break;
      case Sero2: prows = p_height/fsize-1; width = p2_width-s_width; break;
    }
    
    setnalza();
}

void
setnalza()
{
    struct timeval  T;
    struct timezone tz;
    struct tm *Time;
    
    nalza = (char *)malloc(32);
    gettimeofday(&T, &tz);
    Time = (struct tm *) malloc(sizeof(struct tm));
    Time = localtime(&T.tv_sec);
    sprintf(nalza, "%02d:%02d,    %d/%d/%d",
	    Time->tm_hour,  Time->tm_min,
            Time->tm_mon+1, Time->tm_mday, Time->tm_year );
}

/***  EOF  ***/
