#include <errno.h>
#include "hpscat.h"
#include "paper.h"

extern totalpages;
static converted;
char  *tmpfn;

void
convert(s)
  char *s;
{
    int  i;
    char *args[5];  /* for execvp */
    extern void execute PROT((char **));
#ifdef  HPS
    if(hcode==KSC) {
#else
    if(hcode==Johap) {
#endif
        converted = 0;
        return;
    }
    tmpfn = tempnam("/tmp", "hpscat");
    for(i=0; i<4; i++)
        args[i] = (char *)malloc(256);
    strcpy(args[0], Converter);
    strcpy(args[2], s);
    strcpy(args[3], tmpfn);
    args[4] = (char *) 0;
    switch(hcode) {
#ifdef  HPS
      case Johap: strcpy(args[1], fromJH); break;
#else
      case KSC:   strcpy(args[1], fromKS); break;
#endif
      case Nbyte: strcpy(args[1], fromN); break;
      case ISO:   strcpy(args[1], fromI); break;
    }
    execute(args);
    fclose(fp);
    fp = fopen(tmpfn,"r");
    converted = 1;
}

void
execute(args)
  char **args;
{
    int  pid, status;
    if((pid=fork()) < 0) {
         perror("fork");
         exit(1);
    }
    if(pid==0) {
        execvp(args[0], args);
        perror("execvp");
        exit(1);
    }
    while(wait(&status)!=pid);
}

void
endfile()
{
    fprintf(ofp,"%%%%Trailer\n%%%%Pages: %d\n",pageno);
    fclose(fp);
    if(ofp!=stdout) fclose(ofp);
    if(converted) unlink(tmpfn);
    fprintf(stderr,"%2d page%c\n", pageno, (pageno<2)? ' ':'s');
    totalpages += pageno;
}

#define   U1    "\033[4m"  /* underline on  */
#define   U2    "\033[7m"  /* inverse   on  */
#define   U0    "\033[0m"  /* underline off */

char *ver = "1.3.1";

void
usage(prg)
  char *prg;
{
  fprintf(stderr,"\t\t\t     %shpscat v%s%s\n", U2, ver, U0);
  fprintf(stderr,"\t\t\t\t\tby jbkang@csone.kaist.ac.kr\n");
  fprintf(stderr,"\t\t\t\t\trevision by jshin@minerva.cis.yale.edu\n");
  fprintf(stderr," Usage :  %s [options] files ...\n\n", prg);
  fprintf(stderr,"    %slayout options  (default is -l)%s\n", U1, U0);
  fprintf(stderr,"\t-l, -l3 : landscape 2 columns, 3 columns\n");
  fprintf(stderr,"\t-p, -p2 : portrait  1 column,  2 columns\n");
  fprintf(stderr,"    %scode options    (default is -ks)%s\n", U1, U0);
  fprintf(stderr,"\t-ks, -N, -16, -i : ksc5601, N-byte, johap, iso2022-1 code\n");
  fprintf(stderr,"    %sfont options%s\n", U1, U0);
  fprintf(stderr,"\t-bf : use boldface english font\n");
#ifdef ADV_HFONT
  fprintf(stderr,"\t-hf<hangul font> : sets Hangul font(default is %s)\n",
                  hfontname[DEF_HFONT]);
#else
  fprintf(stderr,"\t-hf<hangul font> : sets Hangul font(default is %s)\n",
                  DEF_HFONT);
#endif
fprintf(stderr,"\t <hangul font> can be\n");
   fprintf(stderr,"\t  name of any Hangul font available to you\n");
#ifdef ADV_HFONT
  fprintf(stderr,"\t  including but not limited to\n\t  ");
  { _hfont temp;
    for ( temp=Munjo; temp <  userfont-1; temp++)
        fprintf(stderr,"%s%s", hfontname[temp],(temp % 5 == 4 ) ? 
          "\n\t   " : "," );
    fprintf(stderr, "%s.\n",hfontname[temp]);
  }
#endif
  fprintf(stderr,"\t-tf<title font> : sets font for title(default is %s)\n",
                  DEF_TFONT);
  fprintf(stderr,"\t-fs#: set font size for text [%d~%d] (default is -fs%d)\n",
  	Smallest, Largest, Defaultsize);
  fprintf(stderr,"    %soptions for papertype and margins%s\n", U1, U0);
  fprintf(stderr,"\t-p<paper type> : set paper type(default:%s)\n",
                   papersize[DEFPAP].name);
  fprintf(stderr,"\t  valid paper types are \n");
  fprintf(stderr,"\t  ");
  { PAPER temp;
    for ( temp=a3; temp <  user-1; temp++)
        fprintf(stderr,"%s%s", papersize[temp].name,(temp%5==4) ? 
                  ",\n\t  " : "," );
    fprintf(stderr, "%s.\n",papersize[temp].name);
  }
  fprintf(stderr,"\t-pw<paper width> : set the width of paper\n");
  fprintf(stderr,"\t-ph<paper height> : set the height of paper\n");
  fprintf(stderr,"\t-mbm<length> : set min. bottom margin\n");
  fprintf(stderr,"\t-mlm<length> : set min. left margin\n");
  fprintf(stderr,"\t    only necessary for a printer with unusually wide\n");
  fprintf(stderr,"\t    non-printable area\n");
  fprintf(stderr,"\t-sw<length>  : set shaded area width\n");
  fprintf(stderr,"\t-sn<length>  : set shaded area width when -nl is used.\n");
  fprintf(stderr,"\t  where <width> and <height> are <number><unit>.\n");
  fprintf(stderr,"\t  <unit> can be omitted or one of following\n\t  ");
  { UNIT temp;
    for ( temp=milimeter; temp <  null; temp++)
        fprintf(stderr,"%s%s", unit[temp].sym,temp==null-1 ? ".\n":",");
    fprintf(stderr,"\t  When omitted, standard PS unit(1/72 inch) is assumed.\n");
  }
  fprintf(stderr,"    %smisc options%s\n", U1, U0);
  fprintf(stderr,"\t-f  : output to `filename.ps'  (default is stdout)\n");
  fprintf(stderr,"\t-T<title>  : document title to be put  \n");
  fprintf(stderr,"\t-nb : no  outline box\n");
  fprintf(stderr,"\t-nl : no line number\n");
  fprintf(stderr,"\t-nh : no header\n");
  fprintf(stderr,"\t-nf : no footer\n");
  fprintf(stderr,"\t-nn : don't use 1:2 font width proportion (not narrowed)\n");

  fprintf(stderr,"\t-cheat : no actual output. just count pages\n\n");
  fprintf(stderr,"    options can be set in ~/.hpscatrc in the form \"name = value\"\n");
  fprintf(stderr,"\t\tnames can be : layout, code, bold, narrow, size,paper\n");
  fprintf(stderr,"\t\t               paperwidth,paperheight,hangulfont,titlefont,\n");
  fprintf(stderr,"\t\t               min_bot_margin,min_left_mar,\n");
  fprintf(stderr,"\t\t               shade_width,shade_width_nl\n");
  fprintf(stderr,"\t\tvalues can be : l, l3, p, p2 (for layout)\n");
  fprintf(stderr,"\t\t                ks, N, 16, i (for code)\n");
  fprintf(stderr,"\t\t                true, false  (for bold and narrow)\n");
  fprintf(stderr,"\t\t                number in point   (for size)\n");
  fprintf(stderr,"\t\t                <length><unit> (for paperwidth/height/margin)\n");
  
  exit(0);
}

void
fatal(s)
  char *s;
{
    fprintf(stderr,"? %s\n", s);
    exit(1);
}

/***  EOF  ***/
