#include "hpscat.h"
#include "paper.h"
#include <string.h>
#include <stdlib.h>

#define MIN(a,b)  ( ((a) > (b)) ? (b) : (a) )
#define MAX(a,b)  ( ((a) < (b)) ? (b) : (a) )

/* names and  dimensions(width and height) of paper types defined in paper.h 
   unit is in standard Postscript point(1 PS point = 1/72 inch.
  */

PAPERSIZE  papersize[user+1]= { {"a3",842,1190}, {"a4",595,842}, {"a5",420,595},
                        {"b4",729,1032},{"b5",516,729},
                        {"letter",612,792},{"10x14",720,1008},
                        {"legal",612,1008},{"executive",540,720},
                        {"folio",612,936},{"quarto",610,780},
                        {"statement",396,612},{"ledger",1224,792}, 
                        {"tabloid",792,1224}, {"c5",459,649},
                        {"user",0,0} };



/* symbol and conversion factor to standard PS point(1 PS point = 1/72 inch)
   of length units defined in paper.h */
UNITDEF unit[null+1]={ {"mm",2.835}, {"cm",28.35},{"in",72.0},
                        {"pt",1.0},{"",1.0} };

int s_width;
int l_width,l_height,l_lm1,l_lm2,l_bm,l_tm;
int l3_width,l3_height,l3_lm1,l3_lm2,l3_lm3,l3_bm,l3_tm;
int p_width,p_height,p_lm,p_bm,p_tm;
int p2_width,p2_height,p2_lm1,p2_lm2,p2_bm,p2_tm;




int a2point(char *token)
{

   char *a;
   int  n = strlen(token);

   UNIT i;

   for ( i = milimeter ; i< null; i++) 
       if ( !strcmp(token+(strlen(token)- strlen(unit[i].sym)), unit[i].sym)){
          n -= strlen(unit[i].sym);
          break;
       }

   a = (char *) malloc( n + 1);
   strncpy (a,token, n);
   a[n]='\0'; 
   return (int) ( (float) atof( a ) * unit[i].ratio ) ;
}
   
void setmargin()
{


/*
  l_lm1   =  (int) (papersize[paper].height * LLM1_ratio);
  l_width = (int) (papersize[paper].height * LW_ratio);
  l_lm2   = l_lm1 + l_width;
*/

  l_lm1   =  MAX ( (int) (papersize[paper].height * LLM1_ratio), min_lm);
  l_width = ( papersize[paper].height - l_lm1 * 2 ) / 2 ; 
  l_lm2   = l_lm1 + l_width;

/* See hpscat.h for HOR_SCALE_FAC */

  l_lm1 = (int) (l_lm1 * 1.0 / HOR_SCALE_FAC);
  l_width = (int) (l_width * 1.0 / HOR_SCALE_FAC);
  l_lm2  = (int) ( l_lm2 * 1.0 / HOR_SCALE_FAC);
  

  l_bm    = MAX ( (int) (papersize[paper].width * LBM_ratio), min_bm) ;
  l_bm = (int) (l_bm -  ((noheader && notitle) * HEAD_height  + 
                   nofooter * FOOT_height) / 2. / 1.3 ); 
  l_height = papersize[paper].width - (int) (l_bm * ( 1. + TMBM_ratio)+0.5) ;
  l_tm    = l_bm + l_height;


/*
  l_bm    = (int) (papersize[paper].width * LBM_ratio);
  l_height = (int) (papersize[paper].width * LH_ratio) ;
  l_tm    = l_bm + l_height;
*/
   


  l3_width = (int) (l_width * 2.0/3.0);
  l3_height = l_height;

  l3_lm1 = l_lm1;
  l3_lm2 = l3_lm1 + l3_width;
  l3_lm3 = l3_lm2 + l3_width;
  l3_bm  = l_bm;
  l3_tm  = l_tm;

  p_lm = MAX( (int) (papersize[paper].width * PLM_ratio), min_lm);
  p_width = papersize[paper].width  - p_lm * 2; 
  p_lm = (int) (p_lm * 1.0 / HOR_SCALE_FAC);
  p_width = (int) (p_width * 1.0 / HOR_SCALE_FAC);

/*
  p_width = (int) (papersize[paper].width * PW_ratio);
  p_lm = (int) (papersize[paper].width * PLM_ratio);
*/

  p_bm    = MAX( (int) (papersize[paper].height * PBM_ratio), min_bm) ;
  p_bm = p_bm -  ((noheader && notitle) * HEAD_height 
                 + nofooter * FOOT_height) / 2;
  p_height = papersize[paper].height - (int) (p_bm * ( 1. + TMBM_ratio)+ 0.5) ;
  p_tm    = p_height + p_bm;

/*
  p_height = (int) (papersize[paper].height * PH_ratio);
  p_bm = (int) (papersize[paper].height * PBM_ratio);
  p_tm = p_bm + p_height;
*/

  p2_width = (int) (p_width/2.0);
  p2_height = p_height;

  p2_lm1 = p_lm;
  p2_lm2 = p2_lm1+p2_width;
  p2_bm = p_bm;
  p2_tm = p_tm;

}
