#include "hpscat.h"
#include "ps.h"
#include "paper.h"

extern aline *pagebuf;

/**************************
   make PostScript output
     (from page buffer)
 **************************/

void
showbuf(lm)
  int  lm;
{
    int  i, top = (layout==Sero || layout==Sero2) ?  p_tm : l_tm;
    extern void showline PROT((char *));

    if(cheat) return;
    moveto(lm, top- (int) (fsize * 1.4+0.5 ));

    for(i=0; i<prows; i++) {
	char  ns[6];
	if(pagebuf[i].linenum == -1)  /*  EOF  */
	    return;
/*      else if(pagebuf[i].linenum && !nolnum)
            sprintf(ns,"%5d",pagebuf[i].linenum);*/  /*  normal line  */
/*      else 
            strcpy(ns,"     ");  */   /*  continued line  */
/*      fprintf(ofp,"N (%s )S E ", ns);
*/
        else if(!nolnum) {
             if(pagebuf[i].linenum)
                sprintf(ns,"%5d",pagebuf[i].linenum);  /*  normal line  */
             else 
                strcpy(ns,"     ");      /*  continued line  */
             fprintf(ofp,"N (%s )S E ", ns);
        }
        else 
          fprintf(ofp,"E %d %d R ", s_width,0); 
        showline(pagebuf[i].line);
        moveto(lm, (top-(int) (fsize*1.4+0.5) )-(i+1)*fsize);
    }
}

#ifdef HPS  /* hangul PS printer */

void
showline(s)
  char  *s;
{
    int  i=0;

    cmode = English;
    fprintf(ofp,"(");
    while(s[i]) {
	if(s[i]&0x80) {
	    if(cmode==English) {
		cmode = Korean;
	        fprintf(ofp,")S H (");
	    }
	    fprintf(ofp,"%c%c", s[i], s[i+1]);
	    i += 2;
	}
	else {
	    if(cmode==Korean) {
		cmode = English;
		fprintf(ofp,")S E (");
	    }
	    fputc(s[i],ofp);
  	    i++;
	}
    }
    fprintf(ofp,")S\n");
}

#else    /* not hangul PS printer */

/* -1 code stands for fill code */

static int fcode[] = { 0, -1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
	   12, 13, 14, 15, 16, 17, 18, 19, 20 };
static int mcode[] = { 0, 0, -1, 1, 2, 3, 4, 5, 0, 0, 6, 7, 8, 9, 10, 11,
	   0, 0, 12, 13, 14, 15, 16, 17, 0, 0, 18, 19, 20, 21 };
static int lcode[] = { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
     11, 12, 13, 14, 15, 16, 0, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27 };

static int fjaso[] = {
    0x10, 0x11, 0x12, 0x14, 0x16,  0x19, 0x1a, 0x1b, 0x1c, 0x1d,
    0x1e, 0x1f, 0x0f, 0x21, 0x22,  0x23, 0x24, 0x26, 0x28
};

static int mjaso[] = {
    0x29,      0x2a|0x80, 0x2a,      0x2b|0x80, 0x2b,  0, 0,
    0x2d|0x80, 0x2f,      0x32+0x80, 0x47,      0x49|0x80, 0x5d|0x80,  0, 0,
    0x4c|0x80, 0x4a,      0x62,      0x73|0x80, 0x89|0x80, 0x75|0x80,  0, 0,
    0x66,      0x4e,      0x4e|0x80, 0x33
};

void
showline(s)
  char  *s;
{
    int  i=0;
    int  code, f, m, l;
    int  set, fc, mc, lc, currset = -1;
    extern void putit PROT((int));

    cmode = English;
    fprintf(ofp,"(");
    while(s[i]) {
	if(s[i]&0x80) {
	    if(cmode==English) {
		cmode = Korean;
		currset = -1;
	    }
	    code = s[i] & 0xff;
	    code = code*256 + (s[++i] & 0xff);
	    f = (code / 1024) % 32;
	    m = (code / 32) % 32;
	    l =  code % 32;

	    /** added for jaso handling **/
	    if(mcode[m]==-1 && fcode[f]!=0) {
		if(currset!=1) {
		    set = currset = 1;
		    fprintf(ofp,")s H%d (", currset);
		}
		putit(fjaso[f-2]);
		fprintf(ofp,")S %d 0 rmoveto (", (int)((float)(fsize)*7.5/8.));
		i++; continue;
	    }
	    if(fcode[f]==-1 && mcode[m]!=0) {
		if(mjaso[m-3]) {
		    int  mm = mjaso[m-3];
		    if(mm > 127) {  /* set 2 */
			if(currset!=2) {
			    currset = set = 2;
			    fprintf(ofp,")S H%d (", currset);
			}
			mm -= 128;
		    }
		    else if(currset!=1 && mm < 128) { /* set 1 */
			currset = set = 1;
		        fprintf(ofp,")S H%d (", currset);
		    }
		    putit(mm);
		}
		i++; continue;
	    }
	    set = find_set(mcode[m]);
	    if(set > 2)
		fatal("find_set() : invalid number..maybe corrupted input?");
	    else if(set==0) {
		fprintf(stderr,"? strange hangul code...ignoring\n");
		i++;
		continue;
	    }
	    fc = find_f(fcode[f],mcode[m],lcode[l]);
	    mc = find_m(fcode[f],mcode[m],lcode[l]);
	    lc = find_l(fcode[f],mcode[m],lcode[l]);
	    if(set!=currset) {
		currset = set;
		fprintf(ofp,")S H%d (", currset);
	    }
	    putit(fc);
	    putit(mc);
	    if(lc)
		putit(lc);
	}
	else {
	    if(cmode==Korean) {
		cmode = English;
		fprintf(ofp,")S E (");
	    }
	    fputc(s[i],ofp);
	}
	i++;
    }
    fprintf(ofp,")S\n");
}

#endif  /* HPS */

void
putit(c)
  int  c;
{
    switch(c) {
      case '\\': fprintf(ofp,"\\\\"); break;
      case '(':  fprintf(ofp,"\\("); break;
      case ')':  fprintf(ofp,"\\)"); break;
      default:  fprintf(ofp,"\\%03o", c&0xff);
    }
}

/***********************
   draw decorative box
 ***********************/

void
teduri(fname)
  char *fname;
{
    int  x, y;

    if(cheat) return;

    if(layout==Garo || layout==Garo3)
	fprintf(ofp,"90 rotate 0 %d translate ", - papersize[paper].width);
    fprintf(ofp," %f 1 scale\n",HOR_SCALE_FAC);

    if(nobox == False) 
       if(layout==Sero) {
   	box(p_lm, p_bm, p_width, p_height);
   	fillbox(p_lm, p_bm, s_width, p_height);
   	box(p_lm, p_bm, s_width, p_height);
       }
       else if(layout==Sero2) {
   	box(p2_lm1, p2_bm, p2_width, p2_height);
   	box(p2_lm2, p2_bm, p2_width, p2_height);
   	fillbox(p2_lm1, p2_bm, s_width, p2_height);
   	fillbox(p2_lm2, p2_bm, s_width, p2_height);
       }
       else if(layout==Garo){
   	box(l_lm1, l_bm, l_width, l_height);
   	box(l_lm2, l_bm, l_width, l_height);
   	fillbox(l_lm1, l_bm, s_width, l_height);
   	fillbox(l_lm2, l_bm, s_width, l_height);
       }
       else {    /*  Garo3  */
   	box(l3_lm1, l3_bm, l3_width, l3_height);
   	box(l3_lm2, l3_bm, l3_width, l3_height);
   	box(l3_lm3, l3_bm, l3_width, l3_height);
   	fillbox(l3_lm1, l3_bm, s_width, l3_height);
   	fillbox(l3_lm2, l3_bm, s_width, l3_height);
   	fillbox(l3_lm3, l3_bm, s_width, l3_height);
       }
    if(noheader == False) {
       x = (layout==Sero||layout==Sero2) ?  p_lm : l_lm1;
       y = (layout==Sero||layout==Sero2) ?  p_tm : l_tm;
        setfont(NameFont1, 11);
        moveto(x+10, y+10);
       fprintf(ofp,"(filename)S ");
        setfont(NameFont2, 14);
        moveto(x+70, y+10);
       fprintf(ofp,"(%s) S\n", fname);

       if (nobox == True) {
         moveto(x+5,y+3);
         fprintf(ofp,"%d %d R .2 L T\n",
           (layout==Sero||layout==Sero2) ?  p_width - 5*2 : l_width -5*2, 0); 
       }

       x = (layout==Sero||layout==Sero2) ? 
      	   p_lm+p_width-10 : l_lm2+l_width-10;
        setfont(PageNoFont, 12);
       fprintf(ofp,"%d %d (page  %d) RS\n", x,y+10,pageno);
    }
    if (notitle == False) {
       x = (layout==Sero||layout==Sero2) ? 
           (int) (papersize[paper].width / 2 * (1. / HOR_SCALE_FAC)) :
           (int) (papersize[paper].height / 2 * (1. / HOR_SCALE_FAC)) ; 
       y =  5  + ( (layout==Sero||layout==Sero2) ?  p_tm : l_tm );
       setfont(tfont,TI_FS);
       fprintf(ofp," %d %d (%s) CS\n ",x,y,title);
       if ( nobox && noheader ) 
          fprintf(ofp, "%d %d %d (%s) UL \n",10,x,y-3,title);
    }
    if(nofooter == False) {
       x = (layout==Sero||layout==Sero2) ? 
      	   p_lm+p_width-10 : l_lm2+l_width-10;
       y = (layout==Sero||layout==Sero2) ?  p_bm-20 : l_bm-20;
        setfont(TimeFont, 11);
       fprintf(ofp," %d %d (printed at  %s) RS\n", x,y,nalza);

       x = (layout==Sero||layout==Sero2) ?  p_lm : l_lm1;
       y = (layout==Sero||layout==Sero2) ?  p_bm : l_bm;
        setfont(LogoFont, 9);
        fprintf(ofp,"gsave newpath %d %d M (HPSCAT 1.3) ", x+10, y-20);
        fprintf(ofp,"false charpath .1 L T grestore\n");
       if (nobox == True) {
          moveto(x+5,y -6);
          fprintf(ofp,"%d %d R .2 L T\n",
          (layout==Sero||layout==Sero2) ?  p_width - 5*2 : l_width -5*2, 0); 
       }

    }
}    

/***  EOF  ***/
