/*
 *   hpscat : hangul printing program for postscript ver 1.3.1
 *
 *                           last update : Jul 17 1993
 *                           written by  : jbkang@csone.kaist.ac.kr
 */

#include "hpscat.h"
#include "paper.h"

int  pageno, totalpages;
bool cheat;
FILE *fp, *ofp;

/****************
   main routine
 ****************/

main(ac,av)
  int  ac;
  char *av[];
{
    int  i;
    extern void showfile PROT((char *));
    extern void init PROT((int *, char **));

    init(&ac, av);

    if(ac<2) {
        fp = stdin;
        ofp = stdout;
        to_stdout = True;
        showfile("");
        exit(0);
    }
    for(i=1; i<ac; i++) {
        fp = fopen(av[i],"r");
        if(!fp) {
            fprintf(stderr,"can't open file %s : skipping\n", av[i]);
            continue;
	}
	if(to_stdout) ofp = stdout;
	else if(!cheat) {
	    if(open_outfile(av[i])== -1) {  /* assign out fp */
	        fprintf(stderr,"can't open output file : skipping\n");
	        continue;
	    }
	}
	fprintf(stderr,"%-16s...", av[i]);
	showfile(av[i]);
    }
    if(ac>2) fprintf(stderr,"\ntotal %d pages\n", totalpages);
    exit(0);
}

int
open_outfile(s)    /*  returns -1 if can't write */
  char *s;
{
    char ans[80], buf[256];
    sprintf(buf,"%s.ps", s);
    if(ofp=fopen(buf,"r")) { /* file exists */
	fclose(ofp);
	fprintf(stderr,"output file %s exists...overwrite? ", buf);
	gets(ans);
	if(ans[0]=='y')
	    unlink(buf);
	else 
	    return -1;
    }
    ofp = fopen(buf,"w");
    return 0;
}

void
showfile(s)
  char *s;
{
    int lmargin = (layout==Sero||layout==Sero2) ?  p_lm : l_lm1;
    extern void prologue();
    extern void convert PROT((char *));
    extern void teduri PROT((char *));
    extern void showbuf PROT((int));

    cpl = 0;
    pageno = 1;
    prologue();
    if(!strcmp(s,"")) {
        if(s) free(s);
        s = (char *)malloc(8);
        strcpy(s,"stdin");
        convert("-");
    }
    else
        convert(s);  /* code conversion, if needed */

    while(1) {
	int  eof;

        fprintf(ofp,"%%%%Page: %d %d\n", pageno,pageno);

	teduri(s);


	eof = fillpagebuf();
	showbuf(lmargin+2);
	if(!eof) {
	    if(layout==Garo) {
	        eof = fillpagebuf();
	        showbuf(lmargin+l_width+2);
	    }
	    else if(layout==Garo3) {
	        eof = fillpagebuf();
	        showbuf(lmargin+l3_width+2);
	        if(!eof) {
       	            eof = fillpagebuf();
	            showbuf(lmargin+(l3_width+2)*2);
                }
	    }
	    else if(layout==Sero2) {
	 	eof = fillpagebuf();
		showbuf(lmargin+p2_width+2);
	    }
	}
	if(!cheat) fputs("showpage\n", ofp);
	if(eof) break;
	pageno++;
    }
    endfile();
}

/***  EOF  ***/
