typedef struct { char name[12];
                 int width; 
                 int height; } PAPERSIZE;
/* mnemonics for paper type.
   add other paper types like b4 and b5  before the last entry 'user' here 
   and their dimensions to the array  'papersize' in paper.c */
typedef enum {a3,a4,a5,b4,b5,letter,t10x14,legal,executive,
              folio,quarto,statement,ledger,tabloid,user} PAPER; 

/* mnemonics for length unit  
   add other unit such as pica  and conversion factor to standard
   Postscript point to the array 'unit' in paper.c */
typedef enum {milimeter,centimeter,inch,point,null} UNIT;

typedef struct { char sym[3];
                 float ratio;} UNITDEF;


extern PAPER paper;
extern PAPERSIZE papersize[user+1];
extern UNITDEF unit[null+1];
extern int min_bm;
extern int min_lm;
extern int a2point(char *);
extern void setmargin();

#ifdef US_VERSION
 #define DEFPAP letter
#else
 #define DEFPAP a4
#endif


  
/* These  are 'real' values in PS unit,  not ones scaled by factor of 1/0.9 */

#define LH_ratio 0.8571
#define LW_ratio 0.4480
#define LLM1_ratio 0.05566
#define LBM_ratio 0.07160
#define PW_ratio 0.8698
#define PH_ratio 0.8729
#define PLM_ratio 0.06807
#define PBM_ratio 0.05938


#define TMBM_ratio 0.975 /* top margin / bottom margin */
#define DEF_MIN_BM 30 /* minimum bottom and top margin */
#define DEF_MAX_BM ?? /* Not yet used. */
#define DEF_MIN_LM 22  /* Not necessary, is it? Yes, it is !! */
#define DEF_MAX_LM 59  /* maximum left and right margin. Not yet used */

#define ABS_MIN_BM 22 
#define ABS_MIN_LM 18  /* depends on printer */ 


extern s_width;
extern s_width_nl;
extern int l_width,l_height,l_lm1,l_lm2,l_bm,l_tm;
extern int l3_width,l3_height,l3_lm1,l3_lm2,l3_lm3,l3_bm,l3_tm;
extern int p_width,p_height,p_lm,p_bm,p_tm;
extern int p2_width,p2_height,p2_lm1,p2_lm2,p2_bm,p2_tm;

                       
/* "tabloid", "statement",  "executive",  "folio",  "quarto" */
   

