/*
 *  name of resource file: ~/.hpscatrc
 *
 *  valid resources
 *	layout = l, l3, p, p2
 *	code   = ks, N, 16, i
 *	bold   = true, false
 *	narrow = true, false
 *	size   = 6 ~ 30
 */

#include "hpscat.h"
#include "paper.h"
#include <ctype.h>

#define  RCFILE   ".hpscatrc"

#define  skipws()   { while(isspace(buf[i])) i++; }
#define  skipeq()   { \
    skipws(); \
    if(buf[i] != '=') { \
        fprintf(stderr,"missing `=' for resource `%s'\n", token); \
        continue; \
    } \
    i++; \
    skipws(); \
}
#define  gettoken() { \
    while(isalnum(buf[i]) || (buf[i]=='.') ) token[j++] = buf[i++]; \
    token[j] = 0; \
    if(token[0]==0) continue; \
}

void
read_rc()
{
    char buf[BUFSIZ];
    char *home;
    FILE *fp;
    extern char *getenv PROT((char *));
    home = getenv("HOME");
    if(strlen(home)==0)
        return;
    strcpy(buf, home);
    strcat(buf, "/");
    strcat(buf, RCFILE);
    if((fp=fopen(buf,"r"))==NULL) return;
    while(fgets(buf,BUFSIZ-1,fp)) {
        int  i=0, j;
        char token[64];
        if(buf[0]=='#') continue;  /* comments */
        skipws();
        j = 0;
        gettoken();
        j = 0;
        if(!strcmp(token,"layout")) {
            skipeq();
            gettoken();
	    if(!strcmp(token,"l")) continue;
	    else if(!strcmp(token,"l3"))
	        layout = Garo3;
	    else if(!strcmp(token,"p"))
	        layout = Sero;
	    else if(!strcmp(token,"p2"))
	        layout = Sero2;
	    else
	        fprintf(stderr,"unknown layout `%s' in .hpscatrc\n", token);
	    continue;
        }
        else if(!strcmp(token,"code")) {
            skipeq();
	    gettoken();
	    if(!strcmp(token,"ks")) continue;
	    else if(!strcmp(token,"N"))
	        hcode = Nbyte;
	    else if(!strcmp(token,"16"))
	        hcode = Johap;
	    else if(!strcmp(token,"i"))
	        hcode = ISO;
	    else
	        fprintf(stderr,"unknown code `%s' in .hpscatrc\n", token);
	    continue;
        }
        else if(!strcmp(token,"bold")) {
            skipeq();
            gettoken();
            if(!strcmp(token,"false")) continue;
            else if(!strcmp(token,"true"))
                efont = Bold;
	    else
	        fprintf(stderr,"unknown value `%s' in .hpscatrc\n", token);
            continue;
        }
        else if(!strcmp(token,"narrow")) {
            skipeq();
            gettoken();
            if(!strcmp(token,"true")) continue;
            else if(!strcmp(token,"false"))
                narrow = False;
	    else
	        fprintf(stderr,"unknown value `%s' in .hpscatrc\n", token);
            continue;
        }
        else if(!strcmp(token,"size")) {
            int  size;
            skipeq();
            gettoken();
            size = atoi(token);
            if(size<Smallest || size>Largest)
                fprintf(stderr,"invalid font size %d in .hpscatrc\n", size);
            else
                fsize = size;
            continue;
        }
        else if(!strcmp(token,"hangulfont")) {
#ifdef ADV_HFONT
            _hfont temp;

            skipeq();
            gettoken();
            for ( temp=Munjo; temp< userfont ; temp++)
               if ( ! strcmp(hfontname[temp],token) )
                  break;
            if ( temp == userfont) {
                  fprintf(stderr,"Hangul font %s is not known.\n",token);
                  fprintf(stderr,"This font should be available to you\n");
                  hfontname[userfont] = (char *) malloc(strlen(token)+1);
                  strcpy(hfontname[userfont],token);
            }
            hfont = temp;
#else
            skipeq();
            gettoken();
             hfont = (char *) malloc(strlen(token));
             strcpy(hfont, token);
#endif
            continue;
        }
        else if(!strcmp(token,"titlefont")) {
            skipeq();
            gettoken();
             tfont = (char *) malloc(strlen(token));
             strcpy(tfont, token);
            continue;
        }
        else if(!strcmp(token,"paper")) {
            PAPER  temp;
            skipeq();
            gettoken();
            for ( temp=a3; temp< user; temp++)
                if ( ! strcmp(papersize[temp].name, token) )
                     break;
            if ( temp == user) 
                fprintf(stderr,"invalid paper type %s in .hpscatrc\n", token);
            else
                paper =  temp;        
            continue;
         }
        else if(!strcmp(token,"paperheight")) {
            int  a;
            skipeq();
            gettoken();
            a = a2point(token);
/*          if ( a < PHMIN || a > PHMAX ) 
                fprintf(stderr,"invalid paper height %d in .hpscatrc\n", a); 
            else {
                papersize[user].width = papersize[paper].width;
                paper = user;
                papersize[paper].height =   a;         
            }
*/
            papersize[user].width = papersize[paper].width;
            paper = user;
            papersize[paper].height =   a;         
            continue;
        }
        else if(!strcmp(token,"paperwidth")) {
            int  a;
            skipeq();
            gettoken();
            a = a2point(token);
/*          if ( a < PWMIN || a > PWMAX ) 
                fprintf(stderr,"invalid paper width %d in .hpscatrc\n", a); 
            else {
                papersize[user].height = papersize[paper].height;
                paper = user;
                papersize[paper].width =   a;
            }
*/
            papersize[user].height = papersize[paper].height;
            paper = user;
            papersize[paper].width =   a;
            continue;
        }
        else if(!strcmp(token, "min_bot_mar")) {
            int  a;
            skipeq();
            gettoken();
            a = a2point(token);
            if ( a < ABS_MIN_BM ) 
              fprintf(stderr,"invalid min. bottom margin in .hpscatrc\n");
            else 
              min_bm = a;
        }
        else if(!strcmp(token, "min_left_mar")) {
            int  a;
            skipeq();
            gettoken();
            a = a2point(token);
            if ( a < ABS_MIN_LM ) 
              fprintf(stderr,"invalid min. left margin in .hpscatrc\n");
            else 
              min_lm = a;
        } 
        else if(!strcmp(token, "shade_width")) {
            int  a;
            skipeq();
            gettoken();
            a = a2point(token);
/*          if ( a < ABS_MIN_LM ) 
              fprintf(stderr,"invalid min. left margin in .hpscatrc\n");
            else  */
              s_width = a;
        }
        else if(!strcmp(token, "shade_width_nl")) {
            int  a;
            skipeq();
            gettoken();
            a = a2point(token);
/*          if ( a < ABS_MIN_LM ) 
              fprintf(stderr,"invalid min. left margin in .hpscatrc\n");
            else */
              s_width_nl = a;
        }
        else
            fprintf(stderr,"invalid resource `%s' in .hpscatrc\n", token);
    }
}

/* EOF */
