/*
 * html2hdml
 *
 * Coprygight (C) 2000-2003 Dino Co.,Ltd.
 * http://www.dino.co.jp/
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "html2hdml.h"
#include "strinput.h"

#ifdef MOD_HTML2HDML
#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
/* #include "alloc.h" */
#endif

HDMLblock *add_piece(enum hdmloutput output, char *str);
HDMLblock *append_block(HDMLblock *hdml, HDMLblock *block);
int append_varlist(enum hdmloutput output, enum hdmloutput varnum, 
		   int remove_last_amp);
int is_varlist_empty(enum hdmloutput varnum);

HDMLpiece *alloc_HDMLpiece(char *str, int sp_char);
void free_HDMLpiece_list(HDMLpiece *node);

HDMLblock *alloc_HDMLblock(HDMLblock *src);
HDMLblock *init_HDMLblock(HDMLblock *node, HDMLblock *src);

void free_HDMLblock(HDMLblock *node);
void free_HDMLblock_list(enum hdmloutput output);

int print_all(enum hdmloutput output);

#ifdef MOD_HTML2HDML
#define my_puts(s) ap_rputs(s, gl_convertopt.apache_r)
#define my_putchar(c) ap_rputc(c, gl_convertopt.apache_r)
#else
#define my_puts(s) fputs(s, stdout)
#define my_putchar(c) putchar(c)
#endif

HDMLblock *gl_begin;
HDMLblock *gl_header, *gl_header_last;
HDMLblock *gl_body,   *gl_body_last;
HDMLblock *gl_footer, *gl_footer_last;

HDMLblock **gl_current;

HDMLblock *gl_init;
HDMLblock *gl_reset;
HDMLblock *gl_submit;

HDMLblock *gl_title;
HDMLblock *gl_textarea;
HDMLblock *gl_select; /* encoded text for current <option> */

HDMLblock *gl_select_selected; /* encoded text for selected <option> */

int init_hdmlstruct(void)
{
    gl_begin  = alloc_HDMLblock(NULL);
    gl_header = alloc_HDMLblock(NULL);
    gl_body   = alloc_HDMLblock(NULL);
    gl_footer = alloc_HDMLblock(NULL);
    gl_begin->next  = gl_header;
    gl_header->next = gl_body;
    gl_body->next   = gl_footer;
    
    gl_init   = alloc_HDMLblock(NULL);
    gl_submit = alloc_HDMLblock(NULL);
    gl_reset  = alloc_HDMLblock(NULL);

    gl_title    = alloc_HDMLblock(NULL);
    gl_textarea = alloc_HDMLblock(NULL);
    gl_select   = alloc_HDMLblock(NULL);

    gl_current = &gl_body;

    gl_select_selected = alloc_HDMLblock(NULL);

    return 0;
}

extern char *emoji_table[];
extern int set_emoji_table(void);

/* print 2byte imode pict-charactars. */
int print_str(char *str, int sp_char)
{
    unsigned char *p, p1, p2;
    int i;
    static int is_prevchar_ret = 0;

    set_emoji_table();

    p = str;
    while (*p != '\0') {
	if (*p == '\n') {
	    if (!is_prevchar_ret) {
		my_puts(RET_STR);
	    }
	    is_prevchar_ret = 1;
	    p++;
	} else {
	    is_prevchar_ret = 0;
	    if (*p == 0xf8 || *p == 0xf9) {
		/* docomo picture */
		p1 = *p;
		p++;
		if (*p >= 0x40 && *p <= 0xfc) {
		    char *emoji;

		    p2 = *p;
		    p++;

		    i = 0;
		    if (p1 == 0xf8 && (p2 >= 0x9f && p2 <= 0xfc)) {
		      /* f89f(1) - f8fc(94) */
			i = p2 - 0x9f + 1;
		    } else if (p1 == 0xf9) {
			if (p2 >= 0x40 && p2 <= 0x49) {
			  /* f940(95) - f949(104) */
			    i = p2 - 0x40 + 95;
			} else if (p2 >= 0x72 && p2 <= 0x7e) {
			  /* f972(105) - f97e(117) */
			    i = p2 - 0x72 + 105;
			} else if (p2 >= 0x80 && p2 <= 0x90) {
			  /* f980(118) - f990(134) */
			    i = p2 - 0x80 + 118;
			} else if (p2 == 0xb0) {
			  /* f9b0(135) */
			    i = 135;
			} else if (p2 >= 0x91 && p2 <= 0xaf) {
			  /* f991(136) - f9af(166) */
			    i = p2 - 0x91 + 136;
			}
		    }
		    emoji = emoji_table[i];
		    my_puts(emoji);
		}
	    } else if ((*p >= 0x81 && *p <= 0x9f) ||
		       (*p >= 0xe0 && *p <= 0xfc)) {
		/* sjis 1st byte */
		p1 = *p;
		p++;
		if (*p >= 0x40 && *p <= 0xfc) {
		    /* sjis 2nd byte */
		    my_putchar(p1);
		    my_putchar(*p);
		    p++;
		}
	    } else if (sp_char) {
		my_putchar(*p);
		p++;
	    } else {
	      char *str;
	      /* normal text. $ ==> &dol; */
	      if (*p == '$') {
		str = "&dol;";
		my_puts(str);
	      } else {
		my_putchar(*p);
	      }
	      p++;
	    }
	}
    }

    return 0;
}

int print_all(enum hdmloutput output)
{
    HDMLpiece *node, *next;
    HDMLblock *block;
    char *str;

    switch (output) {
      case enum_current:  block = *gl_current;  break;
      case enum_select_selected:  block = gl_select_selected; break;

      case enum_begin:    block = gl_begin;    break;
      case enum_header:   block = gl_header;   break;
      case enum_body:     block = gl_body;     break;
      case enum_footer:   block = gl_footer;   break;

      case enum_init:     block = gl_init;     break;
      case enum_reset:    block = gl_reset;    break;
      case enum_submit:   block = gl_submit;   break;

      case enum_title:    block = gl_title;    break;
      case enum_textarea: block = gl_textarea; break;
      case enum_select:   block = gl_select;   break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return 0;
    }

    while (block) {
	node = block->top;
	while (node) {
	  int sp_char;

	    next = node->next;
	    str = node->str;

	    if (block->remove_last_amp && (next == NULL) &&
		(*(strchr(str, '\0') - 1) == '&')) {

		str = my_strdup(str);
		*(strchr(str, '\0') - 1) = '\0';
		print_str(str, node->including_sp_char);
		my_free(str);
	    } else {
		print_str(str, node->including_sp_char);
	    }
	    node = next;
	}

	block = block->next;
    }

    return 0;
}


HDMLblock *add_piece(enum hdmloutput output, char *str)
{
    HDMLblock *hdml;

    switch (output) {
      case enum_current:  hdml = *gl_current;  break;

      case enum_begin:    hdml = gl_begin;    break;
      case enum_header:   hdml = gl_header;   break;
      case enum_body:     hdml = gl_body;     break;
      case enum_footer:   hdml = gl_footer;   break;

      case enum_init:     hdml = gl_init;     break;
      case enum_reset:    hdml = gl_reset;    break;
      case enum_submit:   hdml = gl_submit;   break;

      case enum_title:    hdml = gl_title;    break;
      case enum_textarea: hdml = gl_textarea; break;
      case enum_select:   hdml = gl_select;   break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return NULL;
    }

    hdml->bottom->next = alloc_HDMLpiece(str, 0);
    hdml->bottom = hdml->bottom->next;
    return NULL;
}

HDMLblock *add_piece_with_sp_char(enum hdmloutput output, char *str)
{
    HDMLblock *hdml;

    switch (output) {
      case enum_current:  hdml = *gl_current;  break;

      case enum_begin:    hdml = gl_begin;    break;
      case enum_header:   hdml = gl_header;   break;
      case enum_body:     hdml = gl_body;     break;
      case enum_footer:   hdml = gl_footer;   break;

      case enum_init:     hdml = gl_init;     break;
      case enum_reset:    hdml = gl_reset;    break;
      case enum_submit:   hdml = gl_submit;   break;

      case enum_title:    hdml = gl_title;    break;
      case enum_textarea: hdml = gl_textarea; break;
      case enum_select:   hdml = gl_select;   break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return NULL;
    }

    hdml->bottom->next = alloc_HDMLpiece(str, 1);
    hdml->bottom = hdml->bottom->next;
    return NULL;
}

/* append varlist and NULL HDMLblock to an HDMLblock */
int append_varlist(enum hdmloutput output, enum hdmloutput varnum, 
		   int remove_last_amp)
{
    HDMLblock *node, *prev;
    HDMLblock *hdml, *varlist;

    switch (output) {
      case enum_begin:  hdml = gl_begin;  break;
      case enum_header: hdml = gl_header; break;
      case enum_body:   hdml = gl_body;   break;
      case enum_footer: hdml = gl_footer; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    switch (varnum) {
      case enum_init:   varlist = gl_init;   break;
      case enum_reset:  varlist = gl_reset;  break;
      case enum_submit: varlist = gl_submit; break;

      case enum_title:  varlist = gl_title;  break;
      case enum_select: varlist = gl_select; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    /* alloc HDMLblock for growing list */
    node = alloc_HDMLblock(varlist);
    node->next = hdml->next;
    hdml->next = node;
    if (varlist->next) {
	varlist->next->dont_free = 1;
    } else {
	varlist->dont_free = 1;
    }
    node->dont_free = 0;
    varlist->next = node;
    node->remove_last_amp = remove_last_amp;

    prev = node;
    /* alloc HDMLblock */
    node = alloc_HDMLblock(NULL);
    node->next = prev->next;
    prev->next = node;

    switch (output) {
      case enum_begin:  gl_begin  = node; break;
      case enum_header: gl_header = node; break;
      case enum_body:   gl_body   = node; break;
      case enum_footer: gl_footer = node; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    return 0;
}

/* duplicate a varlist and concatenate an HDMLblock and the varlist */
int catdup_varlist(enum hdmloutput output, enum hdmloutput varnum)
{
    HDMLblock *hdml, *varlist;
    HDMLpiece *w_node, *r_node;

    switch (output) {
      case enum_begin:  hdml = gl_begin;  break;
      case enum_header: hdml = gl_header; break;
      case enum_body:   hdml = gl_body;   break;
      case enum_footer: hdml = gl_footer; break;

      case enum_init:   hdml = gl_init;   break;
      case enum_reset:  hdml = gl_reset;  break;
      case enum_submit: hdml = gl_submit; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    switch (varnum) {
      case enum_select_selected:   varlist = gl_select_selected;   break;

      case enum_init:     varlist = gl_init;   break;
      case enum_reset:    varlist = gl_reset;  break;
      case enum_submit:   varlist = gl_submit; break;

      case enum_title:    varlist = gl_title;  break;
      case enum_textarea: varlist = gl_textarea; break;
      case enum_select:   varlist = gl_select; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    if (hdml == varlist) return -1;
    if ((hdml == NULL) || (varlist == NULL)) return -1;

    w_node = hdml->bottom;
    r_node = varlist->top;
    while (r_node) {
      /* duplicate one node */
	w_node->next = alloc_HDMLpiece(r_node->str, r_node->including_sp_char);
	r_node = r_node->next;
	w_node = w_node->next;
    }
    switch (output) {
      case enum_begin:  gl_begin->bottom  = w_node; break;
      case enum_header: gl_header->bottom = w_node; break;
      case enum_body:   gl_body->bottom   = w_node; break;
      case enum_footer: gl_footer->bottom = w_node; break;

      case enum_init:   gl_init->bottom   = w_node; break;
      case enum_reset:  gl_reset->bottom  = w_node; break;
      case enum_submit: gl_submit->bottom = w_node; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    return 0;
}

int reset_varlist(enum hdmloutput varnum)
{
    HDMLblock *node;

    switch (varnum) {
      case enum_select_selected:    node = gl_select_selected  ; break;

      case enum_init:     node = gl_init  ;   break;
      case enum_reset:    node = gl_reset ;   break;
      case enum_submit:   node = gl_submit;   break;

      case enum_title:    node = gl_title ;   break;
      case enum_textarea: node = gl_textarea; break;
      case enum_select:   node = gl_select;   break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return -1;
    }

    if (node) {
	if (!node->dont_free) {
	    free_HDMLpiece_list(node->top);
	}
    }
    init_HDMLblock(node, NULL);

    return 0;
}

int is_varlist_empty(enum hdmloutput varnum)
{
    HDMLblock *node;

    switch (varnum) {
      case enum_select_selected:    node = gl_select_selected  ; break;

      case enum_init:    node = gl_init  ; break;
      case enum_reset:   node = gl_reset ; break;
      case enum_submit:  node = gl_submit; break;

      case enum_title:   node = gl_title ; break;
      case enum_select:  node = gl_select; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return 1;

    }
    if (node && node->top && node->top->next) {
	return 0;
    }
    return 1;
}


/* append two HDMLblock for growing list of HDMLpiece */
HDMLblock *append_block(HDMLblock *hdml, HDMLblock *block)
{
    HDMLblock *prev;

    prev = hdml;

    /* alloc HDMLblock for growing list */
    hdml = alloc_HDMLblock(block);
    hdml->next = prev->next;
    prev->next = hdml;

    prev = hdml;
    /* alloc HDMLblock */
    hdml = alloc_HDMLblock(NULL);
    hdml->next = prev->next;
    prev->next = hdml;

    return hdml;
}


HDMLpiece *alloc_HDMLpiece(char *str, int sp_char)
{
    HDMLpiece *node;
    node = (HDMLpiece *)my_malloc(sizeof(HDMLpiece));
    node->next = NULL;
    node->str = my_strdup(str);
    node->including_sp_char = sp_char;

    return node;
}

HDMLblock *init_HDMLblock(HDMLblock *node, HDMLblock *src)
{
    node->remove_last_amp = 0;
    node->dont_free = 0;
    node->next = NULL;
    node->top = NULL;
    node->bottom = NULL;

    if (src) {
	node->top    = src->top;
	node->bottom = src->bottom;
    } else {
	node->top = node->bottom = alloc_HDMLpiece("", 0); /* guard */
    }

    return node;
}

HDMLblock *alloc_HDMLblock(HDMLblock *src)
{
    HDMLblock *node;
    node = (HDMLblock *)my_malloc(sizeof(HDMLblock));
    init_HDMLblock(node, src);

    return node;
}

void free_HDMLpiece(HDMLpiece *node)
{
    my_free(node->str);
    my_free(node);

    return;
}

void free_HDMLpiece_list(HDMLpiece *node)
{
    HDMLpiece *next;

    while (node) {
	next = node->next;
	free_HDMLpiece(node);
	node = next;
    }
    
    return;
}

void free_HDMLblock(HDMLblock *node)
{
    if (node) {
	if (!node->dont_free) {
	    free_HDMLpiece_list(node->top);
	}
	my_free(node);
    }
    return;
}

int is_current_output(enum hdmloutput output)
{
    switch (output) {
      case enum_current: return 1;
      case enum_select_selected: return 0;

      case enum_begin:    return (*gl_current == gl_begin);    break;
      case enum_header:   return (*gl_current == gl_header);   break;
      case enum_body:     return (*gl_current == gl_body);     break;
      case enum_footer:   return (*gl_current == gl_footer);   break;

      case enum_title:    return (*gl_current == gl_title);    break;
      case enum_textarea: return (*gl_current == gl_textarea); break;
      case enum_select:   return (*gl_current == gl_select);   break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return 0;
    }
    return 0;
}

int set_current_output(enum hdmloutput output)
{
    switch (output) {
      case enum_current: return 1;

      case enum_begin:  gl_current = &gl_begin;  break;
      case enum_header: gl_current = &gl_header; break;
      case enum_body:   gl_current = &gl_body;   break;
      case enum_footer: gl_current = &gl_footer; break;

      case enum_title:    gl_current = &gl_title;    break;
      case enum_select:   gl_current = &gl_select;   break;
      case enum_textarea: gl_current = &gl_textarea; break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return 0;

    }
    return 0;
}

int set_select_selected(void)
{
    gl_select_selected->top = gl_select->top;
    gl_select_selected->dont_free = 1;
    /* fprintf(stderr, "%p\n", gl_select); */
    return 0;
}

void free_HDMLblock_list(enum hdmloutput output)
{
    HDMLblock *next;
    HDMLblock *node;

    switch (output) {
      case enum_current:  node = *gl_current;  break;

      case enum_begin:    node = gl_begin;    break;
      case enum_header:   node = gl_header;   break;
      case enum_body:     node = gl_body;     break;
      case enum_footer:   node = gl_footer;   break;

      case enum_init:     node = gl_init;     break;
      case enum_reset:    node = gl_reset;    break;
      case enum_submit:   node = gl_submit;   break;

      case enum_title:    node = gl_title;    break;
      case enum_select:   node = gl_select;   break;

      default:
	fprintf(stderr, "%s:%d internal error\n", __FILE__, __LINE__);
	return;
    }

    while (node) {
	next = node->next;
	free_HDMLblock(node);
	node = next;
    }
    
    return;
}

