/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: AboutDialog.cpp,v 1.24 2004/03/22 12:49:26 comix Exp $
 *
 */

#include "AboutDialog.h"


/**
 * Constructor
 */
AboutDialog::AboutDialog(QWidget* parent) : AboutDialog_UI(parent, 0, false) {
	setCaption( trUtf8( "About" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );

	setMinimumSize( width(), height() );
	setMaximumSize( width(), height() );
	move( 240, 100 );

	QString about;
	about += "<center><b>Hydrogen Drum Machine " + QString(VERSION) + "</b><br>";
	about += trUtf8( "<i>Compiled modules: %1</i></center>").arg(COMPILED_FEATURES);
	about += "<b>HomePage</b><br>";
	about += "<a href=\"http://hydrogen.sf.net\">http://hydrogen.sf.net</a><br><br>";
	about += trUtf8( "<b>Project page</b><br>");
	about += "<a href=\"http://sourceforge.net/projects/hydrogen\">http://sourceforge.net/projects/hydrogen</a><br><br>";
	about += trUtf8( "<b>Mailing lists:</b><br>");
	about += "<a href=\"http://lists.sourceforge.net/lists/listinfo/hydrogen-announce\">http://lists.sourceforge.net/lists/listinfo/hydrogen-announce</a><br>";
	about += "<a href=\"http://lists.sourceforge.net/lists/listinfo/hydrogen-devel\">http://lists.sourceforge.net/lists/listinfo/hydrogen-devel</a><br>";
	aboutTxt->setText( about );

	QString authors;
	authors += trUtf8( "<b>Authors:</b><br>");
	authors += "<p>Alex <comix> Cominu";
	authors += "<i><ul>[comix@users.sourceforge.net]<br>";
	authors += trUtf8( "Maintainer, main coder<br></ul></i></p><br>");
	authors += "<br>";

	authors += "<p>Artemiy Pavlov";
	authors += "<i><ul>[artemio@artemio.net]<br>";
	authors += trUtf8( "Drumkits and demo songs<br></ul></i></p>");
	authors += "<br>";

	authors += "<p>Alexandre Prokoudine";
	authors += trUtf8( "<i><ul>Russian translation<br></ul></i></p><br>");

	authors += "<p>Benjamin Flaming";
	authors += trUtf8( "<i><ul>Jack patches, bug fix<br></ul></i></p><br>");

	authors += "<p>Carlo Impagliazzo aka Truijllo<br>";
	authors += trUtf8( "<i><ul>Testing, ideas..</ul></i></p><br>");

	authors += "<p>Chris Wareham<br>";
	authors += trUtf8( "<i><ul>NetBSD patch</ul></i></p><br>" );

	authors += "<p>Daniel Tonda Castillo<br>";
	authors += trUtf8( "<i><ul>Spanish manual</ul></i></p><br>" );

	authors += "<p>Dave Phillips<br>";
	authors += trUtf8( "<i><ul>Bug reports, ideas</ul></i></p><br>" );

	authors += "<p>Derrick Karpo<br>";
	authors += trUtf8( "<i><ul>Patches, testing</ul></i></p><br>" );

	authors += "<p>Ede Wolf<br>";
	authors += trUtf8( "<i><ul>Faq, testing</ul></i></p><br>" );

	authors += "<p>Emiliano Grilli<br>";
	authors += trUtf8( "<i><ul>Demo songs, testing</ul></i></p><br>" );

	authors += "<p>Francesco Cabras<br>";
	authors += trUtf8( "<i><ul>Patches, testing</ul></i></p><br>" );

	authors += "<p>Jesse Chappel<br>";
	authors += trUtf8( "<i><ul>Jack patches</ul></i></p><br>" );

	authors += "<p>Jonas Melzer<br>";
	authors += trUtf8( "<i><ul>German manual</ul></i></p><br>" );

	authors += "<p>Kevin Dahan aka Unet<br>";
	authors += trUtf8( "<i><ul>French translation</ul></i></p><br>" );

	authors += "<p>Samuel Mimram<br>";
	authors += trUtf8( "<i><ul>Packages</ul></i></p><br>" );

	authors += "<p>Sergio Gil Perez de la Manga<br>";
	authors += trUtf8( "<i><ul>Spanish translation</ul></i></p><br>" );

	authors += "<p>Sors0<br>";
	authors += trUtf8( "<i><ul>Italian manual</ul></i></p><br>" );
	
	authors += "<p>Torben Hohn<br>";
	authors += trUtf8( "<i><ul>Bug fix, test</ul></i></p><br>" );
	

	authorsTxt->setText( trUtf8( authors ) );

	string logo_path = IMG_PATH;
	logo_path.append("/img/about/aboutLogo.png");

	logoLabel->setPixmap(QPixmap(logo_path.c_str()));
}




/**
 * Destructor
 */
AboutDialog::~AboutDialog() {
}




/**
 * Close the dialog
 */
void AboutDialog::okBtnClicked() {
	accept();
}


