/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: FLACFile.cpp,v 1.5 2004/05/07 11:38:16 comix Exp $
 *
 */

#include "FLACFile.h"

#include <vector>
#include <fstream>

//#include "FLAC/file_decoder.h"
#include <FLAC++/all.h>


/// Reads a FLAC file...not optimized yet
class FLACFile_real : public FLAC::Decoder::File, public Object
{
	public:
		FLACFile_real();
		~FLACFile_real();

		void load( string filename );
		Sample* getSample();
		
	protected:
		virtual ::FLAC__StreamDecoderWriteStatus write_callback(const ::FLAC__Frame *frame, const FLAC__int32 * const buffer[]);
		virtual void metadata_callback(const ::FLAC__StreamMetadata *metadata);
		virtual void error_callback(::FLAC__StreamDecoderErrorStatus status);

	private:
		std::vector<FLAC__int32> m_audioVect_L;
		std::vector<FLAC__int32> m_audioVect_R;
		string m_sFilename;
};



FLACFile_real::FLACFile_real() : Object( "FLACFile_real" )
{
//	infoLog( "INIT" );
}



FLACFile_real::~FLACFile_real()
{
//	infoLog( "DESTROY" );
}



::FLAC__StreamDecoderWriteStatus FLACFile_real::write_callback(const ::FLAC__Frame *frame, const FLAC__int32 * const buffer[])
{
//	int nSampleRate = get_sample_rate();
	int nChannelCount = get_channels();
	int nBits = get_bits_per_sample();
	
	/// \todo verificare che le proprieta' vadano bene
	
	if (nBits != 16) {
		errorLog( "[write_callback] Only 16bit audio supported. nBits=" + toString( nBits ) );
	}

	if ( (nChannelCount != 1 ) && (nChannelCount != 2) ) {
		errorLog( "[write_callback] wrong number of channels. nChannelCount=" + toString( nChannelCount) );
		return FLAC__STREAM_DECODER_WRITE_STATUS_ABORT;
	}
	
	uint nFrames = frame->header.blocksize;
	
	if (nChannelCount == 1) {	// mono
		const FLAC__int32* data = buffer[0];

		for ( uint i = 0; i < nFrames; i++) {
			m_audioVect_L.push_back( data[i] );
			m_audioVect_R.push_back( data[i] );
		}
	}
	else {	// stereo
		const FLAC__int32* data_L = buffer[0];

		for ( uint i = 0; i < nFrames; i++) {
			m_audioVect_L.push_back( data_L[i] );
		}
	
		const FLAC__int32* data_R = buffer[1];

		for ( uint i = 0; i < nFrames; i++) {
			m_audioVect_R.push_back( data_R[i] );
		}
	}
	
/*
	// da convertire in mono/ stereo
	for ( int nChannel = 0; nChannel < channelCount; nChannel++ ) {
		FLAC__int32 *data = buffer[nChannel];
		
		if(bitRate==16) {
			for( unsigned i = 0; i < sampleframes_read; i++ ) {
				m_audioVect.pushBack( data[i] );
			}
		}
		else {
			errorLog( "[write_callback] bits != 16" );
		}
	}
*/	
	return FLAC__STREAM_DECODER_WRITE_STATUS_CONTINUE;
}



void FLACFile_real::metadata_callback(const ::FLAC__StreamMetadata *metadata)
{
}



void FLACFile_real::error_callback(::FLAC__StreamDecoderErrorStatus status)
{
	infoLog( "[error_callback]" );
}



void FLACFile_real::load( string sFilename )
{
	//infoLog( "[load]" );
	m_sFilename = sFilename;
	
	// file exists?
	std::ifstream input(sFilename.c_str() , std::ios::in | std::ios::binary);
	if (!input){
		errorLog( "[load] file " + sFilename + " not found." );
		return;
	}
	else {
		/// \todo: devo chiudere il file?
	}

	
	set_metadata_ignore_all();
	set_filename( sFilename.c_str() );
	
	State s=init();
	if( s != FLAC__FILE_DECODER_OK ) {
		errorLog( "[load] Error in init()" );
	}
	
	if ( process_until_end_of_file() == false ) {
		errorLog( "[load] Error in process_until_end_of_file()" );
	}
}



Sample* FLACFile_real::getSample() 
{
	//infoLog( "[getSample]" );
	Sample *pSample = NULL;
	
	int nFrames = m_audioVect_L.size();
	float *data_L = new float[nFrames];
	float *data_R = new float[nFrames];
	
	for (long i = 0; i < nFrames; i++) {
		data_L[ i ] = ( (float)m_audioVect_L[ i ] ) / 36768.0;
		data_R[ i ] = ( (float)m_audioVect_R[ i ] ) / 36768.0;
	}
	
	pSample = new Sample(nFrames, m_sFilename );
	pSample->setData_L( data_L );
	pSample->setData_R( data_R );
	
	return pSample;
}

// :::::::::::::::::::::::::::::




FLACFile::FLACFile() : Object( "FLACFile" )
{
	//infoLog( "INIT" );
}


FLACFile::~FLACFile()
{
	//infoLog( "DESTROY" );
}



Sample* FLACFile::load( string sFilename )
{
	//infoLog( "[load] " + sFilename );
	
	FLACFile_real *pFile = new FLACFile_real();
	pFile->load( sFilename );
	Sample *pSample = pFile->getSample();
	delete pFile;
	
	return pSample;
}




