/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: DiskWriterDriver.cpp,v 1.2 2004/05/26 14:10:54 comix Exp $
 *
 */
#include "DiskWriterDriver.h"

#include "../PreferencesMng.h"



DiskWriterDriver::DiskWriterDriver(audioProcessCallback processCallback)
 : GenericDriver( "DiskWriterDriver" )
 , m_processCallback( processCallback )
{
	infoLog("INIT");
}



DiskWriterDriver::~DiskWriterDriver() {
	infoLog("DESTROY");
}



int DiskWriterDriver::init(uint nBufferSize)
{
	infoLog( "init, " + toString(nBufferSize) + " samples" );

	m_nBufferSize = nBufferSize;
	m_pOut_L = new float[nBufferSize];
	m_pOut_R = new float[nBufferSize];

	return 0;
}



///
/// Connect
/// return 0: Ok
///
int DiskWriterDriver::connect() {
	infoLog( "[connect]" );
	PreferencesMng *pPref = PreferencesMng::getInstance();

// 	// always rolling, no user interaction
	m_transport.m_status = TransportInfo::ROLLING;

	int nSampleRate = pPref->getSampleRate();
/*
	int nBits = 16;

	// File Open
	AFfilesetup outputSetup = afNewFileSetup();
	afInitFileFormat(outputSetup, AF_FILE_WAVE);
	afInitSampleFormat (outputSetup, AF_DEFAULT_TRACK, AF_SAMPFMT_TWOSCOMP, nBits);
	afInitRate(outputSetup, AF_DEFAULT_TRACK, nSampleRate);
	afInitChannels(outputSetup, AF_DEFAULT_TRACK, 2);

	outputFile = afOpenFile(m_sFilename.c_str(), "w", outputSetup);

	afFreeFileSetup(outputSetup);

#if defined(i386) || defined(alpha)
	afSetVirtualByteOrder(outputFile, AF_DEFAULT_TRACK, AF_BYTEORDER_LITTLEENDIAN);
#else
	afSetVirtualByteOrder(outputFile, AF_DEFAULT_TRACK, AF_BYTEORDER_BIGENDIAN);
#endif

	short *pSaveBuffer = new short[ m_nBufferSize * 2 ];

	while ( m_processCallback( m_nBufferSize, NULL ) == 0 ) {
		// process...
		for (uint i = 0; i < m_nBufferSize; i++) {
			pSaveBuffer[i * 2] = (short)( m_pOut_L[i] * 32768.0 );
			pSaveBuffer[i * 2 + 1] = (short)( m_pOut_R[i] * 32768.0 );
		}
		afWriteFrames( outputFile, AF_DEFAULT_TRACK, pSaveBuffer, m_nBufferSize);

		if ((m_transport.m_nFrames % 65536) == 0) {
			infoLog( "frames: " + toString(m_transport.m_nFrames) );
		}
	}

	delete[] pSaveBuffer;
	pSaveBuffer = NULL;
*/


	SF_INFO soundInfo;
	soundInfo.samplerate = nSampleRate;	/// \todo questo andra' deciso nella finestra di dialogo
//	soundInfo.frames = -1;//getNFrames();		///\todo: da terminare
	soundInfo.channels = 2;
	soundInfo.format = SF_FORMAT_WAV | SF_FORMAT_PCM_16;

	if ( !sf_format_check( &soundInfo ) ) {
		errorLog( "[connect] error in soundInfo" );
		return -1;
	}

	m_file = sf_open( m_sFilename.c_str(), SFM_WRITE, &soundInfo );


	float *pData = new float[ m_nBufferSize * 2 ];	// always stereo
	while ( m_processCallback( m_nBufferSize, NULL ) == 0 ) {
		// process...
		for (uint i = 0; i < m_nBufferSize; i++) {
			pData[i * 2] = m_pOut_L[i];
			pData[i * 2 + 1] = m_pOut_R[i];
		}
		int res = sf_writef_float( m_file, pData, m_nBufferSize );
		if (res != (int)m_nBufferSize ) {
			errorLog( "[connect] error during sf_write_float" );
		}

		if ((m_transport.m_nFrames % 65536) == 0) {
			infoLog( "frames: " + toString(m_transport.m_nFrames) );
		}
	}

	delete[] pData;
	pData = NULL;


	return 0;
}



/// disconnect
void DiskWriterDriver::disconnect() {
	infoLog( "[disconnect]" );

	sf_close( m_file );

//	afCloseFile(outputFile);

	delete[] m_pOut_L;
	m_pOut_L = NULL;

	delete[] m_pOut_R;
	m_pOut_R = NULL;
}



uint DiskWriterDriver::getSampleRate() {
	PreferencesMng *preferencesMng = PreferencesMng::getInstance();
	return preferencesMng->getSampleRate();
}



void DiskWriterDriver::play()
{
	m_transport.m_status = TransportInfo::ROLLING;
}



void DiskWriterDriver::stop()
{
	m_transport.m_status = TransportInfo::STOPPED;
}



void DiskWriterDriver::locate( unsigned long nFrame )
{
	infoLog( "[locate] " + toString(nFrame) );
	m_transport.m_nFrames = nFrame;
}



void DiskWriterDriver::updateTransportInfo()
{
//	errorLog( "[updateTransportInfo] not implemented yet" );
	// not used
}



void DiskWriterDriver::setBpm(float fBPM)
{
	infoLog( "[setBpm] " + toString(fBPM) );
	m_transport.m_nBPM = fBPM;
}


