#include "SMFEvent.h"



void SMFBuffer::writeByte( short int nByte )
{
//	infoLog( "[writeByte] " + toString( nByte ) );
	m_buffer.push_back( nByte );
}



void SMFBuffer::writeWord( int nVal )
{
//	infoLog( "writeWord" );
	writeByte( nVal >> 8 );
	writeByte( nVal );
}



void SMFBuffer::writeDWord( long nVal )
{
	writeByte( nVal >> 24 );
	writeByte( nVal >> 16 );	
	writeByte( nVal >> 8 );
	writeByte( nVal );
}



void SMFBuffer::writeString( std::string sMsg )
{
//	infoLog( "writeString" );
	writeVarLen( sMsg.length() );
	
	for (uint i = 0; i < sMsg.length(); i++) {
		writeByte( sMsg.c_str()[ i ] );
	}
}



void SMFBuffer::writeVarLen( long value )
{
//	infoLog( "[writeVarLen]" );
	long buffer;
	buffer = value & 0x7f;
	while ( ( value >>= 7 ) > 0 ) {
		infoLog( "." );
		buffer <<= 8;
		buffer |= 0x80;
		buffer += ( value & 0x7f );
	}
	
	while ( true ) {
//		putc( buffer, outfile );
		writeByte( (char)buffer );
		if ( buffer & 0x80 ) {
			buffer >>= 8;
		}
		else {
			break;
		}
	}
}


// ::::::::::::::::::

SMFTrackNameMetaEvent::SMFTrackNameMetaEvent( std::string sTrackName, unsigned nDeltaTime )
 : SMFEvent( "SMFTrackNameMetaEvent", nDeltaTime )
 , m_sTrackName( sTrackName )
{
	
}


std::vector<char> SMFTrackNameMetaEvent::getBuffer()
{
	SMFBuffer buf;
	buf.writeVarLen( m_nDeltaTime );
	buf.writeByte( 0xFF );
	buf.writeByte( TRACK_NAME );
	buf.writeString( m_sTrackName );

	return buf.getBuffer();
}


// :::::::::::::


SMFEvent::SMFEvent( std::string sEventName, unsigned nDeltaTime )
 : Object( sEventName )
 , m_nDeltaTime( nDeltaTime )
{
	infoLog( "INIT" );
}



SMFEvent::~SMFEvent()
{
	infoLog( "DESTROY" );
}


// ::::::::::::::


SMFNoteOnEvent::SMFNoteOnEvent( unsigned nDeltaTime, int nChannel, int nPitch, int nVelocity )
 : SMFEvent( "SMFNoteOnEvent", nDeltaTime )
 , m_nChannel( nChannel )
 , m_nPitch( nPitch )
 , m_nVelocity( nVelocity )
{
	if ( nChannel >= 16 ) {
		errorLog( "[SMFNoteOnEvent] nChannel >= 16! nChannel=" + toString(nChannel) );
	}
}



std::vector<char> SMFNoteOnEvent::getBuffer()
{
	SMFBuffer buf;
	buf.writeVarLen( m_nDeltaTime );
	buf.writeByte( NOTE_ON + m_nChannel );
	buf.writeByte( m_nPitch );
	buf.writeByte( m_nVelocity );

	return buf.getBuffer();
}


// :::::::::::



SMFNoteOffEvent::SMFNoteOffEvent( unsigned nDeltaTime, int nChannel, int nPitch, int nVelocity )
 : SMFEvent( "SMFNoteOffEvent", nDeltaTime )
 , m_nChannel( nChannel )
 , m_nPitch( nPitch )
 , m_nVelocity( nVelocity )
{
	if ( nChannel >= 16 ) {
		errorLog( "[SMFNoteOffEvent] nChannel >= 16! nChannel=" + toString(nChannel) );
	}
}



std::vector<char> SMFNoteOffEvent::getBuffer()
{
	SMFBuffer buf;
	buf.writeVarLen( m_nDeltaTime );
	buf.writeByte( NOTE_OFF + m_nChannel );
	buf.writeByte( m_nPitch );
	buf.writeByte( m_nVelocity );

	return buf.getBuffer();
}

