//	MidiPlayer.cpp
//	13/aprile/2000	>>CoMiX<<

#include "midiplayer.h"
#include "mmtimer.h"

#define VUOTO -1

//*********************************************************************



//----------------------------------------------------------------------
CMidiPlayer::CMidiPlayer()			//ctor
//----------------------------------------------------------------------
{
	PlayPos=0;	//posizione
	
	for (int I=0; I<MAX_TRACCE; I++)	Mute[0]=false;

}




//----------------------------------------------------------------------
int CMidiPlayer::ApriMidi()
//----------------------------------------------------------------------
{
int Err=0;

Err = midiOutOpen (&hMidi,
				   -1,	//numero device, -1 MIDIMAPPER
				   NULL,
				   NULL,
				   NULL
				   );
if (Err) return 1;
return 0;
}




//----------------------------------------------------------------------
int CMidiPlayer::ChiudiMidi()
//----------------------------------------------------------------------
{
int Err=0;

Err = midiOutClose (hMidi);
if (Err) return 1;
return 0;
}





//----------------------------------------------------------------------
void CMidiPlayer::NewTick()
//----------------------------------------------------------------------
{
	bool isFinita=false;
	int nTracce;

	PlayPos += (SMFReader.Header.TPQN/32);	//risoluzione: 128'
	
	nTracce=SMFReader.Header.nTracce;

	//leggi un nuovo evento per tutte le tracce, quando il buffer e' vuoto!
	for (int I=0; I<nTracce; I++)
	{
		isFinita = false;

		while ( (NextEvent[I].Tipo == VUOTO) && (!isFinita) )
		{
			NextEvent[I] = SMFReader.pTraccia[I]->GetEv();
			if (NextEvent[I].Tipo == VUOTO) 
			{
				isFinita=true;	//se e' ancora vuoto e' finita la traccia
				continue;
			}

			//toglie gli eventi non suonabili!			
			if ((NextEvent[I].Tipo <NOTE_OFF) || (NextEvent[I].Tipo> PITCH_WHEEL+16) )
				NextEvent[I].Tipo=VUOTO;


			//qui arriva o vuoto o suonabile!
			if ( (NextEvent[I].Tipo!=VUOTO) && (PlayPos >= NextEvent[I].Pos) )
			{
				Play_Note_Ev (NextEvent[I]);
				NextEvent[I].Tipo=VUOTO;
			}
		}

		//qui arriva o vuoto o suonabile!
		if ( (NextEvent[I].Tipo!=VUOTO) && (PlayPos >= NextEvent[I].Pos) )
		{
			Play_Note_Ev (NextEvent[I]);
			NextEvent[I].Tipo=VUOTO;
		}

	}
}




//----------------------------------------------------------------------
int CMidiPlayer::Play_Note_Ev (CEvent &Ev)
//----------------------------------------------------------------------
{
	//filtro mute!!!
	if (Mute[Ev.Canale]==true) return 0;

	
	//if ((Ev.Tipo <NOTE_OFF) || (Ev.Tipo> PITCH_WHEEL+16) ) return 1;
	

	midiOutShortMsg (hMidi, ( Ev.Tipo + (Ev.Data1<<8) + (Ev.Data2<<16) + Ev.Canale ));
	//if (midiOutShortMsg (hMidi, MSG)) return 1;
	
return 0;
}



//----------------------------------------------------------------------
int CMidiPlayer::Play()
//----------------------------------------------------------------------
{
	CercaDurata();
	int Bpm=0;
	Bpm = SMFReader.pTraccia[0]->BPM/1000;
	Bpm = Bpm/32;

	PlayPos=0;
	if (SetTimer (Bpm , 10)) return 1;
return 0;
}


//----------------------------------------------------------------------
int CMidiPlayer::Stop()
//----------------------------------------------------------------------
{
	KillTimer();
return 0;
}


//----------------------------------------------------------------------
void CMidiPlayer::CercaDurata()
//----------------------------------------------------------------------
{
	POSIZIONE NuovaPos=0;
	CEvent Ev;
	long Ultimo=0;

	for (int I=0; I<SMFReader.Header.nTracce; I++)
	{
			Ultimo= SMFReader.pTraccia[I]->nEventi;
			if (Ultimo)
			{
				
				Ev = SMFReader.pTraccia[I]->Sequenza[Ultimo-1];
				NuovaPos = Ev.Pos;
				if (NuovaPos>Durata) Durata=NuovaPos;
				Ev.Pos=5780;
			}
		
	}
}


//*********************************************************************