//	MidiPlayer.h
//	13/aprile/2000
#ifndef _MIDIPLAYER_H
#define _MIDIPLAYER_H

#include <windows.h>
#include <mmsystem.h>
#include "SMFReader.h"

#define MAX_TRACCE 50

class CMidiPlayer
{
public:
	CMidiPlayer(); 
	~CMidiPlayer() {}

	int ApriMidi();			//apre il midi out
	int ChiudiMidi();		//chiude il midi out
	
	int Play();
	int Stop();

	
	void CercaDurata();
	void NewTick();			//avanza di un tick. Viene richiamato dal timer

	CSMF SMFReader;

	bool Mute[MAX_TRACCE];

	POSIZIONE PlayPos;		//player position
	POSIZIONE Durata;

private:
	HMIDIOUT hMidi;

	CEvent NextEvent[MAX_TRACCE];		//prossimo evento da suonare.   Massimo 50 tracce separate!

	int Play_Note_Ev (CEvent &Ev);


};



#endif