//	SMFReader.cpp
//	13/aprile/2000	>>CoMiX<<
#include "SMFReader.h"

#include <iostream.h>
#include <string.h>



//********************************************************************
//							CBASE
//********************************************************************

FILE* CBase::HandleFile;	//definizione per variabile static!!!


//-------------------------------------------------------------------
int CBase::LeggiStringa (char *Str)
//-------------------------------------------------------------------
{
	int     Length=0,
			I=0;

	Length = LeggiByte();
	if (Length>=MAX_STRING-1)
	{
		cout << "stringa overflow"<<endl;
		return 1;
	}
	for ( I=0; I < Length; I++)
		Str[I]=(char)LeggiByte();
        
	Str[I]='\0';
	return 0;
}


//--------------------------------------------------------------------
unsigned int CBase::LeggiByte()
{
	int Temp=0;
		
	fread (&Temp,1,1,HandleFile);
	
	return Temp;
}

//--------------------------------------------------------------------
unsigned int CBase::LeggiWord()
{
	int Temp=0;
	Temp  = LeggiByte() << 8;
	Temp += LeggiByte();
	
	return Temp;
}

//--------------------------------------------------------------------
unsigned long CBase::LeggiDWord ()
{
	unsigned long Temp=0;
	Temp  = LeggiByte() << 24;
	Temp += LeggiByte() << 16;
	Temp += LeggiByte() << 8;
	Temp += LeggiByte();
	
	return Temp;
}



//----------------------------------------------------------------------
unsigned long CBase::LeggiDelta ()
//----------------------------------------------------------------------
// legge il valore di delta time in variable-length-mode
//
{
unsigned long n = 0;
int i = 0, c;

  for (i = 0; i < 4; i++)
  {
    c = LeggiByte();
    if (c < 0) return 0;

    n = (n << 7) + (c & 0x7f);
    if ((c & 0x80) == 0)
      break;
  }
  return n;
}





//----------------------------------------------------------------------
void CBase::ScriviByte (short int Byte)
//----------------------------------------------------------------------
{
	fwrite (&Byte,1,1,HandleFile);
}

//----------------------------------------------------------------------
void CBase::ScriviWord (int Word)
//----------------------------------------------------------------------
{
	ScriviByte (Word >> 8);
	ScriviByte (Word);
}


//----------------------------------------------------------------------
void CBase::ScriviDWord (long DWord)
//----------------------------------------------------------------------
{
	ScriviByte (DWord >> 24);
	ScriviByte (DWord >> 16);	
	ScriviByte (DWord >> 8 );	
	ScriviByte (DWord);	
}

//----------------------------------------------------------------------
void CBase::ScriviStringa (char *Str)
//----------------------------------------------------------------------
{
/*
	int     Length=0,
			I=0;

	Length = LeggiByte();
	if (Length>=MAX_STRING-1)
	{
		cout << "stringa overflow"<<endl;
		return 1;
	}
	for ( I=0; I < Length; I++)
		Str[I]=(char)LeggiByte();
        
	Str[I]='\0';
*/
	for (int Length=0; Str[Length]; Length++);


	ScriviByte (Length);	//lunghezza stringa
	
	int I=0;
	while (Str[I])
		ScriviByte (Str[I++]);

}

//----------------------------------------------------------------------
void CBase::ScriviDelta (POSIZIONE Delta)
//----------------------------------------------------------------------
{

}



//***********************************************************************











//*********************************************************************
//							CHEADER                -- OK --
//*********************************************************************

//--------------------------------------------------------------------
CHeader::CHeader()	//ctor
{
	Formato = -1;
	nTracce = -1;
	TPQN = -1;
}


//--------------------------------------------------------------------
int CHeader::Leggi()
//--------------------------------------------------------------------
// Err 1: File non ancora aperto!!
// Err 2: Non trovo MThd
// Err 3: Lunghezza header strana
{
	unsigned long Temp=0;
	
	if (!HandleFile) return 1;

	if ( (LeggiDWord())!= 1297377380 ) return 2; //MThd
	if ( (LeggiDWord())!=6 ) return 3;	//0006
	
	Formato = LeggiWord();
	nTracce =LeggiWord();
	TPQN = LeggiWord();
	
	return 0;
}


//--------------------------------------------------------------------
int CHeader::Scrivi()
//--------------------------------------------------------------------
//	Err 1: File non ancora aperto
{

	if (!HandleFile) return 1;
	ScriviDWord (1297377380);	//MThd
	ScriviDWord (6);	//0006

	ScriviWord (Formato);	//formato
	ScriviWord (nTracce);	//numero tracce
	ScriviWord (TPQN);		//ticks per quarter note

return 0;
}

//************************************************************************







//********************************************************************************
//							CEVENT
//********************************************************************************


//----------------------------------------------------------------------------------
CEvent::CEvent()
//----------------------------------------------------------------------------------
{
Canale=0;
Data1=0;
Data2=0;
Pos=0;  //azzera la posizione delta-time
Tipo=-1;

//strcpy (Str,"");
}


//**************************************************************************














//**********************************************************************
//							CTRACK
//**********************************************************************

//--------------------------------------------------------------------
CTrack::CTrack()	//ctor
{
	nEventi=0;
	OldEv=0;
	TrackLen=0;
	BPM = 0;
	CurPos=0;
	isTracciaFinita=false;
	CurDelta=0;

}



//--------------------------------------------------------------------
CTrack::~CTrack()	//dtor
{
	Sequenza.clear();
}

//----------------------------------------------------------------------
int CTrack::LeggiNoteOff (POSIZIONE Delta, int Canale)
{
	CEvent NOff;
	
	CurDelta +=Delta;

	NOff.Tipo = NOTE_OFF;
	NOff.Canale = Canale;
	NOff.Data1 = LeggiByte();	//nota
	NOff.Data2 = LeggiByte();	//velocity
	NOff.Pos = CurDelta;

	AddEv (NOff);
	return 0;
}


//----------------------------------------------------------------------
int CTrack::LeggiNoteOn (POSIZIONE Delta, int Canale)
{
	CEvent NOn;
	
	CurDelta +=Delta;

	NOn.Tipo = NOTE_ON;
	NOn.Canale = Canale;
	NOn.Data1 = LeggiByte();	//nota
	NOn.Data2 = LeggiByte();	//velocity
	NOn.Pos = CurDelta;

	AddEv (NOn);

	return 0;
}


//----------------------------------------------------------------------
int CTrack::LeggiKeyAfterTouch (POSIZIONE Delta, int Canale)
{
	CEvent KAT;

	CurDelta +=Delta;

	KAT.Tipo = KEY_AFTER_TOUCH;
	KAT.Canale = Canale;
	KAT.Data1 = LeggiByte();	//nota
	KAT.Data2 = LeggiByte();	//vel
	KAT.Pos = CurDelta;

	AddEv (KAT);
	return 0;
}

//----------------------------------------------------------------------
int CTrack::LeggiControlChange (POSIZIONE Delta, int Canale)
{
	CEvent CC;

	CurDelta += Delta;

	CC.Tipo = CONTROL_CHANGE;
	CC.Canale = Canale;
	CC.Data1 = LeggiByte();		//controller number
	CC.Data2 = LeggiByte();		//valore
	CC.Pos = CurDelta;

	AddEv (CC);
	return 0;
}



//----------------------------------------------------------------------
int CTrack::LeggiProgramChange (POSIZIONE Delta, int Canale)
{
	CEvent PC;
	
	CurDelta +=Delta;

	PC.Tipo = PROGRAM_CHANGE;
	PC.Canale = Canale;
	PC.Data1 = LeggiByte();		//numero patch
	PC.Pos = CurDelta;

	AddEv (PC);
	return 0;
}



//----------------------------------------------------------------------
int CTrack::LeggiChannelAfterTouch (POSIZIONE Delta, int Canale)
{
	CEvent CAT;

	CurDelta +=Delta;

	CAT.Tipo = CHANNEL_AFTER_TOUCH;
	CAT.Canale = Canale;
	CAT.Data1 = LeggiByte();	//Channel Number
	CAT.Pos = CurDelta;

	AddEv (CAT);
	return 0;
}


//----------------------------------------------------------------------
int CTrack::LeggiPitchWheel (POSIZIONE Delta, int Canale)
{
	CEvent PW;

	CurDelta +=Delta;

	PW.Tipo = PITCH_WHEEL;
	PW.Canale = Canale;
	PW.Data1 = LeggiByte();		//LSB
	PW.Data2 = LeggiByte();		//MSB
	PW.Pos = CurDelta;

	AddEv (PW);
	return 0;
}




//--------------------------------------------------------------------
int CTrack::AddEv(CEvent &NewEvent)
{
	
	Sequenza.push_back (NewEvent);
	nEventi= Sequenza.size();

return 0;
}



//-------------------------------------------------------------------------
CEvent CTrack::GetEv()
{
	if (CurPos<Sequenza.size())
		return Sequenza[CurPos++];
	
	CEvent Vuoto;
	return Vuoto;
}




//----------------------------------------------------------------------
int CTrack::LeggiMetaEv (POSIZIONE Delta)
//----------------------------------------------------------------------
{
	CEvent	Evento;
	unsigned long Temp=0;

	switch (Temp=LeggiByte())
	{
        case TEXT_EVENT:
			{
				Evento.Tipo = TEXT_EVENT;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
				break;
			}

        case COPYRIGHT_INFO:
			{
				Evento.Tipo = COPYRIGHT_INFO;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
			break;
			}

		case TRACK_NAME:
			{
				Evento.Tipo = TRACK_NAME;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
			break;
			}

        case INSTRUMENT_NAME:
			{
				Evento.Tipo = INSTRUMENT_NAME;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
			break;
			}

        case LYRIC:
			{
				Evento.Tipo = LYRIC;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
			break;
			}

        case MARKER:
			{
				Evento.Tipo = MARKER;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
			break;
			}

        case CUE_POINT:
			{
				Evento.Tipo = CUE_POINT;
				CurDelta += Delta;
				Evento.Pos = CurDelta;
				LeggiStringa (Evento.Str);
				AddEv (Evento);
			break;
			}

		case TRACK_SEQ_NUMBER:	//da fare...
			{
				Evento.Tipo = TRACK_SEQ_NUMBER;
				LeggiByte();
				LeggiByte();
				LeggiByte();

			break;
			}

        case TIME_SIGNATURE:
			{
				Evento.Tipo = TIME_SIGNATURE;

				LeggiByte(); //lunghezza dati=4
                Evento.Data1 = LeggiByte(); //numeratore

                Temp = LeggiByte();
                if (Temp == 1) Evento.Data2 = 2;
                else if (Temp == 2) Evento.Data2 = 4;
                else if (Temp == 3) Evento.Data2 = 8;
                else if (Temp == 4) Evento.Data2 = 16;

                LeggiByte();	//nticksperclick
				LeggiByte();	//n32perquarto
			break;
			}

        case SMPTE_EV:		//ignorato
			{
				Evento.Tipo = SMPTE_EV;
				LeggiByte();	//lunghezza dati

				LeggiByte();
				LeggiByte();
				LeggiByte();
				LeggiByte();
				LeggiByte();

			break;
			}
		
		
		case SET_TEMPO:
			{
                LeggiByte();	//lunghezza dati...
				BPM= LeggiByte() << 16;
                BPM+= LeggiByte() << 8;
                BPM+= LeggiByte();
 
			break;
			}

        case KEY_SIGNATURE:        //tonalita'   ---da fare---
            {
				LeggiByte();
				LeggiByte();
				LeggiByte();

				break;
			}

        case 47:	//fine traccia
			{
				LeggiByte();	//boh  = 0
				isTracciaFinita=true;
				break;
			}

		case SYSEX1:				//SYSEX1 viene ignorato
			{
				Temp = LeggiByte();
				for (unsigned int I=0; I<Temp; I++)
				{
					LeggiByte();
				}
			break;
			}


		
		case STRANO1:	//boooooooooooooooh
			{
				LeggiByte();
				LeggiByte();
				break;
			}

		case STRANO2:	//booooooooooh
			{
				LeggiByte();
				LeggiByte();
				break;
			}


		default:
			//cout<<"**** Meta event sconosciuto: " << Temp <<endl;
			return 1;
	}
		
	return 0;
}

//----------------------------------------------------------------------
int CTrack::Leggi()
//----------------------------------------------------------------------
// Err 1: Non trovo l'id di 4 caratteri valido (MTrk)
// Err 2: "mi sono incasinato!!!!"
{
	unsigned long Temp=0;
	unsigned long Delta=0;

	if ( (LeggiDWord()) != 1297379947) return 1;// MTrk
	TrackLen = LeggiDWord();	//lunghezza in byte della traccia!
	
	
	while (!isTracciaFinita)
	{
		Delta = LeggiDelta();

		Temp = LeggiByte();

		if (Temp <=127)	//running status   bastardo!!!!
		{
			Temp = OldEv;	//si riutilizza il precedente evento...
		
			//si torna indietro il puntatore al file...
			fpos_t filepos;
			fgetpos(HandleFile, &filepos);
			filepos--;
			fsetpos(HandleFile, &filepos);
		}
		
		OldEv = Temp;
		
		if (Temp==255)	LeggiMetaEv (Delta);	//meta event
		else if ( (Temp>=NOTE_OFF) && (Temp < NOTE_ON) )					LeggiNoteOff (Delta, Temp - NOTE_OFF);
		else if ( (Temp>=NOTE_ON) && (Temp < KEY_AFTER_TOUCH) )				LeggiNoteOn (Delta, Temp - NOTE_ON);
		else if ( (Temp >= KEY_AFTER_TOUCH) && (Temp < CONTROL_CHANGE) )	LeggiKeyAfterTouch (Delta, Temp - KEY_AFTER_TOUCH);
		else if ( (Temp >= CONTROL_CHANGE) && (Temp < PROGRAM_CHANGE) )		LeggiControlChange (Delta, Temp - CONTROL_CHANGE);
		else if ( (Temp >= PROGRAM_CHANGE) && (Temp < CHANNEL_AFTER_TOUCH) )LeggiProgramChange (Delta, Temp - PROGRAM_CHANGE);
		else if ( (Temp >= CHANNEL_AFTER_TOUCH) && (Temp < PITCH_WHEEL) )	LeggiChannelAfterTouch (Delta, Temp - CHANNEL_AFTER_TOUCH);
		else if ( (Temp >= PITCH_WHEEL) && (Temp < PITCH_WHEEL+16) )		LeggiPitchWheel (Delta, Temp - PITCH_WHEEL);

		else if ( Temp == SYSEX2)	//capita....
		{
			Temp= LeggiByte();
				while(1)
				{
					if ((LeggiByte())==247) break;
				}
		}



		else 
		{
			cout<<"**** mi sono incasinato!  "<< Temp <<endl;
			return 2;
		}
	}
	


	return 0;
}

//----------------------------------------------------------------------
int CTrack::ScriviMetaEv(CEvent &Ev)	
//----------------------------------------------------------------------
{
	switch (Ev.Tipo)
	{
	case TRACK_SEQ_NUMBER:	//da fare
		ScriviStringa (Ev.Str);
		break;

	case TEXT_EVENT:
		ScriviStringa (Ev.Str);
		break;

	case COPYRIGHT_INFO:
		ScriviStringa (Ev.Str);
		break;

	case TRACK_NAME:
		ScriviStringa (Ev.Str);
		break;

	case INSTRUMENT_NAME:
		ScriviStringa (Ev.Str);
		break;

	case LYRIC:
		ScriviStringa (Ev.Str);
		break;

	case MARKER:
		ScriviStringa (Ev.Str);
		break;

	case CUE_POINT:
		ScriviStringa (Ev.Str);
		break;

	case SET_TEMPO:
		break;

	case SMPTE_EV:
		break;

	case TIME_SIGNATURE:
		break;

	case KEY_SIGNATURE:
		break;

	case NOTE_OFF:
		break;

	case NOTE_ON:
		break;

	case KEY_AFTER_TOUCH:
		break;

	case CONTROL_CHANGE:
		break;

	case PROGRAM_CHANGE:
		break;

	case CHANNEL_AFTER_TOUCH:
		break;

	case PITCH_WHEEL:
		break;

	}

return 0;
}

//----------------------------------------------------------------------
int CTrack::Scrivi()	
//----------------------------------------------------------------------
{
	unsigned long TrackLen=0;	//lunghezza in byte della traccia

	ScriviDWord (1297379947);	//MTrk
	ScriviDWord (TrackLen);		//importante!!!!
								//per ora scrivo 0, ma dopo dovro' scrivere
								//la lunghezza in byte giusta!!!
	
	
	CEvent Ev;
	Ev = GetEv();
	
	if (Ev.Tipo<128) ScriviMetaEv (Ev);

return 0;
}







//************************************************************************
















//********************************************************************
//						C Standard Midi File
//********************************************************************

//--------------------------------------------------------------------
CSMF::CSMF()	//ctor
//--------------------------------------------------------------------
{

	pTraccia.clear();	//pulisco tutto

}


//--------------------------------------------------------------------
CSMF::~CSMF()	//dtor
//--------------------------------------------------------------------
{
	Chiudi();

	//cancello tutte le tracce
	CTrack *Temp;
	while (!pTraccia.empty())
	{
		Temp = pTraccia.back();
		delete Temp;
		Temp=NULL;
		pTraccia.pop_back();
	}
}






//---------------------------------------------------------------------
int CSMF::Apri (char *Filename)
//---------------------------------------------------------------------
// err 1: Non riesco ad aprire il file per la lettura
{
	Chiudi();	//se il file e' gia' aperto in scrittura o in lettura viene chiuso
	HandleFile = fopen(Filename,"rb");
	
	if (!HandleFile) return 1;
	
return 0;
}



//---------------------------------------------------------------------
int CSMF::Salva (char *Filename)
//---------------------------------------------------------------------
// Err 1: Non riesco ad aprire il file per la scrittura
{
	Chiudi();	//se il file e' gia' aperto in scrittura o in lettura viene chiuso
	HandleFile = fopen(Filename,"wb");

	if (!HandleFile) return 1;

return 0;
}



//-----------------------------------------------------------------------
int CSMF::Leggi()
//-----------------------------------------------------------------------
// Err 1: File non ancora aperto
// Err 2: Errore lettura traccia
// Err 3: Errore lettura Header
{
	if (!HandleFile) return 1;

	if (Header.Leggi()!=0) return 3;

	//allocazione  e lettura di n tracce
	CTrack *NewTrk;

	for (int I=0; I<Header.nTracce; I++)
	{
		NewTrk= new CTrack;
		pTraccia.push_back(NewTrk);

		if (pTraccia[I]->Leggi()) return 2;
	}

	return 0;
}


//-------------------------------------------------------------------------
int CSMF::Scrivi()		//da fare
//-------------------------------------------------------------------------
//	Err 1: File non ancora aperto
//	Err 2: Err scrittura header
//	Err 3: Err scrittura traccia
{
	if (!HandleFile) return 1;
	if (Header.Scrivi()) return 2;

	//scrivi tracce
	for (int I=0; I<Header.nTracce; I++)
	{
		if (pTraccia[I]->Scrivi()) return 3;
	}
	return 0;
}


//-------------------------------------------------------------------------
int CSMF::Reset()
//-------------------------------------------------------------------------
{
	Chiudi();

	//cancello tutte le tracce
	CTrack *Temp;
	while (!pTraccia.empty())
	{
		Temp = pTraccia.back();
		delete Temp;
		Temp=NULL;
		pTraccia.pop_back();
	}


	Header.Formato = -1;
	Header.nTracce = -1;
	Header.TPQN = -1;
return 0;
}



//---------------------------------------------------------------------
int CSMF::Chiudi()
//---------------------------------------------------------------------
{
	if (HandleFile) 
	{
		fclose(HandleFile);
		HandleFile=NULL;

	}
return 0;
}


//*************************************************************************

