//	SMFReader.h
//	13/aprile/2000	>>CoMiX<<


#ifndef _SMFREADER_H
#define _SMFREADER_H


#include <stdio.h>
#include <deque>


#define MAX_STRING	50


#define		TRACK_SEQ_NUMBER	0	
#define		TEXT_EVENT			1	
#define		COPYRIGHT_INFO		2	
#define		TRACK_NAME			3	
#define		INSTRUMENT_NAME		4	
#define		LYRIC				5	
#define		MARKER				6	
#define		CUE_POINT			7	
#define		SET_TEMPO			81	
#define		SMPTE_EV			84	//ok ignorato
#define		TIME_SIGNATURE		88	//ok da finire	
#define		KEY_SIGNATURE		89	//ok da fare	
#define		SYSEX1				127	//ok ignorato 
#define		SYSEX2				240	//ok ignorato

#define		STRANO1				33	//ok molto strano!!!!!!!!!!!!!!!
#define		STRANO2				32	//ok molto strano!!!!!!!!!!!!!!!


//CANALE 0
#define		NOTE_OFF			128	//ok
#define		NOTE_ON				144	//ok
#define		KEY_AFTER_TOUCH		160		
#define		CONTROL_CHANGE		176		
#define		PROGRAM_CHANGE		192		
#define		CHANNEL_AFTER_TOUCH	208		
#define		PITCH_WHEEL			224		



#define POSIZIONE unsigned long

//----------------------------------------------------------------------------------
class CEvent
{
public:
	int Tipo,
		Data1,
		Data2,
		Canale;


	POSIZIONE Pos;

	CEvent();	//ctor
	~CEvent() {}	//dtor


	char Str[MAX_STRING];	//stringa
};


//----------------------------------------------------------------------------------



class CBase
{
public:

	CBase() {}
	~CBase() {}
	unsigned int LeggiByte();
	unsigned int LeggiWord();
	unsigned long LeggiDWord();
	int LeggiStringa (char *Str);
	POSIZIONE LeggiDelta();

	void ScriviByte (short int Byte);
	void ScriviWord (int Word);
	void ScriviDWord (long DWord);
	void ScriviStringa (char *Str);
	void ScriviDelta (POSIZIONE Delta);
	
	
protected:
	static FILE* HandleFile; /// static!!! viene utilizzato sempre lo stesso per tutte le classi derivate
};




//----------------------------------------------------------------------------------
class CHeader : public CBase
{
public:
	int Formato,
		nTracce,
		TPQN;

	CHeader ();	//ctor
	~CHeader() {};	//dtor

	int Leggi();
	int Scrivi();	//da fare
};
		


//----------------------------------------------------------------------------------
class CTrack : public CBase
{
public:
	unsigned long CurPos;
	POSIZIONE CurDelta;
	int BPM;
	unsigned long nEventi;	
	
	CTrack ();	//ctor
	~CTrack();	//dtor

	CEvent GetEv();

	int Leggi();
	int Scrivi();	//da fare

	std::deque<CEvent> Sequenza;
	
private:


	bool isTracciaFinita;
	unsigned long	TrackLen;
	int OldEv;
					

	int AddEv(CEvent &NewEvent);

	int LeggiMetaEv (POSIZIONE Delta);
	int LeggiNoteOff (POSIZIONE Delta, int Canale);
	int LeggiNoteOn (POSIZIONE Delta, int Canale);
	int LeggiKeyAfterTouch (POSIZIONE Delta, int Canale);
	int LeggiControlChange (POSIZIONE Delta, int Canale);
	int LeggiProgramChange (POSIZIONE Delta, int Canale);
	int LeggiChannelAfterTouch (POSIZIONE Delta, int Canale);
	int LeggiPitchWheel (POSIZIONE Delta, int Canale);


	int ScriviMetaEv(CEvent &Ev);	//
};



//---------------------------------------------------------------------
class CSMF: public CBase
{
public:
	CHeader Header;
	std::deque<CTrack*> pTraccia;

	CSMF();		//ctor
	~CSMF();	//dtor
	int Apri (char *Filename);
	int Leggi();
	

	int Salva (char *Filename);	// da fare
	int Scrivi();	// da fare

	
	int Reset();
	int Chiudi();

};



#endif