/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.util.DateTool;

class XmlWriter
extends OutputStreamWriter {
    protected static final String PROLOG_START = "<?xml version=\"1.0\" encoding=\"";
    protected static final String PROLOG_END = "\"?>";
    protected static final String CLOSING_TAG_START = "</";
    protected static final String SINGLE_TAG_END = "/>";
    protected static final String LESS_THAN_ENTITY = "&lt;";
    protected static final String GREATER_THAN_ENTITY = "&gt;";
    protected static final String AMPERSAND_ENTITY = "&amp;";
    protected static final String ISO8859_1 = "ISO8859_1";
    protected static final String UTF8 = "UTF8";
    private static Properties encodings = new Properties();
    private static DateTool dateTool;

    public XmlWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException, IOException {
        super(outputStream, string);
        this.write(PROLOG_START);
        this.write(XmlWriter.canonicalizeEncoding(string));
        this.write(PROLOG_END);
    }

    protected static String canonicalizeEncoding(String string) {
        return encodings.getProperty(string, string);
    }

    public void writeObject(Object object) throws XmlRpcException, IOException {
        this.startElement("value");
        if (object == null) {
            throw new IllegalArgumentException("null values not supported by XML-RPC");
        }
        if (object instanceof String) {
            this.chardata(object.toString());
        } else if (object instanceof Integer) {
            this.startElement("int");
            this.write(object.toString());
            this.endElement("int");
        } else if (object instanceof Boolean) {
            this.startElement("boolean");
            this.write((Boolean)object != false ? "1" : "0");
            this.endElement("boolean");
        } else if (object instanceof Double || object instanceof Float) {
            this.startElement("double");
            this.write(object.toString());
            this.endElement("double");
        } else if (object instanceof Date) {
            this.startElement("dateTime.iso8601");
            Date date = (Date)object;
            this.write(dateTool.format(date));
            this.endElement("dateTime.iso8601");
        } else if (object instanceof byte[]) {
            this.startElement("base64");
            this.write(Base64.encode((byte[])object));
            this.endElement("base64");
        } else if (object instanceof Object[]) {
            this.startElement("array");
            this.startElement("data");
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.writeObject(objectArray[i]);
            }
            this.endElement("data");
            this.endElement("array");
        } else if (object instanceof Vector) {
            this.startElement("array");
            this.startElement("data");
            Vector vector = (Vector)object;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.writeObject(vector.elementAt(i));
            }
            this.endElement("data");
            this.endElement("array");
        } else if (object instanceof Hashtable) {
            this.startElement("struct");
            Hashtable hashtable = (Hashtable)object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = hashtable.get(string);
                this.startElement("member");
                this.startElement("name");
                this.chardata(string);
                this.endElement("name");
                this.writeObject(v);
                this.endElement("member");
            }
            this.endElement("struct");
        } else {
            throw new RuntimeException("unsupported Java type: " + object.getClass());
        }
        this.endElement("value");
    }

    protected void write(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            this.write(byArray[i]);
        }
    }

    protected void startElement(String string) throws IOException {
        this.write(60);
        this.write(string);
        this.write(62);
    }

    protected void endElement(String string) throws IOException {
        this.write(CLOSING_TAG_START);
        this.write(string);
        this.write(62);
    }

    protected void emptyElement(String string) throws IOException {
        this.write(60);
        this.write(string);
        this.write(SINGLE_TAG_END);
    }

    protected void chardata(String string) throws XmlRpcException, IOException {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    this.write(c);
                    continue block6;
                }
                case '<': {
                    this.write(LESS_THAN_ENTITY);
                    continue block6;
                }
                case '>': {
                    this.write(GREATER_THAN_ENTITY);
                    continue block6;
                }
                case '&': {
                    this.write(AMPERSAND_ENTITY);
                    continue block6;
                }
                default: {
                    if (c < ' ' || c > '\u00ff') {
                        throw new XmlRpcException(0, "Invalid character data corresponding to XML entity &#" + String.valueOf((int)c) + ';');
                    }
                    this.write(c);
                }
            }
        }
    }

    static {
        encodings.put(UTF8, "UTF-8");
        encodings.put(ISO8859_1, "ISO-8859-1");
        dateTool = new DateTool();
    }
}

