/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import java.util.Vector;
import snoozesoft.systray4j.SubMenu;
import snoozesoft.systray4j.SysTrayManager;
import snoozesoft.systray4j.SysTrayMenu;
import snoozesoft.systray4j.SysTrayMenuEvent;
import snoozesoft.systray4j.SysTrayMenuListener;

public class SysTrayMenuItem {
    protected String label;
    protected boolean enabled;
    protected Vector containers;
    protected String actionCommand;
    protected Vector listeners;

    public SysTrayMenuItem(String label) {
        this(label, "");
    }

    public SysTrayMenuItem(String label, String actionCommand) {
        this.label = label;
        this.actionCommand = actionCommand;
        this.listeners = new Vector();
        this.containers = new Vector();
        this.enabled = true;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!this.label.equals(label)) {
            Object menu = null;
            for (int i = 0; i < this.containers.size(); ++i) {
                menu = this.containers.get(i);
                if (menu instanceof SysTrayMenu) {
                    SysTrayMenu mainMenu = menu;
                    SysTrayManager.setItemLabel(mainMenu.id, mainMenu.items.indexOf(this), label);
                    continue;
                }
                SubMenu subMenu = menu;
                SysTrayManager.setItemLabel(subMenu.id, subMenu.items.indexOf(this), label);
            }
            this.label = label;
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public void addSysTrayMenuListener(SysTrayMenuListener listener) {
        this.listeners.add(listener);
    }

    public void removeSysTrayMenuListener(SysTrayMenuListener listener) {
        this.listeners.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            Object menu = null;
            for (int i = 0; i < this.containers.size(); ++i) {
                menu = this.containers.get(i);
                if (menu instanceof SysTrayMenu) {
                    SysTrayMenu mainMenu = menu;
                    SysTrayManager.enableItem(mainMenu.id, mainMenu.items.indexOf(this), enabled);
                    continue;
                }
                SubMenu subMenu = menu;
                SysTrayManager.enableItem(subMenu.id, subMenu.items.indexOf(this), enabled);
            }
            this.enabled = enabled;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void fireMenuItemSelected() {
        SysTrayMenuListener listener = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            listener = (SysTrayMenuListener)this.listeners.elementAt(i);
            listener.menuItemSelected(new SysTrayMenuEvent(this, this.actionCommand));
        }
    }

    protected void addContainer(Object menu) {
        this.containers.add(menu);
    }

    protected void removeContainer(Object menu) {
        this.containers.remove(menu);
    }
}

