/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.Cmd;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.Log;
import net.sf.launch4j.RcBuilder;
import net.sf.launch4j.Util;
import net.sf.launch4j.binding.InvariantViolationException;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;

public class Builder {
    private final Log _log;

    public Builder(Log log) {
        this._log = log;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File build() throws BuilderException {
        File file;
        Config c = ConfigPersister.getInstance().getConfig();
        try {
            c.validate();
        }
        catch (InvariantViolationException e) {
            throw new BuilderException(e.getMessage());
        }
        File rc = null;
        File ro = null;
        File outfile = null;
        FileInputStream is = null;
        FileOutputStream os = null;
        RcBuilder rcb = new RcBuilder();
        try {
            try {
                String basedir = Util.getJarBasedir();
                if (basedir == null) {
                    basedir = ".";
                }
                rc = rcb.build(c);
                ro = File.createTempFile("launch4j", "o");
                outfile = ConfigPersister.getInstance().getOutputFile();
                Cmd resCmd = new Cmd(basedir);
                resCmd.addExe("/bin/windres").add(Util.WINDOWS_OS ? "--preprocessor=type" : "--preprocessor=cat").add("-J rc -O coff -F pe-i386").add(rc.getPath()).add(ro.getPath());
                this._log.append("Compiling resources");
                Util.exec(resCmd.toString(), this._log);
                Cmd ldCmd = new Cmd(basedir);
                ldCmd.addExe("/bin/ld").add("-mi386pe").add("--oformat pei-i386").add(c.getHeaderType() == 0 ? "--subsystem windows" : "--subsystem console").add("-s").addFile("/w32api/crt2.o").addFile(c.getHeaderType() == 0 ? "/head/guihead.o" : "/head/consolehead.o").addFile("/head/head.o").addAbsFile(ro.getPath()).addFile("/w32api/libmingw32.a").addFile("/w32api/libgcc.a").addFile("/w32api/libmsvcrt.a").addFile("/w32api/libkernel32.a").addFile("/w32api/libuser32.a").addFile("/w32api/libadvapi32.a").addFile("/w32api/libshell32.a").add("-o").addAbsFile(outfile.getPath());
                this._log.append("Linking");
                Util.exec(ldCmd.toString(), this._log);
                this._log.append("Wrapping");
                byte[] buffer = new byte[1024];
                is = new FileInputStream(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), c.getJar()));
                os = new FileOutputStream(outfile, true);
                while (true) {
                    int len;
                    if ((len = is.read(buffer)) <= 0) {
                        this._log.append("Successfully created " + outfile.getPath());
                        file = outfile;
                        Object var13_18 = null;
                        break;
                    }
                    os.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                Util.delete(outfile);
                this._log.append(e.getMessage());
                throw new BuilderException(e);
            }
            catch (ExecException e) {
                Util.delete(outfile);
                String msg = e.getMessage();
                if (msg == null) throw new BuilderException(e);
                if (msg.indexOf("windres") == -1) throw new BuilderException(e);
                this._log.append("Generated resource file...\n");
                this._log.append(rcb.getContent());
                throw new BuilderException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            Util.close(is);
            Util.close(os);
            Util.delete(rc);
            Util.delete(ro);
            throw throwable;
        }
        Util.close(is);
        Util.close(os);
        Util.delete(rc);
        Util.delete(ro);
        return file;
    }
}

