/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import net.sf.launch4j.Util;

class Cmd {
    private final StringBuffer _sb = new StringBuffer();
    private final String _basedir;
    private final boolean _quote;

    public Cmd(String basedir) {
        this._basedir = basedir;
        this._quote = basedir.indexOf(32) != -1;
    }

    public Cmd add(String s) {
        this.space();
        this._sb.append(s);
        return this;
    }

    public Cmd addAbsFile(String file) {
        boolean quote;
        this.space();
        boolean bl = quote = file.indexOf(32) != -1;
        if (quote) {
            this._sb.append('\"');
        }
        this._sb.append(file);
        if (quote) {
            this._sb.append('\"');
        }
        return this;
    }

    public Cmd addFile(String file) {
        this.space();
        if (this._quote) {
            this._sb.append('\"');
        }
        this._sb.append(this._basedir);
        this._sb.append(file);
        if (this._quote) {
            this._sb.append('\"');
        }
        return this;
    }

    public Cmd addExe(String file) {
        return this.addFile(Util.WINDOWS_OS ? String.valueOf(file) + ".exe" : file);
    }

    private void space() {
        if (this._sb.length() > 0) {
            this._sb.append(' ');
        }
    }

    public String toString() {
        return this._sb.toString();
    }
}

