/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.sf.launch4j.Util;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;

public class RcBuilder {
    public static final int LANG_NEUTRAL = 0;
    public static final int SUBLANG_NEUTRAL = 0;
    public static final int SUBLANG_DEFAULT = 1;
    public static final int SUBLANG_SYS_DEFAULT = 2;
    public static final int APP_ICON = 1;
    public static final int SPLASH_BITMAP = 1;
    public static final int JRE_PATH = 1;
    public static final int JAVA_MIN_VER = 2;
    public static final int JAVA_MAX_VER = 3;
    public static final int SHOW_SPLASH = 4;
    public static final int SPLASH_WAITS_FOR_WINDOW = 5;
    public static final int SPLASH_TIMEOUT = 6;
    public static final int SPLASH_TIMEOUT_ERR = 7;
    public static final int CHDIR = 8;
    public static final int SET_PROC_NAME = 9;
    public static final int ERR_TITLE = 10;
    public static final int GUI_HEADER_STAYS_ALIVE = 11;
    public static final int JVM_ARGS = 12;
    public static final int JAR_ARGS = 13;
    private final StringBuffer _sb = new StringBuffer();

    public String getContent() {
        return this._sb.toString();
    }

    public File build(Config c) throws IOException {
        this._sb.append("LANGUAGE ");
        this._sb.append(0);
        this._sb.append(", ");
        this._sb.append(1);
        this._sb.append('\n');
        this.addVersionInfo(c.getVersionInfo());
        this.addJre(c.getJre());
        this.addIcon(1, c.getIcon());
        this.addText(10, c.getErrTitle());
        this.addText(13, c.getJarArgs());
        this.addWindowsPath(8, c.getChdir());
        this.addTrue(9, c.isCustomProcName());
        this.addTrue(11, c.isStayAlive());
        this.addSplash(c.getSplash());
        File f = File.createTempFile("launch4j", "rc");
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        w.write(this._sb.toString());
        w.close();
        return f;
    }

    private void addVersionInfo(VersionInfo v) {
        if (v == null) {
            return;
        }
        this._sb.append("1 VERSIONINFO\n");
        this._sb.append("FILEVERSION ");
        this._sb.append(v.getFileVersion().replaceAll("\\.", ", "));
        this._sb.append("\nPRODUCTVERSION ");
        this._sb.append(v.getProductVersion().replaceAll("\\.", ", "));
        this._sb.append("\nFILEFLAGSMASK 0\nFILEOS 0x40000\nFILETYPE 1\n{\n BLOCK \"StringFileInfo\"\n {\n  BLOCK \"040904E4\"\n  {\n");
        this.addVerBlockValue("CompanyName", v.getCompanyName());
        this.addVerBlockValue("FileDescription", v.getFileDescription());
        this.addVerBlockValue("FileVersion", v.getTxtFileVersion());
        this.addVerBlockValue("InternalName", v.getInternalName());
        this.addVerBlockValue("LegalCopyright", v.getCopyright());
        this.addVerBlockValue("OriginalFilename", v.getOriginalFilename());
        this.addVerBlockValue("ProductName", v.getProductName());
        this.addVerBlockValue("ProductVersion", v.getTxtProductVersion());
        this._sb.append("  }\n }\n}\n");
    }

    private void addJre(Jre jre) {
        this.addWindowsPath(1, jre.getPath());
        this.addText(2, jre.getMinVersion());
        this.addText(3, jre.getMaxVersion());
        StringBuffer jvmArgs = new StringBuffer();
        if (jre.getInitialHeapSize() > 0) {
            jvmArgs.append("-Xms");
            jvmArgs.append(jre.getInitialHeapSize());
            jvmArgs.append('m');
        }
        if (jre.getMaxHeapSize() > 0) {
            this.addSpace(jvmArgs);
            jvmArgs.append("-Xmx");
            jvmArgs.append(jre.getMaxHeapSize());
            jvmArgs.append('m');
        }
        if (jre.getArgs() != null && jre.getArgs().length() > 0) {
            this.addSpace(jvmArgs);
            jvmArgs.append(jre.getArgs().replaceAll("\n", " "));
        }
        this.addText(12, jvmArgs.toString());
    }

    private void addSplash(Splash splash) {
        if (splash == null) {
            return;
        }
        this.addTrue(4, true);
        this.addTrue(5, splash.getWaitForWindow());
        this.addText(6, String.valueOf(splash.getTimeout()));
        this.addTrue(7, splash.isTimeoutErr());
        this.addBitmap(1, splash.getFile());
    }

    private void addText(int id, String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" RCDATA BEGIN \"");
        this._sb.append(text);
        this._sb.append("\\0\" END\n");
    }

    private void addWindowsPath(int id, String path) {
        if (path == null || path.equals("")) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" RCDATA BEGIN \"");
        this._sb.append(path.replaceAll("\\\\", "\\\\\\\\").replaceAll("/", "\\\\\\\\"));
        this._sb.append("\\0\" END\n");
    }

    private void addTrue(int id, boolean value) {
        if (value) {
            this.addText(id, "true");
        }
    }

    private void addIcon(int id, File icon) {
        if (icon == null || icon.getPath().equals("")) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" ICON DISCARDABLE \"");
        this._sb.append(this.getPath(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), icon)));
        this._sb.append("\"\n");
    }

    private void addBitmap(int id, File bitmap) {
        if (bitmap == null) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" BITMAP \"");
        this._sb.append(this.getPath(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), bitmap)));
        this._sb.append("\"\n");
    }

    private String getPath(File f) {
        return f.getPath().replaceAll("\\\\", "\\\\\\\\");
    }

    private void addSpace(StringBuffer sb) {
        int len = sb.length();
        if (len-- > 0 && sb.charAt(len) != ' ') {
            sb.append(' ');
        }
    }

    private void addVerBlockValue(String key, String value) {
        this._sb.append("   VALUE \"");
        this._sb.append(key);
        this._sb.append("\", \"");
        if (value != null) {
            this._sb.append(value);
        }
        this._sb.append("\"\n");
    }
}

