/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.Log;

public class Util {
    public static final boolean WINDOWS_OS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    static /* synthetic */ Class class$0;

    private Util() {
    }

    public static String getJarBasedir() {
        String url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.launch4j.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("net.sf.launch4j.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = classLoader.getResource(String.valueOf(clazz2.getName().replace('.', '/')) + ".class").getFile().replaceAll("%20", " ")).startsWith("file:")) {
            String jar = url.substring(5, url.lastIndexOf(33));
            int x = jar.lastIndexOf(47);
            if (x == -1) {
                x = jar.lastIndexOf(92);
            }
            String basedir = jar.substring(0, x + 1);
            return new File(basedir).getPath();
        }
        return null;
    }

    public static File getAbsoluteFile(File basepath, File f) {
        return f.isAbsolute() ? f : new File(basepath, f.getPath());
    }

    public static String getExtension(File f) {
        String name = f.getName();
        int x = name.lastIndexOf(46);
        if (x != -1) {
            return name.substring(x);
        }
        return "";
    }

    public static void exec(String cmd, Log log) throws ExecException {
        BufferedReader is = null;
        try {
            String line;
            if (WINDOWS_OS) {
                cmd = cmd.replaceAll("/", "\\\\");
            }
            Process p = Runtime.getRuntime().exec(cmd);
            is = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = is.readLine()) != null) {
                log.append(line);
            }
            is.close();
            p.waitFor();
            if (p.exitValue() != 0) {
                String msg = "Exec failed (" + p.exitValue() + "): " + cmd;
                log.append(msg);
                throw new ExecException(msg);
            }
        }
        catch (IOException e) {
            Util.close(is);
            throw new ExecException(e);
        }
        catch (InterruptedException e) {
            Util.close(is);
            throw new ExecException(e);
        }
    }

    public static void close(InputStream o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void close(OutputStream o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void close(Reader o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void close(Writer o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static boolean delete(File f) {
        return f != null ? f.delete() : false;
    }
}

