/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.ant;

import java.io.File;
import net.sf.launch4j.Builder;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.Log;
import net.sf.launch4j.ant.AntConfig;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.ConfigPersisterException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Launch4jTask
extends Task {
    private File _configFile;
    private AntConfig _config;
    private File jar;
    private File outfile;
    private String fileVersion;
    private String txtFileVersion;
    private String productVersion;
    private String txtProductVersion;

    public void execute() throws BuildException {
        try {
            if (this._configFile != null && this._config != null) {
                throw new BuildException("Specify configFile or config");
            }
            if (this._configFile != null) {
                ConfigPersister.getInstance().load(this._configFile);
                Config c = ConfigPersister.getInstance().getConfig();
                if (this.jar != null) {
                    c.setJar(this.jar);
                }
                if (this.outfile != null) {
                    c.setOutfile(this.outfile);
                }
                if (this.fileVersion != null) {
                    c.getVersionInfo().setFileVersion(this.fileVersion);
                }
                if (this.txtFileVersion != null) {
                    c.getVersionInfo().setTxtFileVersion(this.txtFileVersion);
                }
                if (this.productVersion != null) {
                    c.getVersionInfo().setProductVersion(this.productVersion);
                }
                if (this.txtProductVersion != null) {
                    c.getVersionInfo().setTxtProductVersion(this.txtProductVersion);
                }
            } else if (this._config != null) {
                ConfigPersister.getInstance().setAntConfig(this._config, this.getProject().getBaseDir());
            } else {
                throw new BuildException("Specify configFile or config");
            }
            Builder b = new Builder(Log.getAntLog());
            b.build();
        }
        catch (ConfigPersisterException e) {
            throw new BuildException((Throwable)e);
        }
        catch (BuilderException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setConfigFile(File configFile) {
        this._configFile = configFile;
    }

    public void addConfig(AntConfig config) {
        this._config = config;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setOutfile(File outfile) {
        this.outfile = outfile;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setTxtFileVersion(String txtFileVersion) {
        this.txtFileVersion = txtFileVersion;
    }

    public void setTxtProductVersion(String txtProductVersion) {
        this.txtProductVersion = txtProductVersion;
    }
}

