/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import javax.swing.JRadioButton;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.PropertyUtils;

public class JRadioButtonBinding
implements Binding {
    private final String _property;
    private final JRadioButton[] _buttons;
    private final int _defaultValue;
    private final Color _validColor;

    public JRadioButtonBinding(String property, JRadioButton[] buttons, int defaultValue) {
        if (property == null || buttons == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i] != null) continue;
            throw new NullPointerException();
        }
        if (property.equals("") || buttons.length == 0 || defaultValue < 0 || defaultValue >= buttons.length) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._buttons = buttons;
        this._defaultValue = defaultValue;
        this._validColor = buttons[0].getBackground();
    }

    public String getProperty() {
        return this._property;
    }

    public void clear() {
        this.select(this._defaultValue);
    }

    public void put(IValidatable bean) {
        try {
            Integer i = (Integer)PropertyUtils.getProperty(bean, this._property);
            if (i == null) {
                throw new BindingException("Property is null");
            }
            this.select(i);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void get(IValidatable bean) {
        try {
            for (int i = 0; i < this._buttons.length; ++i) {
                if (!this._buttons[i].isSelected()) continue;
                PropertyUtils.setProperty(bean, this._property, new Integer(i));
                return;
            }
            throw new BindingException("Nothing selected");
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private void select(int index) {
        if (index < 0 || index >= this._buttons.length) {
            throw new BindingException("Button index out of bounds");
        }
        this._buttons[index].setSelected(true);
    }

    public void markValid() {
        for (int i = 0; i < this._buttons.length; ++i) {
            if (!this._buttons[i].isSelected()) continue;
            this._buttons[i].setBackground(this._validColor);
            this._buttons[i].requestFocusInWindow();
            return;
        }
        throw new BindingException("Nothing selected");
    }

    public void markInvalid() {
        for (int i = 0; i < this._buttons.length; ++i) {
            if (!this._buttons[i].isSelected()) continue;
            this._buttons[i].setBackground(Binding.INVALID_COLOR);
            return;
        }
        throw new BindingException("Nothing selected");
    }

    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttons[i].setEnabled(enabled);
        }
    }
}

