/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import javax.swing.JToggleButton;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.PropertyUtils;

public class JToggleButtonBinding
implements Binding {
    private final String _property;
    private final JToggleButton _button;
    private final boolean _defaultValue;
    private final Color _validColor;

    public JToggleButtonBinding(String property, JToggleButton button, boolean defaultValue) {
        if (property == null || button == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._button = button;
        this._defaultValue = defaultValue;
        this._validColor = this._button.getBackground();
    }

    public String getProperty() {
        return this._property;
    }

    public void clear() {
        this._button.setSelected(this._defaultValue);
    }

    public void put(IValidatable bean) {
        try {
            Boolean b = (Boolean)PropertyUtils.getProperty(bean, this._property);
            this._button.setSelected(b != null && b != false);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void get(IValidatable bean) {
        try {
            PropertyUtils.setProperty(bean, this._property, this._button.isSelected());
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void markValid() {
        this._button.setBackground(this._validColor);
        this._button.requestFocusInWindow();
    }

    public void markInvalid() {
        this._button.setBackground(Binding.INVALID_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this._button.setEnabled(enabled);
    }
}

