/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.io.File;
import java.util.List;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;

public class Config
implements IValidatable {
    public static final String HEADER = "header";
    public static final String JAR = "jar";
    public static final String OUTFILE = "outfile";
    public static final String ERR_TITLE = "errTitle";
    public static final String JAR_ARGS = "jarArgs";
    public static final String CHDIR = "chdir";
    public static final String CUSTOM_PROC_NAME = "customProcName";
    public static final String STAY_ALIVE = "stayAlive";
    public static final String ICON = "icon";
    public static final int GUI_HEADER = 0;
    public static final int CONSOLE_HEADER = 1;
    public static final int CUSTOM_HEADER = 2;
    private int headerType;
    private List headerObjects;
    private List libs;
    private File jar;
    private File outfile;
    private String errTitle;
    private String jarArgs;
    private String chdir;
    private boolean customProcName = false;
    private boolean stayAlive = false;
    private File icon;
    private Jre jre;
    private Splash splash;
    private VersionInfo versionInfo;

    public void checkInvariants() {
        Validator.checkTrue(this.outfile != null && this.outfile.getPath().endsWith(".exe"), OUTFILE, "Specify output file with .exe extension.");
        Validator.checkFile(this.jar, JAR, "Application jar");
        if (!Validator.isEmpty(this.chdir)) {
            Validator.checkRelativeWinPath(this.chdir, CHDIR, "'chdir' must be a path relative to the executable.");
            Validator.checkFalse(this.chdir.toLowerCase().equals("true") || this.chdir.toLowerCase().equals("false"), CHDIR, "'chdir' is now a path instead of a boolean, please check the docs.");
        }
        Validator.checkOptFile(this.icon, ICON, "Icon");
        Validator.checkOptString(this.jarArgs, 128, JAR_ARGS, "Jar arguments");
        Validator.checkOptString(this.errTitle, 128, ERR_TITLE, "Error title");
        Validator.checkRange(this.headerType, 0, 1, "headerType", "Invalid header type");
        Validator.checkTrue(this.headerType != 1 || this.splash == null, "headerType", "Splash screen is not implemented by console header.");
        this.jre.checkInvariants();
    }

    public void validate() {
        this.checkInvariants();
        if (this.splash != null) {
            this.splash.checkInvariants();
        }
        if (this.versionInfo != null) {
            this.versionInfo.checkInvariants();
        }
    }

    public String getChdir() {
        return this.chdir;
    }

    public void setChdir(String chdir) {
        this.chdir = chdir;
    }

    public String getJarArgs() {
        return this.jarArgs;
    }

    public void setJarArgs(String jarArgs) {
        this.jarArgs = jarArgs;
    }

    public String getErrTitle() {
        return this.errTitle;
    }

    public void setErrTitle(String errTitle) {
        this.errTitle = errTitle;
    }

    public int getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(int headerType) {
        this.headerType = headerType;
    }

    public List getHeaderObjects() {
        return this.headerObjects;
    }

    public void setHeaderObject(List headerObjects) {
        this.headerObjects = headerObjects;
    }

    public List getLibs() {
        return this.libs;
    }

    public void setLibs(List libs) {
        this.libs = libs;
    }

    public File getIcon() {
        return this.icon;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public File getJar() {
        return this.jar;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public Jre getJre() {
        return this.jre;
    }

    public void setJre(Jre jre) {
        this.jre = jre;
    }

    public File getOutfile() {
        return this.outfile;
    }

    public void setOutfile(File outfile) {
        this.outfile = outfile;
    }

    public boolean isCustomProcName() {
        return this.customProcName;
    }

    public void setCustomProcName(boolean customProcName) {
        this.customProcName = customProcName;
    }

    public Splash getSplash() {
        return this.splash;
    }

    public void setSplash(Splash splash) {
        this.splash = splash;
    }

    public boolean isStayAlive() {
        return this.stayAlive;
    }

    public void setStayAlive(boolean stayAlive) {
        this.stayAlive = stayAlive;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }
}

