/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import net.sf.launch4j.Util;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersisterException;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.Splash;

public class ConfigPersister {
    private static final ConfigPersister _instance = new ConfigPersister();
    private final XStream _xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
    private Config _config;
    private File _configPath;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private ConfigPersister() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.launch4j.config.Config");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._xstream.alias("launch4jConfig", (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("net.sf.launch4j.config.Jre");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._xstream.alias("jre", (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("net.sf.launch4j.config.Splash");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._xstream.alias("splash", (Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("net.sf.launch4j.config.VersionInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._xstream.alias("versionInfo", (Class)clazz4);
    }

    public static ConfigPersister getInstance() {
        return _instance;
    }

    public Config getConfig() {
        return this._config;
    }

    public File getConfigPath() {
        return this._configPath;
    }

    public File getOutputPath() throws IOException {
        if (this._config.getOutfile().isAbsolute()) {
            return this._config.getOutfile().getParentFile();
        }
        File parent = this._config.getOutfile().getParentFile();
        return parent != null ? new File(this._configPath, parent.getPath()) : this._configPath;
    }

    public File getOutputFile() throws IOException {
        return this._config.getOutfile().isAbsolute() ? this._config.getOutfile() : new File(this.getOutputPath(), this._config.getOutfile().getName());
    }

    public void createBlank() {
        this._config = new Config();
        this._config.setJre(new Jre());
        this._configPath = null;
    }

    public void setAntConfig(Config c, File basedir) {
        this._config = c;
        this._configPath = basedir;
    }

    public void load(File f) throws ConfigPersisterException {
        try {
            BufferedReader r = new BufferedReader(new FileReader(f));
            this._config = (Config)this._xstream.fromXML((Reader)r);
            r.close();
            this.setConfigPath(f);
        }
        catch (Exception e) {
            throw new ConfigPersisterException(e);
        }
    }

    public void loadVersion1(File f) throws ConfigPersisterException {
        try {
            Props props = new Props(f);
            this._config = new Config();
            String header = props.getProperty("header");
            this._config.setHeaderType(header == null || header.toLowerCase().equals("guihead.bin") ? 0 : 1);
            this._config.setJar(props.getFile("jar"));
            this._config.setOutfile(props.getFile("outfile"));
            this._config.setJre(new Jre());
            this._config.getJre().setPath(props.getProperty("jrepath"));
            this._config.getJre().setMinVersion(props.getProperty("javamin"));
            this._config.getJre().setMaxVersion(props.getProperty("javamax"));
            this._config.getJre().setArgs(props.getProperty("jvmArgs"));
            this._config.setJarArgs(props.getProperty("jarArgs"));
            this._config.setChdir("true".equals(props.getProperty("chdir")) ? "." : null);
            this._config.setCustomProcName("true".equals(props.getProperty("setProcName")));
            this._config.setStayAlive("true".equals(props.getProperty("stayAlive")));
            this._config.setErrTitle(props.getProperty("errTitle"));
            this._config.setIcon(props.getFile("icon"));
            File splashFile = props.getFile("splash");
            if (splashFile != null) {
                this._config.setSplash(new Splash());
                this._config.getSplash().setFile(splashFile);
                String waitfor = props.getProperty("waitfor");
                this._config.getSplash().setWaitForWindow(waitfor != null && !waitfor.equals(""));
                String splashTimeout = props.getProperty("splashTimeout");
                if (splashTimeout != null) {
                    this._config.getSplash().setTimeout(Integer.parseInt(splashTimeout));
                }
                this._config.getSplash().setTimeoutErr("true".equals(props.getProperty("splashTimeoutErr")));
            } else {
                this._config.setSplash(null);
            }
            this.setConfigPath(f);
        }
        catch (IOException e) {
            throw new ConfigPersisterException(e);
        }
    }

    public void save(File f) throws ConfigPersisterException {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            this._xstream.toXML((Object)this._config, (Writer)w);
            w.close();
            this.setConfigPath(f);
        }
        catch (Exception e) {
            throw new ConfigPersisterException(e);
        }
    }

    private void setConfigPath(File configFile) {
        this._configPath = configFile.getAbsoluteFile().getParentFile();
    }

    private class Props {
        final Properties _properties = new Properties();

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Props(File f) throws IOException {
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                this._properties.load(is);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Util.close(is);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            Util.close(is);
        }

        public String getProperty(String key) {
            String p = this._properties.getProperty(key);
            if (p == null) {
                return null;
            }
            int x = p.indexOf(35);
            if (x == -1) {
                return p;
            }
            while (--x > 0 && (p.charAt(x) == ' ' || p.charAt(x) == '\t')) {
            }
            return x == 0 ? "" : p.substring(0, x + 1);
        }

        public File getFile(String key) {
            String value = this.getProperty(key);
            return value != null ? new File(value) : null;
        }
    }
}

